import sys
import os

def vum_checksum(data: bytes) -> int:
    crc = 0
    length = len(data)
    aligned = length & ~3

    for i in range(0, aligned, 4):
        word = (
            (data[i]   << 24) |
            (data[i+1] << 16) |
            (data[i+2] << 8)  |
            (data[i+3])
        )
        crc ^= word

    rem = length - aligned
    if rem == 1:
        crc ^= ~ (data[aligned] << 24) & 0xFFFFFFFF
    elif rem == 2:
        crc ^= ((data[aligned] << 24) |
                (data[aligned+1] << 16) |
                0x0000FFFF)
    elif rem == 3:
        crc ^= ((data[aligned] << 24) |
                (data[aligned+1] << 16) |
                (data[aligned+2] << 8) |
                0x000000FF)

    return crc & 0xFFFFFFFF

with open(sys.argv[1], "rb") as uvp:
    filesize = os.path.getsize(sys.argv[1])
    data = uvp.read(filesize - 160)
    chk = vum_checksum(data)
    print(f"{chk}")

