with open("NAND.bin", "rb") as infile, open("unsharp.bin", "wb") as outfile:
    while True:
        file_offset = infile.tell()
            
        # 1. keep 1024 bytes
        keep = infile.read(1024)
        if not keep:
            break  # file end
        outfile.write(keep)

        # 2. save 4 bytes for later(dont write to output)
        save_bytes = infile.read(4)

        # 3. discard 28
        infile.read(28)

        # 4. keep 992
        keep = infile.read(992)
        outfile.write(keep)

        # 5. check if FF FF FF FF, write saved bytes, 00 00 00 00 is ok
        check_bytes = infile.read(4)
        if not check_bytes == b'\xFF\xFF\xFF\xFF':
            print(f"expected FF FF FF FF but found {check_bytes.hex().upper()} at offset {infile.tell() - 4} !") 
        outfile.write(save_bytes)

        # 6. keep 28 bytes
        keep = infile.read(28)
        outfile.write(keep)

        # 7. discard 32 bytes
        infile.read(32)
            
        # total processed 2112 bytes -> 2048 output (64 oob)