#!/bin/sh
P2P_HOSTIP='172.29.243.225'
P2P_INTF='wl0.1'
DRIVER=$(cat /tmp/wlan-driver)
[ "$DRIVER" == "realtek" ] && P2P_INTF='wlan1'

ALLOW_MAC_LIST=/nvram/p2p_allow_mac
PMAN_PERSIST=/nvram/pman_persist

init_rules() {
    #init iptables rules
    echo "=== P2P Firewall: Init iptables rules ==="

    iptables -F
    iptables -P INPUT ACCEPT
    iptables -P FORWARD ACCEPT
    iptables -P OUTPUT ACCEPT

    # Restore allow MAC list
    MAC_LIST=$(cat $ALLOW_MAC_LIST)
    for MACADDR in $MAC_LIST
    do
        iptables -A INPUT -i "$P2P_INTF" -m mac --mac-source "$MACADDR" -j ACCEPT
    done

    # Pickup any previously paired peripherals
    while read LINE
    do
        MACADDR=$(echo $LINE | cut -d' ' -f 4)
        DUPLICATE=$(iptables -C INPUT -i "$P2P_INTF" -m mac --mac-source "$MACADDR" -j ACCEPT 2> /dev/null)
        if [ ! $DUPLICATE ]; then
            iptables -A INPUT -i "$P2P_INTF" -m mac --mac-source "$MACADDR" -j ACCEPT
        fi
    done < $PMAN_PERSIST

    # Allow locally sourced data
    iptables -A INPUT -i "$P2P_INTF" -s "$P2P_HOSTIP" -j ACCEPT

    # Unfortunately previous version of Malone didn't have firewall enabled so open the port for Elk
    # to prevent having to re-pair Elk remotes
    PLATFORM=`roku_platform`
    if [ "$PLATFORM" == "malone" ]; then
        #Elk
        iptables -A INPUT -i "$P2P_INTF" -d "$P2P_HOSTIP" -p udp -m udp --dport 7700 -j ACCEPT        
    fi

    # Allow DNS
    iptables -A INPUT -i "$P2P_INTF" -p udp --dport 67:68 --sport 67:68 -j ACCEPT
    # Allow Miracast
    iptables -A INPUT -i "$P2P_INTF" -m state --state RELATED,ESTABLISHED -j ACCEPT
    iptables -A INPUT -i "$P2P_INTF" -d "$P2P_HOSTIP" -p tcp -m tcp --dport 9099 -j ACCEPT
    iptables -A INPUT -i "$P2P_INTF" -d "$P2P_HOSTIP" -p udp -m udp --dport 6500 -j ACCEPT
    # Miracast - ittiam
    iptables -A INPUT -i "$P2P_INTF" -d "$P2P_HOSTIP" -p tcp -m tcp --dport 12000 -j ACCEPT
    iptables -A INPUT -i "$P2P_INTF" -d "$P2P_HOSTIP" -p udp -m udp --dport 1028 -j ACCEPT
    # Drop everything else
    iptables -A INPUT -i "$P2P_INTF" -j DROP

    return 0
}

drop_privilege() {
    MACADDR="$1"
    echo "=== P2P Firewall: Drop privilege for MAC: $MACADDR ===" | tee /dev/kmsg

    #just delete the rule
    iptables -D INPUT -i "$P2P_INTF" -m mac --mac-source "$MACADDR" -j ACCEPT

    #delete mac address from allow list
    sed -i "/$MACADDR/d" $ALLOW_MAC_LIST

    return 0
}

grant_privilege() {
    MACADDR="$1"
    echo "=== P2P Firewall: Grant privilege for MAC: $MACADDR ===" | tee /dev/kmsg

    #check if rule already in iptables
    if iptables -C INPUT -i "$P2P_INTF" -m mac --mac-source "$MACADDR" -j ACCEPT &>/dev/null; then
        echo "Rule for $MACADDR already in iptables." | tee /dev/kmsg
    else
        iptables -I INPUT 1 -i "$P2P_INTF" -m mac --mac-source "$MACADDR" -j ACCEPT

	#add mac address to allow list
        echo "$MACADDR" >> $ALLOW_MAC_LIST
    fi

    return 0
}

COMMAND="$1"
case $COMMAND in
drop)
    if [ -z "$2" ]; then
        echo "Usage: $0 $1 MAC_ADRESS"
        return 1
    else
        drop_privilege "$2"
    fi
    ;;
grant)
    if [ -z "$2" ]; then
        echo "Usage: $0 $1 MAC_ADRESS"
        return 1
    else
        grant_privilege "$2"
    fi
    ;;
init)
    init_rules
    ;;
*)
    echo "unknown command"
    ;;
esac
