#!/bin/sh

# Automount script, called for ttyUSB[0-9] devices by custom command in mdev.conf

# Log stdout and stderr (enable/disable by switching commented lines)
#exec 1>/tmp/ttymount.log
exec 1>/dev/null
exec 2>&1
set -x

grep -v "manuimage=1" /proc/cmdline
manu_image=$?

if [ "$manu_image" != "1" ]; then
    echo "Not handling ttyUSB event. Not in mfg mode" > /dev/console &
    return
fi

if [ "$SUBSYSTEM" != "usb-serial" ]; then
    echo "Not handling ttyUSB event. Not usb-serial" > /dev/console &
    return
fi

event=$(dmesg | grep ttyUSB | tail -1)
if [ $(echo $event | awk '{print match($0,"attached")}') -gt "0" ]; then
    # Send an "attached" message to the application
    echo "TTYUSB device attached" > /dev/console &
    plethora msg-send /app-msd "attached"
elif [ $(echo $event | awk '{print match($0,"disconnected")}') -gt "0" ]; then
    # Send a "disconnected" message to the application
    echo "TTYUSB device disconnected"
    plethora msg-send /app-msd "disconnected" > /dev/console &
fi
