#!/bin/sh

chunk=3000
absmax=200000

if [ $# -lt 3 ]
then
    echo "Splits a file into $chunk byte chunks up to $absmax bytes"
    echo "Usage: split.sh <sourcefile> <destdir> <destfileprefix>"
    exit 1
fi

if [ "`stat -c %F $2`" != "directory" ]; then exit $?; fi


maxbytes=`stat -c %s $1`
if [ $? -ne 0 ]; then exit $?; fi
if [ $maxbytes -gt $absmax ]; then maxbytes=$absmax; fi


#echo len $maxbytes

cnt=0
total=0

while [ $total -le $maxbytes ]
do
    fout=$2/$3$cnt
#    echo $fout

    dd if=$1 of=$fout bs=$chunk count=1 skip=$cnt >/dev/null 2>&1
    cnt=`expr $cnt + 1`
    total=`expr $total + $chunk`
done
