function constructVMenuUI(params as Object) as Object
    o = m.constructBaseMenuNode({
        label: "VMenu",
        type: "VMenu",
        active: false,
        selectedIndex: 0,
        readOnly: false,
        handleKey: handleVMenuKey,
        displaymode: "SelectedOnly",

        draw: drawVMenuUI,
    })

    o = RokuMfgMerge(o, params)

    return o
end function

function handleVMenuKey(keycode as Integer)
        if m.readOnly then 
            return keycode
        end if

        ' Give the selected item a chance to handle the keypress.  Fallback to navigation
        ' otherwise.
        selected = m.getSelected()

        if invalid <> selected then
            newKeycode = selected.handleKey(keycode)

            if invalid = newKeycode then
                return invalid
            end if

            keycode = newKeycode
        else
            return keycode
        end if

        ' Up and down cases are pretty close to identical'
        if keycode = m.app.keycodes["UP"] or keycode = m.app.keycodes["DOWN"] then
            change = 1

            if keycode = m.app.keycodes["UP"] then
                change = -1
            end if

            if "roassociativeArray" = type(selected.data) and invalid <> selected.data.onExit then
                selected.data.onExit()
            end if

            ' Update navigation
            m.update(change)
            selected = m.getSelected()

            ' If the next node has an "onHighlight" callback, execute it.
            If invalid <> selected and invalid <> selected.onHighlight then
                selected.onHighlight()
            end if

            return invalid
        else if keycode = m.app.keycodes["LEFT"] or keycode = m.app.keycodes["MENU"] then
            if "roFunction" = type(m.onReturn) then
                m.onReturn()
            end if

            if "roAssociativeArray" = type(selected.data) and invalid <> selected.data.onExit then
                selected.data.onExit()
            end if

            m.exit()
            return invalid
        else if keycode = m.app.keycodes["RIGHT"] or keycode = m.app.keycodes["SELECT"] then
            ' To be cautious, need to handle the VMenu->VMenu case specifically.
            if "VMenu" = selected.type and true <> selected.readOnly then
                selected.update(0)

                if "roFunction" = type(selected.onEntry) then
                    selected.onEntry()
                end if

                return invalid
            end if
        end if

        return keycode
end function

sub drawVMenuUI(ctx as Object, layout as Object, params as Object)
    if "TopLevelMenu" <> m.parent.type then
        ctx.DrawMenuLabel(layout, params, m)
    end if


    if params.selected and 0 < m.children.count() then
        offset = params.offset
        depth = params.depth + 1

        if not m.readOnly then
            offset = 0
        end if

        activePath = false

        if invalid = m.selectedChild or ("VMenu" <> m.getSelected().type) or m.getSelected().readOnly then
            activePath = true
        end if

        for i = 0 to m.children.count() - 1
            child = m.children[i]

            color = "white"
            if m.readOnly then
                color = "cyan"
            end if

            'print indent + "Node type: " + nodetype
            xparams = { color: color, activePath: activePath, selected: false, depth: depth, offset: offset + i}

            ' Cyan if we selected a particular node, or if we're inside a
            ' currently-highlighted Read-Only vmenu node.
            ' don't forget about read only menus
            if i = m.selectedChild then
                xparams.color = "cyan"
                xparams.selected = true
            end if

            child.draw(ctx, layout, xparams)
        end for
    end if
end sub