function constructTopLevelMenuUI(params as Object) as Object
    o = m.constructBaseMenuNode({
        label: "TopLevelMenu",
        type: "TopLevelMenu",
        active: false,
        selectedChild: 0,
        displaymode: "SelectedOnly",
        handleKey: handleTopLevelMenuKey,
        draw: drawTopLevelMenuUI,
        update: updateSelectedTopLevelMenuItem,

        ' todo: add "style" to control display properties
        style: {
            offset: [30, 15],
            padding: [18, 6],
            background: "gray",
        }
    })

    o = RokuMfgMerge(o, params)

    return o
end function

function handleTopLevelMenuKey(keycode as Integer)
    if keycode = m.app.keycodes["DOWN"] then
        selected = m.getSelected()
        selected.selectedChild = 0

        ' Obtain the node we're about to go to.
        ' If the next node has an "onHighlight" callback, execute it.
        if "roFunction" = type(selected.onHighlight) then
            selected.onHighlight()
        end if

        return invalid
    else if keycode = m.app.keycodes["MENU"] and m.selectedChild > 0 then
        m.selectedChild = 0
        m.update(0)
        return invalid
    else if keycode = m.app.keycodes["LEFT"] then
        m.update(-1)
        return invalid
    else if keycode = m.app.keycodes["RIGHT"] then
        m.update(1)
        return invalid
    end if

    return keycode
end function

sub updateSelectedTopLevelMenuItem(change as Integer)
    newIndex = m.selectedChild + change

    if newIndex < 0
        newIndex = 0
    else if newIndex >= m.children.count() then
        newIndex = m.children.count() - 1
    end if

    m.selectedChild = newIndex
end sub

sub drawTopLevelMenuUI(ctx as Object, layout as Object, params as Object) As Object
    ' We only have one "TopLevelMenu" at a time, which we use as the title
    font = ctx.ui.fonts["title"]
    label = ctx.menuRoot.children[0].label
    x = font.GetOneLineWidth(label, ctx.dimensions.totalWidth)
    x = ctx.dimensions.x + (ctx.dimensions.totalWidth / 2) - (x / 2)

    layout.Push(m.ui.layoutText({
        text: ctx.menuRoot.children[0].label
        color: "white"
        font: font
        x: x
        y: 20
    }))

    ' Guaranteed to be valid
    m.getSelected().draw(ctx, layout, {color: "white", depth: -1, selected: true, offset: 0})
end sub