
function constructSelectorUI(params as Object) as Object
    o = m.constructBaseUINode({
        label: "Selector",
        type: "Selector",
        selected: false,
        data: invalid,
        displayMode: "Always",
        handleKey: handleSelectorKey,
        getDisplayValue: getSelectorUIDisplayValue,
        calculateWidth: calculateSelectorUIWidth,
        draw: drawSelectorUI
    })

    o = RokuMfgMerge(o, params)

    if type(o.data) <> "roAssociativeArray" or o.data.class_ <> "Selector" then
        print "FATAL ERROR: SelectorUI must have valid selector data!"
        stop
    end if

    return o
end function

function handleSelectorKey(keycode as Integer)
    if m.app.keycodes["RIGHT"] = keycode or m.app.keycodes["LEFT"] = keycode or m.app.keycodes["SELECT"] = keycode then
        change = 1

        if m.app.keycodes["LEFT"] = keycode then
            change = -1
        end if
        
        m.data.update(change)
        return invalid
    end if

    return keycode
end function

function getSelectorUIDisplayValue()
    return m.data.get()
end function

function calculateSelectorUIWidth(font as Object, baseWidth as Integer) as Integer
    currentIndex = m.data.index
    valueWidth = 0

    for i = 0 to m.data.dataset.count() - 1
        m.data.index = i
        value = m.data.get()
        valueWidth = RokuMfgMax(valueWidth, font.GetOneLineWidth(value, baseWidth))
    end for

    m.data.index = currentIndex
    return valueWidth
end function

sub drawSelectorUI(ctx as Object, layout As Object, params As Object) As Object
    indexval = m.data.index
    value = m.getDisplayValue()

    ctx.DrawMenuLabel(layout, params, m)

    if m.shouldShowValue(ctx, params) then
        params.depth = params.depth + 1
        if value = invalid then
            stop
        end if
        ctx.DrawMenuLabel(layout, params, {label: value})

        ' Draw arrows
        if 1 < m.data.dataset.count() then
            if true = params.selected then
                source_l = m.ui.arrows.arrow_left_selected
                source_r = m.ui.arrows.arrow_right_selected
            else
                source_l = m.ui.arrows.arrow_left
                source_r = m.ui.arrows.arrow_right
            end if

            y = layout[layout.count() - 1].y
            x = ctx.dimensions.columnleftoffsets[params.depth]
            
            layout.Push(m.ui.layoutImage({
                source: source_l
                x: x - 90
                y: y
            }))

            layout.Push(m.ui.layoutImage({
                source: source_r
                x: x + 90 - source_r.GetWidth()
                y: y
            }))
        end if
    end if
end sub