' ScreenStack manages the sequence of screens a user enters/exits.
' Screens can be menus, overlay/display screens, or simple one-off dialogs.
function constructScreenStack(app as Object) as Object
    o = {
        app: app,
        screenRegistry: {},
        stack: [],

        registerScreen: registerScreenStackScreen,
        clear: clearScreenStack,
        pop: popScreenStack,
        push: pushScreenStack,
        set: setScreenStack,
        getCurrent: getCurrentScreenStackScreen,
    }

    return o
end function

sub registerScreenStackScreen(screen as Object)
    if invalid <> m.screenRegistry[screen.name] then
        print "Warning: Registering screen with pre-existing name: " + screen.name
    end if

    m.screenRegistry[screen.name] = screen
end sub

sub clearScreenStack()
    while 1 < m.stack.count()
        m.pop()
    end while
end sub

sub popScreenStack()
    if 1 >= m.stack.count() then
        print "Not popping last screen"
        return
    end if

    screen = m.stack.pop()

    if "roFunction" = type(screen.onExit) then
        screen.isPop = true
        screen.onExit()
    end if

    if invalid <> screen.keyFilter then
        if not m.app.keyFilter.removeUntil(screen.keyFilter) then
            print "Warning, could not find keyFilter for current menu!"
        end if
    end if

    screen = m.stack.peek()

    if invalid = screen then
        return
    end if

    if "roFunction" = type(screen.onEntry) then
        screen.onEntry()
    end if

    if invalid <> screen.keyFilter then
        m.app.keyFilter.install(screen.keyFilter, screen)
    end if
end sub

sub pushScreenStack(nextScreen as Dynamic)
    screen = m.stack.peek()

    if invalid <> screen then
        if "roFunction" = type(screen.onExit) then
            m.getCurrent().isPop = false
            screen.onExit()
        end if

        if invalid <> screen.keyFilter then
            m.app.keyFilter.remove(screen.keyFilter)
        end if
    end if

    if -1 <> type(nextScreen).instr("Str") then
        name = nextScreen
        nextScreen = m.screenRegistry[name]

        if invalid = nextScreen then
            print "FATAL ERROR: No such screen exists: " + name
            stop
        end if
    end if

    m.stack.push(nextScreen)
    screen = m.stack.peek()

    if "roFunction" = type(screen.onEntry) then
        screen.onEntry()
    end if

    if invalid <> screen.keyFilter then
        m.app.keyFilter.install(screen.keyFilter, screen)
    end if
end sub

sub setScreenStack(screen as Dynamic)
    m.clear()
    m.push(screen)
end sub

function getCurrentScreenStackScreen()
    return m.stack.peek()
end function