function constructSMenuUI(params as Object) as Object
    o = m.constructBaseMenuNode({
        label: "SMenu",
        type: "SMenu",
        active: false,
        selectedIndex: 0,
        readOnly: false,
        handleKey: handleSMenuKey,
        displaymode: "Always",
        divider: CreateObject("roBitmap", "pkg:/images/divider.png"),
        fade: CreateObject("roBitmap", "pkg:/images/fade.png"),

        draw: drawSMenuUI
    })

    o = RokuMfgMerge(o, params)

    return o
end function

function handleSMenuKey(keycode as Integer)
        ' Give the selected item a chance to handle the keypress.  Fallback to navigation
        ' otherwise.
        selected = m.getSelected()

        if invalid <> selected then
            newKeycode = selected.handleKey(keycode)

            if invalid = newKeycode then
                return invalid
            end if

            keycode = newKeycode
        else
            return keycode
        end if

        ' Up and down cases are pretty close to identical'
        if keycode = m.app.keycodes["UP"] or keycode = m.app.keycodes["DOWN"] then
            change = 1

            if keycode = m.app.keycodes["UP"] then
                change = -1
            end if

            if "roassociativeArray" = type(selected.data) and invalid <> selected.data.onExit then
               selected.data.onExit()
            end if

            ' Update navigation
            m.update(change)
            selected = m.getSelected()
            while "Divider" = selected.type or "Never" = selected.displayMode or true = selected.readOnly
                m.update(change)
                selected = m.getSelected()
            end while

            ' If the next node has an "onHighlight" callback, execute it.
            if invalid <> selected and invalid <> selected.onHighlight then
                print "onHighlight"
                selected.onHighlight()
            end if

            return invalid
        else if keycode = m.app.keycodes["MENU"] then
            if "roFunction" = type(m.onReturn) then
                m.onReturn()
            end if

            if "roAssociativeArray" = type(selected.data) and invalid <> selected.data.onExit then
                selected.data.onExit()
            end if

            m.exit()
            return invalid

        else if keycode = m.app.keycodes["LEFT"] or keycode = m.app.keycodes["BACK"] then
            ' Don't pop to the NoOverlay under the menus
            if m.ui.screenstack.stack.count() > 2 then
                m.ui.screenstack.pop()
            end if
            return invalid
        end if

        return keycode
end function

sub drawSMenuUI(ctx as Object, layout as Object, params as Object)
    if params.selected then
        offset = params.offset
        depth = params.depth + 1

        if not m.readOnly then
            offset = 0
        end if

        activePath = false

        if invalid = m.selectedChild or ("SMenu" <> m.getSelected().type) or m.getSelected().readOnly then
            activePath = true
        end if

        if invalid = m.selectedChild then
            m.selectedChild = 0
        end if


        firstVisible = 0
        while "Never" = m.children[firstVisible].displayMode
            firstVisible = firstVisible + 1
        end while

        if firstVisible > m.selectedChild then
            m.selectedChild = firstVisible
        end if

        index = m.selectedChild
        if index <> firstVisible then
            if "Divider" <> m.children[m.children.count() - 1].type then
                ' Add the divider
                m.addItem(m.ui.constructString({
                    type: "Divider"
                    displayMode: "Always"
                }))
            end if
        else
            if "Divider" = m.children[m.children.count() - 1].type then
                ' Remove the divider
                m.children.pop()
            end if
        end if

        numDrawn = 0
        itemCount = m.children.count()
        maxItems = RokuMfgMin(itemCount, ctx.dimensions.maxRows)

        while (numDrawn < maxItems)
            child = m.children[index]
            xparams = { color: "white", activePath: activePath, selected: false, depth: depth, offset: offset + numDrawn}

            if "Never" <> child.displayMode then
                if index = m.selectedChild then
                    xparams.color = "orange"
                    xparams.selected = true
                end if

                if invalid <> child.color then
                    xparams.color = child.color
                end if

                if "Divider" = child.type then
                    y = ctx.app.screen.visibleTop + ((xparams.offset + 1) * ctx.dimensions.rowHeight)
                    y = y + (ctx.dimensions.rowHeight / 2) - ((m.divider.GetHeight() / 2) + 1)
                    x = ctx.dimensions.x + ctx.dimensions.totalWidth / 2
                    x = x - (m.divider.GetWidth() / 2)
                    layout.Push(m.ui.layoutImage({
                        source: m.divider
                        x: x
                        y: y
                    }))
                else if "SMenu" <> child.type then
                    child.draw(ctx, layout, xparams)
                else
                    ctx.drawMenuLabel(layout, xparams, child)
                end if

                numDrawn = numDrawn + 1
            else
                itemCount = itemCount - 1
                maxItems = maxItems - 1
            end if
            index = (index + 1) mod (m.children.count())
        end while

        if itemCount > maxItems then
            layout.Push(m.ui.layoutImage({
                source: m.fade
                x: ctx.dimensions.x + 5
                y: ctx.dimensions.y + ctx.dimensions.totalHeight - 5 - m.fade.GetHeight()
            }))
        end if
    end if
end sub