'------------------------------------------------------------------------------'
' UI IMPLEMENTATION                                                            '
'------------------------------------------------------------------------------'

function constructRangeUI(params as Object) as Object
    o = m.constructBaseUINode({
        label: "Range",
        type: "Range",
        data: invalid,
        active: false,
        displaymode: "Always",
        handleKey: handleRangeKey,
        getDisplayValue: getRangeUIDisplayValue,
        draw: drawRangeUI
    })

    o = RokuMfgMerge(o, params)
    
    if type(o.data) <> "roAssociativeArray" or o.data.class_ <> "Range" then
        print "FATAL ERROR: rangeUI must have valid range data!"
    end if

    return o
end function

function handleRangeKey(keycode as Integer)
    increment = 1 
    if m.data.increment <> invalid then
        increment = m.data.increment
    end if

    hold = m.app.keyfilter.getHoldDuration()
    if hold > 5000 then
        increment = increment * 10
    else if hold > 3000 then
        increment = increment * 5
    end if 

    if m.app.keycodes["RIGHT"] = keycode then
        if m.active then
            m.data.update(increment)
            return invalid
        end if
    else if m.app.keycodes["LEFT"] = keycode then
        if m.active then
            m.data.update(-increment)
            return invalid
        end if
    end if

    return keycode
end function

function getRangeUIDisplayValue() as String
    value = m.data.getValue()

    if type(value) = "roInteger" or type(value) = "Integer" then
        return RokuMfgStrCast(value)
    else if type(value) = "roFloat" or type(value) = "Float" then
        return str(value)
    else
        print "ERROR: " + type(value) + " is not an acceptable range value."
        stop
        return invalid
    end if
end function

sub drawRangeUI(ctx as Object, layout as Object, params as Object) as Object
    value = m.getDisplayValue()

    ' Draw the label
    ctx.DrawMenuLabel(layout, params, m)

    if m.shouldShowValue(ctx, params)
        valuenode = { label: value }
        params.depth = params.depth + 1

        if params.selected then
            params.color = "orange"
            m.active = true
        else
            params.color = "white"
            m.active = false
        endif

        ' Draw the value of the range.
        ctx.DrawMenuLabel(layout, params, valuenode)

        ' Draw arrows
        if true = params.selected then
            source_l = m.ui.arrows.arrow_left_selected
            source_r = m.ui.arrows.arrow_right_selected
        else
            source_l = m.ui.arrows.arrow_left
            source_r = m.ui.arrows.arrow_right
        end if

        y = layout[layout.count() - 1].y
        x = ctx.dimensions.columnleftoffsets[params.depth]
        
        if m.data.value <> m.data.range[0] then
            layout.Push(m.ui.layoutImage({
                source: source_l
                x: x - 90
                y: y
            }))
        end if

        if m.data.value <> m.data.range[1] then
            layout.Push(m.ui.layoutImage({
                source: source_r
                x: x + 90 - source_r.GetWidth()
                y: y
            }))
        end if
    end if
end sub

function calculateRangeUIWidth(font as Object, baseWidth as Integer) as Integer
    valueWidth = font.GetOneLineWidth(RokuMfgStrCast(m.data.range[0]), baseWidth)
    return RokuMfgMax(valueWidth, font.GetOneLineWidth(RokuMfgStrCast(child.data.range[1]), baseWidth))
end function