' Box allows a rectangle to properly wrap its children.
function layoutBox(params as Object) as Object
    defaults = {
        type: "box",
        padding: 0,

        push: pushBox,
        insertBreak: insertBoxBreak,

        getWidth: getBoxWidth,
        getHeight: getBoxHeight,

        content: [],
        rowWidths: [0],
        rowHeights: [0],
        rowIndex: 0
    }

    o = RokuMfgMerge(defaults, params)
    return m.layoutRectangle(o)
end function

function getBoxWidth() as Integer
    return RokuMfgMax(m.w, m.rowWidths.peek())
end function

function getBoxHeight() as Integer
    return m.h + m.rowHeights.peek()
end function

sub pushBox(obj as Object)

    if "box" = obj.type
        w = obj.getWidth()
        h = obj.getHeight()
    else
        w = obj.w
        h = obj.h
    end if

    x = obj.x
    y = obj.y

    obj.x = obj.x + m.rowWidths.peek()
    obj.y = y + m.h
    m.rowWidths[m.rowIndex] = m.rowWidths[m.rowIndex] + x + w
    m.rowHeights[m.rowIndex] = RokuMfgMax(m.rowHeights[m.rowIndex], y + h)
    m.content.push(obj)
end sub

sub insertBoxBreak()
    m.rowIndex = m.rowIndex + 1
    m.w = RokuMfgMax(m.w, m.rowWidths.peek())
    m.h = m.h + m.rowHeights.peek()
    m.rowWidths.push(0)
    m.rowHeights.push(0)
end sub