sub initVideoModule(app as Object) as Object
    params = {
        app: app,

        progress: 0, 'buffering progress
        position: 0, 'playback position (in seconds)
        show_loading: true,
        show_position: true,

        handleKey: handleVideoKeyEvent,
        handleEvent: handleVideoPlaybackEvent,
        exit: exitVideoModule,
        showProgress: enableVideoProgressBar
    }

    app.video = RokuMfgVideoModule(params)
    app.keyFilter.install(videoKeyFilter, app.video)
end sub

sub handleVideoPlaybackEvent(msg as Object)
    if msg.isStatusMessage() and msg.getMessage() = "startup progress" then
        'Switch the source to UI
        source = m.app.data.get("InputSource")
        if "UI" <> source.get() then
            m.app.data.get("InputSource").set("UI")
        end if

        print "handleEvent: Raw progress: " + RokuMfgStrCast(msg.getIndex())

        'Need show progress?
        if m.show_loading = true then
            progress = msg.getIndex() / 10
            if progress <> m.progress then
                m.progress = progress

                osd = m.app.screen.osds["LoadingProgress"]
                if m.progress = 100 then
                    print "handleEvent: Delete progress osd"
                    if not RokuMfgIsInvalid(osd) then
                        osd.delete()
                    end if
                else
                    if RokuMfgIsInvalid(osd) then
                        print "handleEvent: Create progress osd"
                        m.app.screen.addOSD(0, {
                            name: "LoadingProgress",
                            timeout: invalid,
                            display: m.app.screen.createBarGraph({
                                label: "Loading: ",
                                data: {
                                    value: m.progress
                                }
                            })
                        })
                    else
                        osd.display = m.app.screen.createBarGraph({
                            label: "Loading: ",
                            data: {
                                value: m.progress
                            }
                        })
                    end if
                end if
            end if
        end if
    else if msg.isPlaybackPosition() then
        print "handleEvent: Playback position: " + RokuMfgStrCast(msg.getIndex())

        'Need show progress?
        if m.show_position = true then
            m.position = msg.getIndex()

            osd = m.app.screen.osds["PlaybackPosition"]
            duration = m.getPlaybackDuration()

            if 0 <> duration then
                if RokuMfgIsInvalid(osd) then
                    m.app.screen.addOSD(0, {
                        name: "PlaybackPosition",
                        timeout: 3000,
                        display: m.app.screen.createBarGraph({
                            label: m.getFileName(),
                            data: {
                                value: m.position,
                                max: duration,
                                show: false
                            }
                        })
                    })
                else
                    osd.timeout = 3000
                    osd.display = m.app.screen.createBarGraph({
                        label: m.getFileName(),
                        data: {
                            value: m.position,
                            max: duration,
                            show: false
                        }
                    })
                end if
            end if
        end if
    else if msg.isPaused() then
        print "handleEvent: Playback paused"
        'Need show progress?
        if m.show_position = true then
            osd = m.app.screen.osds["PlaybackPosition"]
            if (not RokuMfgIsInvalid(osd)) and RokuMfgIsInvalid(osd.timeout) then
                osd.timeout = invalid
            end if
        end if
    else if msg.isResumed() then
        print "handleEvent: Playback resumed"
        'Need show progress?
        if m.show_position = true then
            osd = m.app.screen.osds["PlaybackPosition"]
            if (not RokuMfgIsInvalid(osd)) and RokuMfgIsInvalid(osd.timeout) then
                osd.timeout = 3000
            end if
        end if
    else if msg.isFullResult() then
        print "handleEvent: End of Playback"
         ' Remove OSDs related to video playback.
        for each name in ["LoadingProgress", "PlaybackPosition"]
            osd = m.app.screen.osds[name]
            if not RokuMfgIsInvalid(osd) then
                osd.delete()
            end if
        end for

        'Playback next media files in the playback list.
        m.playNextFile()
    else
        print msg.getMessage()
    end if
end sub

function videoKeyFilter(context as Object, keycode)
    return context.handleKey(keycode)
end function

function handleVideoKeyEvent(keycode)
    if m.app.keycodes["ROKU_PLAYPAUSE"] = keycode or m.app.keycodes["PLAYPAUSE"] = keycode then
        if true = m.getPlaybackStatus().paused then
            m.resume()
        else
            m.pause()
        end if
        return invalid
    end if

    return keycode
end function

'Clear the video module resources which is setup by MFG APP.
sub exitVideoModule()
    ' Remove OSDs related to video playback.
    for each name in ["LoadingProgress", "PlaybackPosition"]
        osd = m.app.screen.osds[name]
        if not RokuMfgIsInvalid(osd) then
            osd.delete()
        end if
    end for

    m.progress = 0
    m.position = 0

    'Stop and exit the playback.
    m.exitPlayback()
end sub

sub enableVideoProgressBar(enable_loading as Boolean, enable_position as Boolean)
    m.show_loading = enable_loading
    m.show_position = enable_position
end sub