sub initUIModule(app As Object) as Object
    app.ui = constructUI(app)

    app.ui.colors = {
        white       : &hFFFFFFFF
        green       : &h00FF00FF
        red         : &hFF0000FF
        blue        : &h0000FFFF
        yellow      : &hFFFF00FF
        cyan        : &h00FFFFFF
        purple      : &h800080FF
        roku_purple : &h944FC9FF
        brown       : &hA52A2AFF
        orange      : &hBC630FFF
        gray        : &h404040A0
        lightGray   : &hB9B9B9A0 
        darkGray    : &hA9A9A9FF
        gray40      : &h666666FF
        black       : &h000000FF
        transparent : &h00000000
        trans_black : &h000000D0
    }

    app.ui.arrows = {
        arrow_left_selected: CreateObject("roBitmap", "pkg:/images/spinner_ArrowLeft_selected.png"),
        arrow_right_selected: CreateObject("roBitmap", "pkg:/images/spinner_ArrowRight_selected.png"),
        arrow_left: CreateObject("roBitmap", "pkg:/images/spinner_ArrowLeft.png"),
        arrow_right: CreateObject("roBitmap", "pkg:/images/spinner_ArrowRight.png")
    }

    app.ui.addFont("small",  15)
    app.ui.addFont("medium", 24)
    app.ui.addFont("large",  75)
    app.ui.addFont("title",  20, true)

    app.ui.setDefaultFont("small")

    ' Install custom UI screens.
    ' Simple screen drawing - one line of text, centered.
    app.ui.showSimpleScreen  = showSimpleScreen
    app.ui.showSimpleDialog  = showSimpleDialog
    app.ui.showTestResult    = showTestResult
    app.ui.showSimpleText    = showSimpleText

    app.registerScreen(constructMainMenu(app))

    app.registerScreen(constructPQMenu(app))

    if "service" <> app.runlevel then
        app.registerScreen(constructVideoCurveMenu(app))
        app.registerScreen(constructPQReadOnlyMenu(app))

        ' AYT: Does the AQ menu constructions belong here? Or maybe only the curve and read only menu belongs here??
        constructDynamicMenu(app.data.aqtoplevel, app)
    end if

    app.registerScreen(constructResetSettingsMenu(app))
    app.registerScreen(constructNoOverlay(app))
    app.registerScreen(constructTunerChannelsMenu(app))
    app.registerScreen(constructLoadingMenu(app))
    app.registerScreen(constructDMPMenu(app))
    app.registerScreen(constructHDRNoSupportMenu(app))
    app.registerScreen(constructUsbUpdateMenu(app))
    app.registerScreen(constructPatternTestMenu(app))
end sub

sub showSimpleText(text)
    ' Defaults
    item = {
        text: "Simple Text",
        x: 20,
        y: 20
    }

    if "roAssociativeArray" = type(text) then
        item = RokuMfgMerge(item, text)
    else if "String" = type(text) or "roString" = type(text) then
        item.text = text
    else 
        print "showSimpleText: Bad parameter type provided " + type(text)
        return
    end if

    m.app.screen.fill(m.resolveColor(item.background, "transparent"))
    m.app.screen.drawItem(m.layoutText(item), {x: 0, y: 0})
    m.app.screen.swapBuffers()
end sub

sub ShowTestResult(text1 as String, text2 as String, result as Integer)

    color = "red"
    text3 = "TEST FAILURE"

    if result = 1  then
        color = "green"
        text3 = "TEST PASS"
    end if

    b = m.layoutBox({
        color: color,
        padding: 10
    })

    b.push(m.layoutText({text: text1}))
    b.insertBreak()
    b.push(m.layoutText({text: text2}))
    b.insertBreak()
    b.push(m.layoutText({text: text3, y: 20}))

    b.x = (m.app.screen.width - b.getWidth()) / 2
    b.y = (m.app.screen.height - b.getHeight()) / 2

    m.app.screen.clear()
    m.app.screen.drawItem(b, {x: 0, y: 0})
    m.app.screen.SwapBuffers()
end sub