function showSimpleDialog(properties as Object) as Object
    o = {
        name: "_simpleDialog_"
        app: m.app,
        ui: m,

        keyfilter: simpleDialogKeyFilter,
        prepare: prepareSimpleDialog,

        buttons: []
        selectedIndex: 0
    }

    o = RokuMfgMerge(o, properties)

    for i = 0 to o.buttons.count() - 1
        if invalid <> o.buttons[i].default and true = o.buttons[i].default then
            o.selectedIndex = i
            exit for
        end if
    end for

    m.app.pushScreen(o)
    return o
end function

sub prepareSimpleDialog()
    b = m.ui.layoutBox({
        color: "gray",
        padding: 20
    })

    b.push(m.ui.layoutText({
        text: m.text,
    }))

    b.insertBreak()

    for i = 0 to m.buttons.count() - 1
        color = "white"
        if m.selectedIndex = i then
            color = "cyan"
        end if

        buttonLayout = m.ui.layoutBox({
            color: "transparent"
        })

        buttonText = m.ui.layoutText({
            text: m.buttons[i].label,
            color: color,
            font: "small",
            y: 15
        })

        ' Center labels
        buttonText.x = ((b.getWidth() / m.buttons.count() - buttonText.w) / 2)
        buttonLayout.w = (b.getWidth() / m.buttons.count())
        buttonLayout.push(buttonText)
        b.push(buttonLayout)
    end for

    b.x = (m.app.screen.width - b.getWidth()) / 2
    b.y = (m.app.screen.height - b.getHeight()) / 2

    m.app.screen.menuItems.items = [b]
end sub

function simpleDialogKeyFilter(context as Object, keycode as Integer)
    if keycode = context.app.keycodes["ROKU_HOME"] then
        return keycode
    else if keycode = context.app.keycodes["RIGHT"] or keycode = context.app.keycodes["ROKU_RIGHT"]
        context.selectedIndex = min(context.buttons.count() - 1, context.selectedIndex + 1)
    else if keycode = context.app.keycodes["LEFT"] or keycode = context.app.keycodes["ROKU_LEFT"]
        context.selectedIndex = RokuMfgMax(0, context.selectedIndex - 1)
    else if keycode = context.app.keycodes["SELECT"] or keycode = context.app.keycodes["ROKU_OK"] then
        selected = context.buttons[context.selectedIndex]
        context.app.exitScreen()

        if "roFunction" = type(selected.func) then
            selected.func(selected.context)
        end if
    end if

    return invalid
end function