function constructPatternTestMenu(app as object) as object
    o = {
        name                : "PatternTestMenu",
        app                 : app,
        ui                  : app.ui,
        constructMenuRoot   : constructPatternTestMenuRoot
    }

    o.menuRoot = o.constructMenuRoot()
    o.delete("constructMenuRoot")

    o = RokuMfgMerge(o, app.ui.screenStack.screenRegistry["Main"], false)

    o.dimensions = o.app.ui.calculateMenuColumns(o.menuRoot)

    ' The '+ 3' pads the height for the title
    o.dimensions.totalHeight = o.dimensions.rowHeight * (o.dimensions.maxRows + 3)

    return o
end function

function constructPatternTestMenuRoot() as object
    menu = m.ui.constructSMenu({
        label: "Pattern Test"
    })

    menu.addItem(m.ui.constructSelector({
        label: "Bypass PQ",
        data: m.app.data.constructSelector({
            id: "BypassPQ",
            dataset: ["Yes", "No"],
        })
    }))

    menu.addItem(m.ui.constructString({
        label: "",
        readOnly: true,
        data: "",
        displayMode: "Always"
    }))

    menu.addItem(m.ui.constructSelector({
        label: "Color Pattern Select",
        data: m.app.data.constructSelector({
            id: "ColorPattern",
            dataset: ["Red", "Green", "Blue", "White", "Black"]
        })
    }))

    menu.addItem(m.ui.constructString({
        label: "Color Pattern",
        data: "Apply",
        status: "off",
        handleKey: handleTestPatternKey
    }))

    menu.addItem(m.ui.constructString({
        label: "",
        readOnly: true,
        data: "",
        displayMode: "Always"
    }))

    menu.addItem(m.ui.constructRange({
        label: "IRE Pattern Select",
        data: m.app.data.constructRange({
            id: "IrePattern",
            range: [0, 100],
            value: 100,
            increment: 10
        })
    }))

    menu.addItem(m.ui.constructString({
        label: "IRE Pattern",
        data: "Apply",
        status: "off",
        handleKey: handleTestPatternKey
    }))

    menu.addItem(m.ui.constructString({
        label: "",
        readOnly: true,
        data: "",
        displayMode: "Always"
    }))

    menu.addItem(m.ui.constructRange({
        label: "RGB Pattern R Value",
        data: m.app.data.constructRange({
            id: "RgbPatternRedValue",
            range: [0, 255],
            value: 255
        })
    }))

    menu.addItem(m.ui.constructRange({
        label: "RGB Pattern G Value",
        data: m.app.data.constructRange({
            id: "RgbPatternGreenValue",
            range: [0, 255],
            value: 255
        })
    }))

    menu.addItem(m.ui.constructRange({
        label: "RGB Pattern B Value",
        data: m.app.data.constructRange({
            id: "RgbPatternBlueValue",
            range: [0, 255],
            value: 255
        })
    }))

    menu.addItem(m.ui.constructString({
        label: "RGB Pattern",
        data: "Apply",
        status: "off",
        handleKey: handleTestPatternKey
    }))

    menu.addItem(m.ui.constructString({
        label: "",
        readOnly: true,
        data: "",
        displayMode: "Always"
    }))

    return menu
end function

function handleTestPatternKey(keycode as Integer)
    if m.status = "off" then
        if m.app.keycodes["RIGHT"] = keycode or m.app.keycodes["SELECT"] = keycode then
            ' Select test pattern target layer
            if m.app.data.getValue("BypassPQ") = "Yes" then
                m.app.data.get("TestPatternLayer").set("Graphics")
            else
                m.app.data.get("TestPatternLayer").set("Video")
            end if

            ' Apply test pattern
            if m.label = "Color Pattern" or m.label = "IRE Pattern" or m.label = "RGB Pattern" then
                m.app.setInternalPattern(true, {
                    useColor: (m.label = "Color Pattern"),
                    useIRE: (m.label = "IRE Pattern"),
                    useRGB: (m.label = "RGB Pattern"),
                    color: m.app.data.getValue("ColorPattern")
                    ire: m.app.data.getValue("IrePattern")
                    red: m.app.data.getValue("RgbPatternRedValue")
                    green: m.app.data.getValue("RgbPatternGreenValue")
                    blue: m.app.data.getValue("RgbPatternBlueValue")
                })
                m.status = "on"
                return invalid
            else
                print "Unknown pattern label"
            end if
        end if
    else
        if m.app.keycodes["LEFT"] = keycode or m.app.keycodes["SELECT"] = keycode then
            m.app.setInternalPattern(false)
            m.status = "off"
            return invalid
        else if m.app.keycodes["ROKU_HOME"] = keycode or m.app.keycodes["UP"] = keycode or m.app.keycodes["DOWN"] = keycode or m.app.keycodes["BACK"] = keycode then
            m.app.setInternalPattern(false)
            m.status = "off"
        end if
    end if

    return keycode
end function
