function constructPQReadOnlyMenu(app as object) as object
    o = {
        name                    : "PQReadOnly",
        app                     : app,
        ui                      : app.ui,
        constructPQReadOnlyData : constructPQReadOnlyData
    }

    o.menuRoot = o.constructPQReadOnlyData()
    o.delete("constructPQReadOnlyData")

    o = RokuMfgMerge(o, app.ui.screenStack.screenRegistry["Main"], false)

    o.dimensions = o.app.ui.calculateMenuColumns(o.menuRoot)

    ' The '+ 3' pads the height for the title
    o.dimensions.totalHeight = o.dimensions.rowHeight * (o.dimensions.maxRows + 3)

    return o
end function

function constructPQReadOnlyData()
    menu = m.ui.constructSMenu({
        label   : "Read Only"
    })

    for each field in m.app.data.pqstore
        param = m.app.data.get(field)

        if param.class_ = "String" then
            if inStr(param.id, "Curve") = 0 and inStr(param.id, "Gamma") = 0 then
                menu.addItem(m.ui.constructSelector({
                    label   : param.uiid,
                    data    : m.app.data.constructSelector({dataset: [param.value]})
                }))
            end if
        end if
    end for

    return menu
end function