function constructPQMenu(app as object) as object
    o = {
        name                : "PQMenu",
        app                 : app,
        ui                  : app.ui,
        constructPQInfoMenu : constructPQInfoMenu
    }

    o.menuRoot = o.constructPQInfoMenu()
    o.delete("constructPQInfoMenu")

    o = RokuMfgMerge(o, app.ui.screenStack.screenRegistry["Main"], false)

    o.dimensions = o.app.ui.calculateMenuColumns(o.menuRoot)

    ' The '+ 3' pads the height for the title
    o.dimensions.totalHeight = o.dimensions.rowHeight * (o.dimensions.maxRows + 3)

    return o
end function

function constructPQInfoMenu() as object
    menu = m.ui.constructSMenu({
        label: "PQ Menu"
    })

    addOptionalMenuItems(menu)
    
    ' The menus are constructed from the feature parameter in the JSON description and ordered by the
    ' order parameter. Feature is an array of menus in which that parameter is present.
    pqsubmenus = { }
    for each item in m.app.data.pqstore
        x = m.app.data.get(item)
        if x.feature = invalid then
            print "Feature is invalid in " + item
        end if

        for each feature in x.feature
            if pqsubmenus[feature] = Invalid then
                pqsubmenus[feature] = []
            end if
            pqsubmenus[feature].push(x)
        end for
    end for

    ' We need some way to order the features correctly. For now, we'll hard code the ordering
    dataset = [ "Picture Mode", "Processing", "Color Temperature", "Backlight" ]

    for each x in pqsubmenus
        pqsubmenus[x].sortby("order")
        newmenu = []
        for each item in pqsubmenus[x]
            newmenu.push(item.id)
        end for
        pqsubmenus[x] = newmenu

        if x <> "none" and x <> "Video Curves" then
            found = false
            for each y in dataset
                if x = y then
                    found = true
                    exit for
                end if
            end for
            if not found then
                dataset.push(x)
            end if
        end if
    end for
    m.app.data.pqsubmenus = pqsubmenus

    menu.addItem(m.ui.constructSelector({
        label       : "PQ Settings"
        data        : m.app.data.constructSelector({
                        id      : "pqsettings"
                        app     : m.app
                        dataset : dataset
                        values  : dataset
                        onUpdate: updatePQMenu
                    })
    }))

    firstsetting = m.app.data.get("pqsettings")
    firstsetting = firstsetting.values[firstsetting.index]
    firstsetting = pqsubmenus[firstsetting]

    for each item in firstsetting 
        setting = m.app.data.get(item)

        if setting.class_ = "Range" then
            menu.addItem(m.ui.constructRange({
                label   : setting.uiid,
                data    : setting
            }))
        else if setting.class_ = "Selector" then
            menu.addItem(m.ui.constructSelector({
                label   : setting.uiid,
                data    : setting
            }))
        end if
    end for

    return menu
end function

sub updatePQMenu()
    menu = m.app.ui.screenstack.getcurrent().menuroot
    menu.children = []
    addOptionalMenuItems(menu)
    menu.addItem(m.app.ui.constructSelector({
        label: "PQ Settings",
        data: m
    }))

    currentsetting = m.app.data.get("pqsettings")
    currentsetting = currentsetting.values[currentsetting.index]
    
    menuitems = m.app.data.pqsubmenus[currentsetting]
    for each item in menuitems
        setting = m.app.data.get(item)

        if setting <> invalid then
            if setting.class_ = "Range" then
                menu.addItem(m.app.ui.constructRange({
                    label   : setting.uiid
                    data    : setting
                }))
            else if setting.class_ = "Selector" then
                menu.addItem(m.app.ui.constructSelector({
                    label   : setting.uiid
                    data    : setting
                }))
            end if
        end if
    end for
end sub

sub addOptionalMenuItems(menu as Object)
    app = menu.app
    isService = ("service" = app.runlevel)
    if not isService then
        menu.addItem(app.ui.constructAction({
            label       : "readonly stuff >",
            screen      : "PQReadOnly",
            data        : enterMenu
        }))

        menu.addItem(app.ui.constructAction({
            label       : "Video Curves >"    
            screen      : "VideoCurveMenu"
            data        : enterMenu
        }))
    end if

    menu.addItem(app.ui.constructAction({
        label: "Reset Settings >",
        screen: "ResetSettings",
        data: enterMenu
    }))

    if not isService then
        menu.addItem(app.ui.constructSelector({
            label       : "PQ Edit Level"
            data        : app.data.get("pqeditlevel")
        }))
    end if
end sub
