sub constructDynamicMenu(datalist as object, app as object, parent=invalid as dynamic)
    for each item in datalist
        data = app.data.get(item)

        if data.class_ = "Object" then
            screenObj = constructDynamicScreen(data.id, data.features, app)
            app.registerScreen(screenObj)
        end if
    end for
end sub

function constructDynamicScreen(name as string, datalist as object, app as object)
    data = app.data.get(name)
    registryName = data.id + "Menu"
    uiName = data.uiid

    o = {
        name                        : registryName,
        app                         : app,
        ui                          : app.ui,
        constructDynamicMenuRoot    : constructDynamicMenuRoot
    }

    o.menuRoot = o.constructDynamicMenuRoot(uiName, datalist)
    o.delete("constructDynamicMenuRoot")

    o = RokuMfgMerge(o, app.ui.screenStack.screenRegistry["Main"], false)

    o.dimensions = o.app.ui.calculateMenuColumns(o.menuRoot)

    ' The '+ 3' pads the height for the title
    o.dimensions.totalHeight = o.dimensions.rowHeight * (o.dimensions.maxRows + 3)

    return o
end function

function constructDynamicMenuRoot(name as string, datalist as object)
    menu = m.ui.constructSMenu({
        label   : name
    })

    orderedData = []
    for each item in datalist
        orderedData.push(m.app.data.get(item))
    end for

    orderedData.sortby("order")

    datalist = []
    for each item in orderedData
        datalist.push(item)
    end for

    for each data in datalist
        if data.class_ = "Range" then
            menu.addItem(m.ui.constructRange({
                label       : data.uiid
                data        : data
            }))
        else if data.class_ = "Selector" then
            menu.addItem(m.ui.constructSelector({
                label       : data.uiid
                data        : data
            }))
        else if data.class_ = "String" then
            menu.addItem(m.ui.constructString({
                label       : data.uiid
                data        : data
            }))
        else if data.class_ = "Array" then
            menu.addItem(m.ui.constructAction({
                label       : data.uiid + " > "
                screen      : data.id + "Menu"
                data        : enterMenu
            }))
            m.app.registerScreen(constructDynamicScreen(data.id, data.features, m.app))
        else if data.class_ = "Object" then
            menu.addItem(m.ui.constructAction({
                label       : data.uiid + " > "
                screen      : data.id + "Menu"
                data        : enterMenu
            }))
            m.app.registerScreen(constructDynamicScreen(data.id, data.features, m.app))
        end if
    end for

    return menu
end function