function constructDMPMenu(app as Object) as Object
    o = {
        name: "DMP",
        app: app,
        ui: app.ui,

        construct: constructDMPMenuItems,
        getContent: getDMPContent,
        refreshContent: doRefreshContent,

        onEntry: onDMPEntry
    }

    o.menuRoot = o.construct()
    o.Delete("constructDMPMenuItems")
    o = RokuMfgMerge(o, app.ui.screenstack.screenregistry["Main"], false)

    return o
end function

function constructDMPMenuItems() as Object
    menu = m.ui.constructSMenu({label: "USB Media Menu"})

    ' Rediscover media on USB every time we load this menu.
    menu.addItem(m.ui.constructAction({
        label: "Refresh content",
        data: m.refreshContent
    }))

    print "Rediscover media"
    files = m.getContent("videos", "pkg:")
    files.append(m.getContent(""))

    if 0 < files.count() then
        for each file in files
            menu.addItem(m.ui.constructFileEntry({
                data: file
                action: playDMPFile
            }))
        end for
    else
        menu.addItem(m.ui.constructString({
            label: "(No content found)"
        }))
    end if

    menu.selectedChild = 0
    return menu
end function

' Entries can update
sub onDMPEntry()
    m.menuroot = m.construct()
end sub

sub doRefreshContent()
    m.app.currentScreen().menuroot = m.app.currentScreen().construct()
end sub

function DMPKeyFilter(ctx as Object, keycode)
    return ctx.handleKeys(keycode)
end function

function handleDMPMenuKeys(keycode)
    if m.app.keycodes["LEFT"] = keycode then
        m.app.video.exit()
        m.app.exitScreen()
        return invalid
    end if

    activeItem = m.menuRoot.getSelected()
'   menuString = "Context before Keypress: " + activeItem.label

    while invalid <> activeItem.getSelected and invalid <> activeItem.getSelected()
        activeItem = activeItem.getSelected()
    end while
'   menuString = menuString + "->" + activeItem.label

    keycode = m.app.keycodes.simplifyNavigation(keycode)
    activeItem = activeItem.parent
    return activeItem.handleKey(keycode)
end function

sub PrepareDMPMenuLayer()
    layout = []
    m.drawBackground(layout)
    m.menuRoot.draw(m, layout, {})
    m.app.screen.menuItems.items = layout
end sub


function getDMPContent(path, volume="ext1:") As Object
    mimetypes = { 'map known extensions to pseudo-mime-type here
        x_3g2:  { type: "video", format: "mp4" },
        x_3gp:  { type: "video", format: "mp4" },
        x_m4v:  { type: "video", format: "mp4" },
        x_mp4:  { type: "video", format: "mp4" },
        x_mov:  { type: "video", format: "mp4" },
        x_mkv:  { type: "video", format: "mkv" },
        x_wmv:  { type: "video", format: "wmv" },
        x_ts:   { type: "video", format: "ts"  },
        x_m3u8: { type: "video", format: "hls" },
        x_m4a:  { type: "audio", format: "mp4" },
        x_mp3:  { type: "audio", format: "mp3" },
        x_wma:  { type: "audio", format: "wma" },
        x_mka:  { type: "audio", format: "mka" },
        x_aif:  { type: "audio", format: "pcm" },
        x_aiff: { type: "audio", format: "pcm" },
        x_aifc: { type: "audio", format: "pcm" },
        x_au:   { type: "audio", format: "pcm" },
        x_wav:  { type: "audio", format: "pcm" },
        x_flac: { type: "audio", format: "flac" },
        x_csv:  { type: "config", format: "csv" }
        x_bmp:  { type: "image" }
        x_jpg:  { type: "image" }
        x_png:  { type: "image" }
        ' x_gif:  { type: "image" }
        'Anything else belongs in the "other" category
    }

    content = []
    for each file in m.app.usb.readDir(path, volume)
        'if info.type = "directory"
        '    mimetype = { type: "folder", format: "folder" }
        '    citem = c + "/"
        if file.type = "file"
            file.mimetype = mimetypes["x_" + file.path.Split().extension.mid(1)]
            ' Only allow valid mimetypes
            'if mimetype = invalid mimetype = { type: "other" }
            file.description = toFileSizeString(file.size)
        end if

        if file.mimetype <> invalid
            isTruncated = false
            while (m.ui.fonts.default.GetOneLineWidth(file.name, 220) >= 220)
                file.name = file.name.Left(file.name.Len() - 1)
                if false = isTruncated then
                    isTruncated = true
                end if
            end while

            if isTruncated then
                file.name = file.name + "..."
            end if
            content.Push(file)
        end if
    end for

    return content
end function

sub playDMPFile(file)
    m.app.video.stop()
    m.app.screen.mainItems.clear()

    if file.mimetype.type = "video" then
        m.app.video.playPlaylist({loop: false, content: [file]})
    else if "image" = file.mimetype.type then
        picture = createObject("roBitmap", file.path)
        if invalid <> picture then
            m.app.screen.mainItems.push(m.ui.layoutImage({
                source: picture,
                w: m.app.screen.width,
                h: m.app.screen.height
            }))
        else
            print "DMP: Not supported Picture!"
        end if
    end if
end sub