' Factory USB Update

sub initUpdateModule(app as Object) as Object
    o = {
        app: app,
        start: usbFactoryUpdate,
        error: usbErrorMessage,
        progress: usbProgressMessage,
        osd: invalid
    }

    app.update = o
end sub

function usbFactoryUpdate() as Boolean
    m.app.video.stop()

    devInfo = CreateObject("roDeviceInfo")
    brandString = LCase(devInfo.GetModelDetails().VendorUSBName)
    url = "https://tvupdate.roku.com/cgi-bin/update-factory?brand=" + brandString + "&code="

    usbupdate = CreateObject("roFirmwareUpdate")
    usbport = CreateObject("roMessagePort")
    usbupdate.SetMessagePort(usbport)

    m.progress("Starting update...")
    ret = usbupdate.Start()

    if ret = -1 then
        return m.error("File not found.")
    else if ret <> 0 then
        return m.error("Failed to start update.")
    end if

    ' Get update information
    id       = usbupdate.GetManifestID()
    name     = usbupdate.GetUpdateName()
    req_code = usbupdate.GetRequestCode()

    xfer = CreateObject("roUrlTransfer")
    xfer_url = url + req_code
    roku_esn = m.app.data.getValue("RokuSN")
    if "<ERROR>" <> roku_esn then
        xfer_url = xfer_url + "__" + roku_esn
    end if

    print "request = " + xfer_url

    xfer.SetCertificatesFile("common:/certs/ca-bundle.crt")
    xfer.SetURL(xfer_url)
    response = xfer.GetToString()

    m.progress("Contacting server...")

    if response = "" then
        return m.error("Unable to connect to server.")
    else if response.Mid(0,1) <> "2" then
        ' First digit not 2 is an error
        return m.error("Server: " + response)
    else if response.Mid(1,1) <> "0" then
        ' Second digit not 0 means update is not factory-compatible.
        return m.error("Non-manufacturing update. ")
    end if

    ' Finish update using the response code.
    responseCode = response.Mid(4)
    print "Authorization code " + responseCode
    ret = usbupdate.Finish(responseCode)

    if ret <> 0 then
        return m.error("Unable to finish update. ")
    end if

    m.progress("Installing update...")

    while true
        'msg = usbport.GetMessage()
        msg = wait(1000, usbport)

        if type(msg) = "roFirmwareUpdateEvent" then
            progress = msg.GetInfo().progress

            if progress <> invalid then
                pct = Int(progress / 10)
                if pct = 100 then
                    ' On MSU the image is flashed later, do not indicate 100%
                    pct = 99
                end if
                m.progress("Installing update... " + pct.ToStr() + "%")
            end if
        end if

        ' Status=1 means update is still in progress
        if usbupdate.GetStatus() <> 1 then
            exit while
        end if
    end while

    if 0 <> usbupdate.getStatus() then
        return m.error("Update installation failed.")
    end if

    m.progress("Update complete.  Rebooting...")
    sleep(3000)
    m.app.tv.RebootSystem()
    return true
end function

sub usbProgressMessage(msg As String)
    print "USB Upgrade: " + msg
    b = m.app.ui.layoutBox({
        padding: 20
        color: "gray"
    })

    b.push(m.app.ui.layoutText({text: msg}))
    b.x = (m.app.screen.width - b.getWidth()) / 2
    b.y = (m.app.screen.height - b.getHeight()) / 2

    m.app.screen.addOSD(m.app.timer.totalMilliseconds(), {
        name: "UsbProgressMessage",
        timeout: 3000,
        display: [b]
    })

    m.app.currentScreen().prepare()
    m.app.screen.prepareOSDs()
    m.app.screen.drawBase()
end sub

function usbErrorMessage(msg As String) as Boolean
    m.progress("ERROR: " + msg)
    return false
end function
