sub initTunerModule(app as Object)
    o = {
        app: app,
        tuneRequest: {
            channel: invalid,
            subChannel: invalid,
            dot: false
        },

        keyFilter: tunerEntryKeyFilter,
        handleEntry: handleTunerEntry,
        keycodeToInt: tunerKeycodeToInt,
        showEntryOSD: showTunerEntryOSD,
        goToChannel: goToTunerChannel,
        goToRequest: goToTunerRequest,
        resetRequest: resetTunerRequest
    }

    app.tuner = o
end sub

function handleTunerEntry(keycode as Integer)
    if m.app.keycodes["CHF_."] = keycode and not m.tuneRequest.dot then
        m.tuneRequest.dot = true
        m.showEntryOSD()
        return invalid
    else
        value = m.keycodeToInt(keycode)

        if invalid <> value then
            if not m.tuneRequest.dot then
                if invalid = m.tuneRequest.channel then
                    m.tuneRequest.channel = 0
                end if

                if m.tuneRequest.channel > 9 then
                    ' Mark it handled but don't add it to the request.
                    return invalid
                end if

                m.tuneRequest.channel = (m.tuneRequest.channel * 10) + value
            else
                if invalid = m.tuneRequest.subChannel then
                    m.tuneRequest.subChannel = 0
                end if

                if m.tuneRequest.subChannel > 9
                    ' Mark it handled but don't add it to the request.
                    return invalid
                end if

                m.tuneRequest.subChannel = (m.tuneRequest.subChannel * 10) + value
            end if

            m.showEntryOSD()
            return invalid
        end if
    end if

    m.app.screen.osds["TunerEntry"].delete()
    return keycode
end function

function tunerEntryKeyFilter(context as Object, keycode as Integer)
    return context.handleEntry(keycode)
end function

function tunerKeycodeToInt(keycode as Integer)
    key = m.app.keycodes.lookupName(keycode)
    if "0" <= Right(key, 1) and "9" >= Right(key, 1) then
        return strtoi(Right(key, 1))
    end if

    return invalid
end function

sub showTunerEntryOSD()
    channelString = RokuMfgStrCast(m.tuneRequest.channel)

    if m.tuneRequest.dot then
        channelString = channelString + "."

        if invalid <> m.tuneRequest.subChannel then
            channelString = channelString + RokuMfgStrCast(m.tuneRequest.subChannel)
        end if
    end if

    layout = m.app.ui.layoutText({
        text: channelString,
        color: "orange",
        font: "large",
        x: m.app.screen.visibleRight,
        y: m.app.screen.visibleBottom
    })

    layout.x = layout.x - layout.w
    layout.y = layout.y - layout.h

    m.app.screen.addOSD(m.app.timer.totalMilliseconds(), {
        name: "TunerEntry",
        timeout: 2000,
        display: [layout],
        onDelete: tunerOSDDeleteCallback
    })
end sub

sub tunerOSDDeleteCallback()
    print "Removing filter"
    m.screen.app.keyFilter.remove(tunerEntryKeyFilter)
    m.screen.app.tuner.resetRequest()
end sub

sub goToTunerChannel(channel as Integer, subChannel)
    m.tuneRequest.channel = channel
    m.tuneRequest.subChannel = subChannel

    m.tuneRequest.dot = false

    if invalid <> subChannel and 0 < subChannel then
        m.tuneRequest.dot = true
    end if

    m.showEntryOSD()
    m.goToRequest()
end sub

sub goToTunerRequest()
    if invalid <> m.tuneRequest.subChannel then
        m.app.tv.SetDigitalTVChannel(m.tuneRequest.channel, m.tuneRequest.subChannel)
    else
        m.app.tv.SetAnalogTVChannel(m.tuneRequest.channel)
    end if

    if "TUNER" <> m.app.data.getValue("InputSource") then
        m.app.data.get("InputSource").set("TUNER")
    end if

    oldDigital = m.app.data.get("TunerInfo").isDigital
    m.app.data.get("TunerInfo").refresh()
end sub

sub resetTunerRequest()
    m.tuneRequest = {
        channel: invalid,
        subChannel: invalid,
        dot: false
    }
end sub