sub constructPQData(app as object)
    print "initializing data: PQ"

    app.data.pq = {
      app: app,
      getString: getPQString,
      getInt: getPQInt,
      set: setPQSetting,
      handle: handlePqEvent,
      refresh: refreshPQValue
    }

    _json_PQMain = app.mfg.pqinfo()
    initializePQData(_json_PQmain, app)
    initializePQDefaults(app)

    app.data.constructString({
        id: "PQVersion",
        value: getPQVersion(),
        readonly: true
    })
end sub

function getPQVersion() as String
    pq = RokuMfg().call("pq", {
        action: "get",
        component: "version"
    })

    if RokuMfgCheckResponse(pq) then
        pqversion = ""
        if "" <> pq.data.oem then
            pqversion = pqversion + pq.data.oem + " / "
        end if

        ver = {
            minor: "",
            major: ""
        }

        all_empty = true
        for each key in ver
            if "" <> pq.data[key] then
                ver[key] = pq.data[key]
                all_empty = false
            else
                ver[key] = "0"
            end if
        end for

        if all_empty then
            return "Empty (reboot?)"
        else
            return pqversion + ver.major + "." + ver.minor
        end if
    end if

    return "Unknown"
end function

sub handlePqEvent(data as Object)
    if "service" = m.app.runlevel and "Normal" <> m.getString("Picture") then
        ' For the Service App, ensure the mode is set to Normal.
        ' Setting the picture mode here will result in another PQ event that
        ' will contain more relevant values.
        m.app.data.get("Picture").setIndex(0)
    end if

    for each key in data
        m.refresh(key, data[key])
    end for
end sub

sub initializePQData(data as object, app as object)
    editMap = {
        dev: ["Global", "Persistent", "Input"],
        tuning: ["Global", "Input"],
        service: ["Persistent"]
    }

    if invalid <> editMap[app.runlevel] then
        editDataset = editMap[app.runlevel]
    else
        editDataset = editMap["tuning"]
    end if

    app.data.constructSelector({
        id      : "pqeditlevel",
        dataset : editDataset,
        onUpdate: updatePQEditLevel
    })

    app.data.constructSelector({
        id: "pqresetlevel",
        dataset: editDataset
    })

    app.data.pqstore = []

    json_predates_schema = Invalid

    for each entry in data
        p = data[entry]
        ' Only do this once -- check if the JSON is pre-PQ::Schema
        if json_predates_schema = Invalid then
            json_predates_schema = (p.pqname <> Invalid)
        end if

        if "service" = app.runlevel then
            allow = false
            for each s in p.scope
                comp = left(s, 2)
                if comp = "pa" or comp = "gs" then
                    allow = true
                    exit for
                end if
            end for
        else
            allow = true
        end if

        if true = allow then
            'If pre-Schema, the key is the setting's ordinal index. Otherwise,
            'the key is the setting's pqname.
            if json_predates_schema then
                p.index = strtoi(entry)
            else
                p.pqname = entry
            end if
            param = invalid
            if p.type = "range" then
                param = app.data.constructRange({
                    id          : p.pqname,
                    uiid        : p.name,
                    range       : p.range,
                    default     : p.default.toFloat(),
                    value       : p.default.toFloat(),
                    onUpdate    : updateFunction
                })
            else if p.type = "rgslider" then
                if json_predates_schema then
                    rgslider_range = [p.rgslider.low.pq, p.rgslider.high.pq]
                else
                    rgslider_range = p.range
                end if
                param = app.data.constructRange({
                    id          : p.pqname,
                    uiid        : p.name,
                    range       : rgslider_range,
                    default     : p.default.toFloat(),
                    value       : p.default.toFloat(),
                    onUpdate    : updateFunction
                })
            else if p.type = "curve" then
                param = app.data.constructString({
                    id          : p.pqname,
                    uiid        : p.name,
                    default     : p.default,
                    value       : p.default
                })

                points = app.data.pq.getString(p.pqname).tokenize(",")
                for i = 0 to points.count() - 1 step 2 
                    rPt = points[i]
                    iPt = points[i + 1]

                    app.data.constructRange({
                        curvename   : p.pqname,
                        id          : p.pqname + "_" + rPt,
                        uiid        : "Reference: " + rPt,
                        range       : p.range,
                        value       : strtoi(iPt),
                        onUpdate    : updateVideoCurve,
                        onRefresh   : refreshVideoCurve
                    })
                end for
            else if p.type = "selector" then
                obj = {
                    id          : p.pqname,
                    uiid        : p.name,
                    dataset     : [],
                    values      : [],
                    onUpdate    : updateFunction
                }

                for each item in p.selector
                    allow = true
                    if p.pqname = "Picture" then
                        if app.runlevel = "service" and item.name <> "Normal" then
                            allow = false
                        end if

                        if item.name = "Low Power" then
                            item.name = "EcoSave"
                        end if
                    end if

                    if true = allow then
                        if item.pqvalue = item.default then
                            obj.default = item.name
                        end if
                        obj.dataset.push(item.name)
                        obj.values.push(item.pqvalue)
                    end if
                end for

                if invalid = obj.default then
                    obj.default = obj.dataset[0]
                end if

                param = app.data.constructSelector(obj)
            else if p.type = "readonly" then
                param = app.data.constructString({
                    id          : p.pqname,
                    uiid        : p.name,
                    value       : p.default,
                    readOnly    : true
                })
            end if
            if param <> invalid then
                param.order = p.index ' Order in which to present this
                param.feature = p.feature   ' Feature(s) to present this in
                app.data.pqstore.push(p.pqname)
            end if
        end if
    end for
end sub

function getPQString(setting as string) as string
    ret = m.app.mfg.call("pq", {
        action: "get",
        component: "setting",
        data: setting
    })

    if RokuMfgCheckResponse(ret) then
        return ret.data[setting]
    end if
    return ""
end function

function getPQInt(setting as string) as integer
    return val(m.getString(setting), 10)
end function

sub setPQSetting(setting as string, value as object)
  data = {}
  data[setting] = RokuMfgStrCast(value)
  RokuMfgCheckResponse(m.app.mfg.call("pq", {
    action: "set"
    component: "setting"
    data: data
  }))
end sub

sub initializePQDefaults(app as object)
    app.data.get("pqeditlevel").setIndex(0)
    for each parameter in app.data.pqstore
        field = app.data.get(parameter)
        if parameter = "Picture" then
            pm = app.data.pq.getString(parameter)

            for each item in field.dataset
                if lcase(item) = lcase(pm) then
                    pm = item
                end if
            end for

            field.value = pm
            print "Init Picture Mode: " + pm
        else if parameter = "Brightness" or parameter = "Constrast" or parameter = "Saturation" or parameter = "Hue" or parameter = "Sharpness" then
            preset = app.data.get("Picture")
            preset = lcase(preset.values[preset.index])

            p = app.data.pq.getInt(parameter)
            field.value = p
        else if parameter = "ColorTemperature" then
            ct = app.data.pq.getString(parameter)

            for i = 0 to field.values.count() - 1
                if lcase(field.values[i]) = lcase(ct) then
                    field.index = i
                    exit for
                end if
            end for
        else if inStr(parameter, "WB") then
            ct = app.data.get("ColorTemperature")
            ct = lcase(ct.values[ct.index])

            value = app.data.pq.getInt(parameter)
            field.value = value
        else if parameter = "Gamma" then
            value = app.data.pq.getString(parameter)
            field.value = value
            field.index = RokuMfgIndex(field.dataset, field.value)
        else if parameter = "NoiseReduction" or parameter = "MpegNR" then
            value = app.data.pq.getInt(parameter)

            ' Setting all of them the same since pq.cpp makes no distinction
            field.index = value
        else if inStr(parameter, "CS") then
            value = app.data.pq.getInt(parameter)

            field.value = value
        else if inStr(lcase(parameter), "_curve") then
            field.value = app.data.pq.getString(parameter)

            points = field.value.tokenize(",")
            for i = 0 to points.count()-1 step 2
                refCurve = app.data.get(parameter + "_" + points[i])
                refCurve.value = strtoi(points[i+1])
            end for
        else
            if field.class_ <> "String" then
                ret = app.mfg.call("pq", {
                    action: "get"
                    component: "setting"
                    data: parameter
                })
                if RokuMfgCheckResponse(ret) and len(ret.data[parameter]) > 0 then
                    if field.class_ = "Range" then
                        field.value = app.data.pq.getInt(parameter)
                    else if field.class_ = "Selector" then
                        value = app.data.pq.getString(parameter)
                        field.index = RokuMfgIndex(field.values, value)
                    end if
                else
                    app.data.pqstore.delete(RokuMfgIndex(app.data.pqstore, parameter))
                    app.data.delete(parameter)
                end if
            end if
        end if
    end for
end sub

' AYT: All of the update functions are limited to the capcity of the previous STG. When the manufacturing API rewrite is completed, there can be a more general update function,
' accompanied with various wrappers for their respective api structures.

function updateVideoCurve()
    ' Obtain parent curve
    curve = m.app.data.get(m.curvename)
    points = curve.value.tokenize(",")

    ' Identify reference points
    refPts = []
    for i = 0 to points.count() - 1 step 2
        refPts.push(points[i])
    end for

    ' Validate that updated reference value is neither greater than the reference values above it or less than the reference values below it
    prefix = m.curvename + "_"
    index = RokuMfgIndex(refPts, mid(m.id, prefix.len() + 1))

    if index + 1 < refPts.count() then
        nextRefPt = m.app.data.get(prefix + refPts[index + 1])
        if m.value > nextRefPt.value then
            nextRefPt.set(m.value)
        end if
    end if

    if index - 1 > -1 then
        prevRefPt = m.app.data.get(prefix + refPts[index - 1])
        if m.value < prevRefPt.value then
            prevRefPt.set(m.value)
        end if
    end if

    ' Update parent curve
    newcurve = ""
    for each p in refPts 
        iPt = m.app.data.get(curve.id + "_" + p).value
        newcurve = newcurve + p + "," + RokuMfgStrCast(iPt) + ","
    end for
    curve.set(newcurve)

    ' Set video curve values with updated parent curve object
    name = curve.id.tokenize("_")
    data = {
        curve: name[0]
        count: refPts.count()
    }

    values = curve.value.tokenize(",")
    for i = 0 to values.count() - 1 step 2
        counter = RokuMfgStrCast(i / 2)
        index = "refPt" + counter
        valdex = "value" + counter

        refval = m.app.data.get(curve.id + "_" + values[i]).value

        data[index] = strtoi(values[i])
        data[valdex] = refval
    end for

    m.app.data.pq.set(m.curvename, newcurve)

'    m.app.tv.setVideoCurve(data)

    ' Validate setting and return debug message
'    ret = m.app.tv.getVideoCurve(data.curve)
'    if ret.valid = 1 then
'        retmessage = "Update " + name[0] + " curve to: " 
'        for i = 0 to ret.count - 1 
'            index = "refPt" + RokuMfgStrCast(i)
'            valdex = "value" + RokuMfgStrCast(i)

'            retmessage = retmessage + RokuMfgStrCast(ret[index]) + ", " + RokuMfgStrCast(ret[valdex]) + ", "
'        end for
'        print retmessage
'    else
'        print "Cannot update " + name[0] + "curve because it doesn't exist."
'    end if
end function

function refreshVideoCurve()
    print "refreshVideoCurve needs implementation"
end function

function updatePQEditLevel()
    ' Set edit level
    setval = lcase(m.get())
    RokuMfgCheckResponse(m.app.mfg.call("pq", {
        action: "set",
        component: "layer",
        data: setval
    }))

    ' Validate edit level was successfully set
    ret = m.app.mfg.call("pq", {
        action: "get",
        component: "layer"
    })
    if RokuMfgCheckResponse(ret) and ret.data = setval then
        print "set preset edit level to: " + m.get()
    else
        print "set preset edit level failed"
    end if
end function

function updateFunction()
    ' update picture mode
    if m.id = "Picture" then
        m.app.data.pq.set(m.id, m.values[m.index])
        print "Update Picture Mode to " + m.get()
    ' update picture mode display parameters
    else if m.id = "Brightness" or m.id = "Constrast" or m.id = "Saturation" or m.id = "Hue" or m.id = "Sharpness" then
        m.app.data.pq.set(m.id, m.get())

        print "Update " + m.id + " to " + RokuMfgStrCast(m.get())
    ' update color temperature
    else if m.id = "ColorTemperature" then
        m.app.data.pq.set(m.id, m.get())
        print "Update Color Temperature to " + m.get()
    ' update white balance values
    else if inStr(m.id, "WB") then
        m.app.data.pq.set(m.id, m.get())

        print "Update " + m.id + " to " + RokuMfgStrCast(m.get())
    ' update gamma
    else if m.id = "Gamma" then
        m.app.data.pq.set(m.id, m.get())

        print "Update Gamma to " + m.get()
    ' update NR
    else if m.id = "NoiseReduction" or m.id = "MpegNR" then
        m.app.data.pq.set(m.id, m.values[m.index])

        print "Update Noise Reduction and MpegNR to " + m.values[m.index]
    ' update backlight parameters
    else if inStr(m.id, "Backlight") then
        if m.class_ = "Range" then
            value = m.get()
        else if m.class_ = "Selector" then
            value = val(m.values[m.index])
        end if

        m.app.data.pq.set(m.id, value)
	
       print "Update " + m.id + " to " + RokuMfgStrCast(m.get())
    ' update eps color space
    else if inStr(m.id, "CS") then
        m.app.data.pq.set(m.id, m.get())

        print "Update EPS " + m.id + " to " + RokuMfgStrCast(m.get())
    ' update display parameters
    else
        if m.class_ = "Range" then
            value = m.get()
        else if m.class_ = "Selector" then
            value = val(m.values[m.index])
        end if

        m.app.data.pq.set(m.id, value)

        print "Update " + m.id + " to " + RokuMfgStrCast(value)
    end if
end function

sub refreshPQValue(key as String, value as String)
    el = m.app.data.get(key)
    if invalid = el then
        return
    end if

    old_val = el.get()
    if RokuMfgIsFloat(old_val) then
        new_val = value.toFloat()
    else if RokuMfgIsInt(old_val) then
        new_val = value.toInt()
    else
        new_val = value
    end if

    if "Selector" = el.class_ then
        for i=0 to el.values.count() - 1
            if el.values[i] = new_val then
                el.index = i
                return
            end if
        end for

        print "Warning: invalid value for " + el.id + ". Setting to default"
        el.set(el.default)
    else
        el.value = new_val
        if "Range" = el.class_ and not el.within(new_val) then
            print "Warning: Value for " + el.id + " out of range. Setting to limit"
            el.update(0)
        end if
    end if
end sub
