' General TV settings (input, volume/mute, etc.)
sub constructGeneralData(app as Object)
    app.data.constructString({
        id: "TunerInfo",
        chType: "",
        refresh: refreshTunerInfo
    })

    ' Input source.
    app.data.constructString({
        id: "CurrentInputSource"
        value: ""
    })

    source = app.data.constructSelector({
        id: "InputSource",
        onUpdate: updateInputSource
    })

    'Initialize available sources and current source.
    initializeInputSource(source, app.tv)

    app.data.constructRange({
        id: "Volume",
        range: [0, 100],
        value: getVolume(app.tv)
        onUpdate: updateVolume
    })

    app.data.constructSelector({
        id: "Mute",
        dataset: ["Off", "On"],
        index: getMute(app.tv),
        onUpdate: updateMute
    })

    app.data.constructString({
        id: "USBInfo",
        cached: false,
        readOnly: true,
        refresh: refreshUSBInfo
    })

    app.data.constructString({
        id: "Loading",
        value: "false",
        onUpdate: updateLoadingState
    })

    app.data.constructString({
        id: "HDRState",
        value: "SDR",
        onUpdate: updateHDRActiveState
    })
end sub

'-- Input Source --'
sub initializeInputSource(selector as Object, tv as Object)
    selector.dataset = []
    ret = tv.getAllSources()

    if RokuMfgCheckLegacyResponse("getAllSources", ret) then
        for each source in ret.sources
            ' This allows us to show a friendly name on screen
            ' but still use Roku's internal naming
            if "ui" = source then
                source = "streaming"
            else if "cvbs" = source then
                source = "av"
            end if

            selector.dataset.push(ucase(source))
        end for
    end if

    value = selector.get()

    print "getInputSource: " +  value
    selector.set(value)
end sub

sub updateInputSource()
    if invalid <> m.app.ui then
        if "STREAMING" <> m.get() then
            m.app.video.stop()
            m.app.currentScreen().changeVideoAction.displayMode = "Never"
        end if

        if "TUNER" <> m.get() then
            m.app.currentScreen().changeTunerAction.displayMode = "Never"
            m.app.screen.osds.delete("NoChannels")
        else
            m.app.data.get("TunerInfo").refresh()
            m.app.currentScreen().changeTunerAction.displayMode = "Always"
        end if
    end if

    ' This allows us to show a friendly name on screen
    ' but still use Roku's internal naming
    if "STREAMING" = m.get()
        newSource = "UI"
    else if "AV" = m.get()
        newSource = "CVBS"
    else
        newSource = m.get()
    end if

    m.app.tv.setSource(newSource)
    m.app.data.get("CurrentInputSource").set(m.get())

    if invalid <> m.app.ui then
        m.app.data.get("Loading").set("true")
    end if
end sub

sub deleteInputChangeOSD()
    if "TUNER" = m.screen.app.data.getValue("InputSource") then
        ret = m.screen.app.mfg.legacy.getChannelInfoByIndex(-1)
        if not RokuMfgCheckLegacyResponse("getChannelInfoByIndex", ret)
            b = m.screen.app.ui.layoutBox({
                padding: 20
                color: "black"
            })

            b.push(m.screen.app.ui.layoutText({
                text: "No tuner channels found",
                font: "medium"
            }))
            b.x = (m.screen.app.screen.width - b.getWidth()) / 2
            b.y = (m.screen.app.screen.height - b.getHeight()) / 2
            
            m.screen.app.screen.addOSD(m.screen.app.timer.totalMilliseconds(), {
                name: "NoChannels",
                timeout: invalid,
                display: [b]
            })
        end if
    else if "STREAMING" = m.screen.app.data.getValue("InputSource") then
        m.screen.app.video.play()
        m.screen.app.currentScreen().changeVideoAction.displayMode = "Always"
    end if

    m.screen.app.data.get("Loading").set("false")
    ' AYT: we need to reload/update AQ parameters on source change, but on launch this
    ' script is run before the AQ parameters are read and populated. So this little check 
    aq = m.screen.app.data.get("aq")
    if aq <> invalid then
        reloadAQParameters(aq.features)
    end if
end sub

'-- Volume --'
function getVolume(tv as Object) as Integer
    ret = tv.getAudioVolume()

    if RokuMfgCheckLegacyResponse("getAudioVolume", ret) then
        return ret.value
    end if

    return 0
end function

sub updateVolume()   
    m.app.tv.setAudioVolume(m.get())
    m.app.data.get("Mute").setIndex(0)
end sub

'-- Mute --'
function getMute(tv as Object) as Integer
    ret = tv.getAudioMute()

    if RokuMfgCheckLegacyResponse("getAudioMute", ret) then
        if ret.state then
            return 1
        end if

        return 0
    end if

    return 0
end function

sub updateMute()
    m.app.tv.setAudioMute(m.index)
end sub

sub refreshUSBInfo()
    totalDrives = 1
    currentDrives = m.app.usb.volumes().count()

    m.value = RokuMfgStrCast(currentDrives) + "/" + RokuMfgStrCast(totalDrives)
end sub

sub refreshTunerInfo()
    ret = m.app.mfg.legacy.getChannelInfoByIndex(-1)

    if RokuMfgCheckLegacyResponse("getChannelInfoByIndex", ret) then
        m.value = RokuMfgStrCast(ret.channel)

        if ret.isDigital then
            m.value = m.value + "." + RokuMfgStrCast(ret.subchannel)
            m.isDigital = true
        else
            m.isDigital = false
        end if

        if ret.isCable then
            m.chType = "Cable"
        else
            m.chType = "Air"
        end if
    else
        m.value = ""
    end if
end sub

sub updateLoadingState()
    if "true" = m.get() then
        if invalid = m.app.screen.osds["InputSource"] then
            layout = m.app.ui.layoutText({
                text: m.app.data.getValue("InputSource"),
                color: "orange",
                font: "large",
                x: m.app.screen.visibleRight,
                y: m.app.screen.visibleTop
            })

            layout.x = layout.x - layout.w
            display = [layout]

            b = m.app.ui.layoutBox({
                padding: 20
                color: "black"
            })

            b.push(m.app.ui.layoutText({
                text: "Loading",
                font: "medium"
            }))
            b.x = (m.app.screen.width - b.getWidth()) / 2
            b.y = (m.app.screen.height - b.getHeight()) / 2
            display.push(b)

            timeout = 1000
            if "TUNER" = m.app.data.getValue("InputSource") then
                timeout = 2500
            end if

            m.app.screen.addOSD(m.app.timer.totalMilliseconds(), {
                name: "InputSource",
                timeout: timeout,
                display: display,
                onDelete: deleteInputChangeOSD
            })

            m.app.pushScreen("LoadingPlaceholder")
        end if
    else if "false" = m.get()
        m.app.exitScreen()
    end if
end sub

sub deleteHdrOsd()
    m.screen.app.setScreen("NoOverlay")
    m.screen.app.pushScreen("Main")
    m.screen.app.currentScreen().menuRoot.selectedChild = 0
end sub

sub updateHDRActiveState()
    if "SDR" <> m.get() then
        m.app.setScreen("HDRNoSupport")
    else
        timeout = 50
        input_osd = m.app.screen.osds["InputSource"]
        if invalid <> input_osd then
            timeout = timeout + input_osd.timeout
        end if

        m.app.screen.addOSD(m.app.timer.totalMilliseconds(), {
            name: "HDRInactive",
            timeout: timeout,
            display: invalid,
            onDelete: deleteHdrOsd
        })
    end if
end sub

function updateCPUXtalLevel()
    nextlvl = m.index
    print "does nothing for now, but should update the CPU Xtal level to " + m.get() + "(pq value: " + RokuMfgStrCast(nextlvl) + ")"
end function
