'TODO: Refactor this into smaller files for better organization later on.
sub constructFactoryData(app as Object)
    print "Initializing Data: Factory Settings"

    ' Determines whether or not we're in manufacturing mode.  Some features
    ' can only be run on the MFG image and not on the APP image.
    app.data.constructSelector({
        id: "ManufacturingMode",
        dataset: ["APP", "MFG"],
        index: getManufacturingMode(app.tv)
    })

    ' SoC name.
    app.data.constructString({
        id: "ChipType",
        value: getChipType(app.tv)
    })

    ' Version of Roku Software running currently.
    app.data.constructString({
        id: "SoftwareVersion",
        value: getSoftwareVersion(app.tv)
    })

    ' Roku TV model number
    app.data.constructString({
        id: "RokuTVModel",
        value: getRokuModel(app.tv)
    })

    ' OEM model number.
    app.data.constructString({
        id: "OEMModel",
        value: getOEMModel(app.tv),
        onUpdate: updateOEMModel
    })

    ' Roku's serial number.
    odmsn = app.data.constructString({
        id: "DeviceID",
        value: "N/A",
        refresh: refreshDeviceID
    })

    odmsn.refresh()

    rokusn = app.data.constructString({
        id: "RokuSN"
        value: getRokuSN(app.tv)
    })

    app.data.constructString({
        id: "Brand",
        value: getDeviceBrand(app.mfg)
    })

    app.data.constructSelector({
        id: "TestPatternLayer",
        dataset: ["Graphics", "Video"],
        onUpdate: updateTestPatternLayer,
        changed: false
    })
end sub

'-------------------- MFG Mode --------------------'
function getManufacturingMode(tv as Object) as Integer
    ret = tv.isManufacturingMode()

    if RokuMfgCheckLegacyResponse("isManufacturingMode", ret) then
        return ret.manufacturingMode
    end if

    return 0
end function

'-------------------- Chip Type --------------------'
function getChipType(tv as Object) as String
    ret = tv.getChipType()

    if RokuMfgCheckLegacyResponse("getChipType", ret) then
        return ret.str
    end if

    return "<ERROR>"
end function

function getSoftwareVersion(tv as Object) as String
    ret = tv.GetTVSoftwareVersion()

    if RokuMfgCheckLegacyResponse("getTVSoftwareVersion", ret) then
        if getManufacturingMode(tv) then
            ret.str = ret.str + " (MFG)"
        end if

        return ret.str
    end if

    return "<ERROR>"
end function

function getRokuModel(tv as Object)
    print "getRokuModel"

    if RokuMfgIsSigmaPlatform() then
        key = "info/model"
        ret = RokuMfg().call("custominfo", {
            action: "get",
            data: key
        })

        if RokuMfgCheckResponse(ret) then
            return ret.data[key]
        end if
    else
        ret = tv.getRokuModel()

        if RokuMfgCheckLegacyResponse("getRokuModel", ret) then
            return ret.str
        end if
    end if

    return "<ERROR>"
end function

function getOEMModel(tv as Object)
    print "getOEMModel"
    ret = tv.getTvModel()

    if RokuMfgCheckLegacyResponse("getTvModel", ret) then
        return ret.str
    end if

    return "<ERROR>"
end function

sub updateOEMModel()
    print "updateOEMModel"
    RokuMfgCheckLegacyResponse("setTvModel", m.app.tv.setTVModel(m.get()))
end sub

'-- Roku SN --'
function getRokuSN(tv as Object)
    ret = tv.getSerialNumber()

    if RokuMfgCheckLegacyResponse("getSerialNumber", ret) then
        return ret.serial
    end if

    return "<ERROR>"
end function

'-- Brand --'
function getDeviceBrand(mfg as Object) as String
    key = "info/brand"
    ret = mfg.call("custominfo", {
        action: "get",
        data: key
    })

    if RokuMfgCheckResponse(ret) then
        return ret.data[key]
    else
        return "Roku"
    end if

end function

sub refreshDeviceID()
    ret = m.app.tv.getLegacySerialNumber()

    if RokuMfgCheckLegacyResponse("getLegacySerialNumber", ret) then
        m.value = ret.serial
    end if
end sub

sub updateTestPatternLayer()
    value = m.get()
    if "Graphics" = value or "Video" = value then
        m.changed = true
        RokuMfgCheckLegacyResponse("setTestPatternsVideoPlane", m.app.tv.setTestPatternsVideoPlane(m.index))
    else
        print "Unknown pattern layer: " + RokuMfgStrCast(m.get())
    end if
end sub