sub initAgingModule(app as Object)
    o = {
        name: "Aging",
        app: app,
        currentState: 0,
        states: 4,
        stateInterval: 3,

        start: startAging,
        stop: stopAging,

        keyFilter: agingKeyFilter,
        prepare: prepareAgingScreen
    }

    app.aging = o
end sub

sub startAging()
    ' Save last menu, so we can return to it after we exit aging mode.
    m.time = createObject("roTimespan")
    m.time.mark()

    m.app.pushScreen(m)

    ' Kill any OSDs
    m.app.screen.clearItems()
    m.app.screen.osds.clear()
end sub

sub stopAging()
    m.time = invalid
    m.currentState = 0
    m.app.exitScreen()

    ' Restore previous menu.
    m.app.screen.clearItems()
    m.app.screen.osds.clear()
end sub

function agingKeyFilter(context as Object, keycode as Integer)
    ' Eat any and all keypresses except for the AGING key (to stop aging).
    if context.app.keycodes["AGING"] = keycode then
        return keycode
    end if

    return invalid
end function


sub prepareAgingScreen()
    m.app.screen.midItems.items = [m.app.ui.layoutRectangle({
        color: "white",
        x: 0,
        y: 0,
        w: m.app.screen.width,
        h: m.app.screen.height
    })]

    ' We use a little trick to get this to work easily.  Basically, when the
    ' aging icon OSD expires, we know that it's time to update to the next state.
    if invalid = m.app.screen.osds["Aging"] then
        b = m.app.ui.layoutText({
            text: "M",
            color: "red",
            font: "large"
            x: 25, y: 20
        })

        if m.currentState and 2 then
            b.y = m.app.screen.height - (b.y + b.h)
        end if

        if m.currentState = 1 or m.currentState = 2 then
            b.x = m.app.screen.width - (b.x + b.w)
        end if

        m.currentState = (m.currentState + 1) mod 4

        m.app.screen.addOSD(0, {
            name: "Aging",
            timeout: 3000,
            display: [b]
        })

    end if
end sub