'*********************************************************************
'*********************************************************************
function quotestr(str as string) as string
    return chr(34) + str + chr(34)
end function

function MaketransportJSON(cmd as string) as string
   newtrans = quotestr("transport."+cmd)
   e = quotestr("entities")
   i = quotestr("intent")
   s = quotestr("sessionid")
   v = quotestr("bla bla")
   'newjson =  {"entities":{},"intent":"transport.shuffle","sessionid":"6cd0f0b1-e037-4a17-82d4-3df181e20ca5"}
   newjson = "{"+e+":{},"+i+":"+newtrans+","+s+":"+v+"}"
   return newjson
end function

Function RunVoiceAdapter(params)
    print "Running VoiceAdapter"
    m.tts_prt = CreateObject("roMessagePort")
    m.vr = CreateVoiceRendering(false)
    m.va = CreateObject("roVoiceAdapter")

    if (m.va = invalid) then
        SpeakPhrase("service.voice.error.no-voice-detected", {})
        setConversationStateError()
        return 1
    end if

    newJSON = params["voice_intent"]

    intentAA = parseIntent(newJSON)
    if (intentAA = invalid) then
        SpeakPhrase("service.voice.error.unknown-intent", {})
        setConversationStateError()
        return 2
    end if

    intentTerm = intentAA.term
    print "INTENT TERM ";intentTerm

    ' tunneling
    if intentTerm="music"
        if intentAA.command = "request"
             print "Tunnel Search entities="
             print intentAA.entities
             e = intentAA.entities
             mt = e.music_track
             if mt <> invalid
                if mt = "repeat" or mt = "repete"
                    print "FOUND REPEAT COMMAND"
                    newJSON =  MaketransportJSON("repeat")
                    intentAA = parseIntent(newJSON)
                else if mt = "settings"
                    print "FOUND SETTINGS COMMAND"
                    newJSON =  MaketransportJSON("settings")
                    intentAA = parseIntent(newJSON)
                endif
             endif
        end if
    end if
    intentTerm = intentAA.term

    ' determine the type of intent and try to handle it.
    ' the value returned from the handle functions just determines
    ' whether the default error handler should execute. there
    ' may still have been an error but it was handled in a more
    ' specific manner by the handler.
    result = invalid
    if (intentTerm = "transport") then
        result = handleTransportIntent(intentAA)
    else
        result = { json: newJSON }
    end if

    if (result = invalid) then
        SpeakPhrase("service.voice.error.failure", {})
        setConversationStateError()
        return 3
    end if
    trackConversationState(intentAA, result)
    print "return from RunVoiceAdapter"
    return 0
End Function

function isValid(val as dynamic) as boolean
    return type(val) <> "roInvalid" and type(val) <> "Invalid"
end function

'******************************************************
'itostr
'
'Convert int to string. This is necessary because
'the builtin Stri(x) prepends whitespace
'******************************************************
Function itostr(i As Integer) As String
    str = Stri(i)
    return strTrim(str)
End Function

'******************************************************
'Trim a string
'******************************************************
Function strTrim(str As String) As String
    st=CreateObject("roString")
    st.SetString(str)
    return st.Trim()
End Function

Function AnyToString(any As Dynamic) As dynamic
    if any = invalid return "invalid"
    if isstr(any) return any
    if isint(any) return itostr(any)
    if isbool(any)
        if any = true return "true"
        return "false"
    endif
    if isfloat(any) return Str(any)
    if type(any) = "roTimespan" return itostr(any.TotalMilliseconds()) + "ms"
    if type(any) = "roDateTime" return DateTimeToString(any)
    return invalid
End Function

'*********************************************************************
'**  Log a message to server
'*********************************************************************
Function LogMessage(id as String, msgAA as Object)
    msgStr = ""
    for each item in msgAA
        msgStr = msgStr + " " + AnyToString(item)
    end for
    print "log." ; id ; " - " ; msgStr
end function

'*********************************************************************
' extract intent, entities and modifiers
'*********************************************************************
Function parseIntent(json)
    hasError = false
    if (json = invalid) then
        LogMessage("parse.intnt.err.none",["no intent"])
        SpeakPhrase("service.voice.error.failure", {})
        return invalid
    end if

    print " Parsing intent text: ";json
    aa = parseJSON(json)
    if (aa = invalid) then
        LogMessage("parse.intnt.err.fail",["failed to parse intent"])
        SpeakPhrase("service.voice.error.failure", {})
        return invalid
    end if

    print "AA=";aa

    intent_name = aa["intent"]
    intent_name_split = intent_name.split(".")
    intentTerm = intent_name_split[0]
    intentCommand = intent_name_split[1]
    resultAA = {
        intent    : intent_name,
        term      : intentTerm,
        command   : intentCommand }

    searchFor = ""
    print "intent_name=";intent_name
    if isValid(aa.entities)
      if aa.entities.Count() > 0 then
        entityAA = {}
        for each entityKey in aa.entities
            print "key=";entityKey
            if entityKey <> "roku_channel" then
                entityValueArray = aa.entities.Lookup(entityKey)
                print "ValArray=";entityValueArray
                entityValueAA = entityValueArray[0]
                print "Array0=";entityValueAA
                if entityKey <> "duration"
                    val = LCase(AnyToString(entityValueAA.Lookup("value")))
                    entityAA.AddReplace(entityKey, val)
                    searchFor = searchFor + val + " "
                else
                    print "COMPUTING DURATION"
                    val = LCase(AnyToString(entityValueAA.Lookup("value")))
                    unit = LCase(AnyToString(entityValueAA.Lookup("unit")))
                    entityAA.AddReplace(unit, val)
                    print entityAA
                endif
            end if
        end for
        resultAA.AddReplace("entities", entityAA)
      end if
    end if
    return resultAA
End Function

function getDuration(e) as integer
    secs% = 0
    if e = invalid
        secs% = 10
    else
        if e.seconds <> invalid
            secs% = e.seconds.toint()
        else if e.second <> invalid
            secs% = e.second.toint()
        endif
        if e.minutes <> invalid
            secs% = secs% + e.minutes.toint()*60
        else if e.minute <> invalid
            secs% = secs% + e.minute.toint()*60
        endif
        if e.hours <> invalid
            secs% = secs% + e.hours.toint()*3600
        else if e.hour <> invalid
            secs% = secs% + e.hour.toint()*3600
        endif
    endif
    return secs%
end function

'*********************************************************************
'** handlers for different intent types
'*********************************************************************
Function handleTransportIntent(intentAA as Object)
    icmd = intentAA.command
    print "handle Transport:";icmd
    print intentAA

    result = invalid

    if (icmd = "play") OR (icmd = "resume") then
        cmd = "play"
    else if (icmd = "pause") then
        cmd = "pause"
    else if (icmd = "replay") then      ' should not get these, they should be handled by firmware
        ' do a 10 second rewind for replay
        cmd = "rewind"
        result = { control_command:cmd
                   val: "10"
                 }
    else if (icmd = "startover") then
        cmd = "startover"
    else if (icmd = "rewind") then
        seconds = 0
        cmd = "rewind"
        e = intentAA.entities
        if e = invalid
            seconds = 10
        else
            seconds = getDuration(e)
        endif
        result = { control_command:cmd
                   val: stri(seconds)
                 }
    else if (icmd = "stop") then
        cmd = "stop"
    else if (icmd = "shuffle") then
        cmd = "shuffle"
    else if (icmd = "repeat") then
        cmd = "repeat"
    else if (icmd = "settings") then
        cmd = "settings"
    else if (icmd = "forward")
        seconds = 0
        cmd = "forward"
        e = intentAA.entities
        if e = invalid
          seconds = 10
        else
            seconds = getDuration(e)
        endif
        result = { control_command:cmd
                   val: stri(seconds)
                 }
    else if (icmd = "seek")
        seconds = 0
        e = intentAA.entities
        if e = invalid
          cmd = "forward"
          seconds = 10
        else
            if e.direction = "forward"
                cmd = "forward"
            else if e.direction = "back"
                cmd = "rewind"
            else
                print "unknown direction"
            endif
            seconds = getDuration(e)
        endif
        print "Seeking ";seconds;" seconds";" cmd=";cmd
        result = { control_command:cmd
                   val: stri(seconds)
                 }
    else if (icmd = "next" or icmd = "skip") then
        cmd = "skip"
    else if (icmd = "play_pause")
        cmd = "play_pause"
    else
        LogMessage("ctrl.intnt.junk",["don't handle this control", icmd])
        return invalid
    end if

    LogMessage("ctrl.intnt.snd.app",["send command to app", cmd])
    print "Sending control command to app: " ; cmd
    if result = invalid
        result = {control_command:cmd}
    endif
    return result
End Function

'*********************************************************************
'**  TTS
'*********************************************************************
Sub SpeakPhrase(tags, params)
    m.vr.Say(tags, params, {wait: true})
End Sub

'*********************************************************************
' tracking conversation state
' wait 10.5 seconds before declaring the conversation as an error
'*********************************************************************
Sub trackConversationState(intentAA As Object, result As Object)
    port = CreateObject("roMessagePort")
    input = CreateObject("roInput")
    input.SetMessageport(port)
    intentTimer = CreateObject("roTimespan")
    waitForResponse = true

    intentTerm = intentAA.term
    print "sending intent term to app "
    print intentAA

    m.va.postToApp(result)
    print "wait for response"
    intentTimer.Mark()
    while(waitForResponse)
        msg = wait(1000, port)
        msgtype = type(msg)
        if msgtype <> "Invalid"
          print "Got some sort of response msgtype=";msgtype
          if (msgtype = "roInputEvent") then
            dataAA = msg.GetInfo()
            if dataAA.DoesExist("say") then
                SpeakPhrase(dataAA.say, {})
                exit while
            endif
            if dataAA.DoesExist("nowPlaying") then
                if intentTerm <> "transport" AND intentTerm <> "content" then
                    SayTTSByContent(dataAA)
                    m.va.postToApp({command: "start_playback"})
                    sleep(1)
                    exit while
                end if
            endif
            if dataAA.DoesExist("hasError") then
                tag = ""
                tagVals = {}
                if dataAA.Lookup("hasError") = "true" then
                    setConversationStateError()
                    speakError(intentAA)
                else
                    setConversationStateSuccess()
                end if
                exit while
            end if
          end if
        end if
        if intentTimer.TotalSeconds() > 60 then
            print "TIMED OUT"
            LogMessage("adaptor.intent.timeout",["failed to retrieve conversation state, timed out"])
            SpeakPhrase("video.search_result_empty", {})
            setConversationStateError()
            exit while
        end if
    end while
    print "track conversation state - exit"
End Sub

Sub setConversationStateSuccess()
    print "CONVERSATION STATE SUCCESS"
    convState = {value: "success"}
    LogMessage("set.con.state",["success"])
    m.va.SetConversationState(convState)
end Sub

Sub setConversationStateError()
    print "CONVERSATION STATE ERROR"
    convState = {value: "error"}
    LogMessage("set.con.state",["error"])
    m.va.SetConversationState(convState)
end Sub

Sub speakError(intentAA As Object)
    intentTerm = intentAA.term
    tag = intentTerm + ".playing_error"
    tagVals = {}
    entitiesAA = intentAA.entities
    if isValid(entitiesAA) and entitiesAA.Count() > 0 then
        for each entityKey in entitiesAA
            if entityKey <> "roku_channel" then
                tag = tag + ":" + entityKey
                tagVals.AddReplace(entityKey, entitiesAA.Lookup(entityKey))
            end if
        end for
    end if
    SpeakPhrase(tag, tagVals)
end Sub

sub SayTTSByContent(dataAA as Object)
    tag = "music.playing"
    tagVals = {}

    musicParams = ParseJSON(dataAA.nowPlaying)
    if musicParams <> invalid then
        for each key in musicParams
            tagVals.AddReplace(key, musicParams[key])
        end for
    end if

    setConversationStateSuccess()
    SpeakPhrase(tag, tagVals)
end sub
