'*********************************************************************
'** Util_GetManifest
'*********************************************************************
Function Util_GetManifest() As Object

    manifest = {}

    text = ReadAsciiFile( "pkg:/manifest" )
    lines = text.Tokenize( Chr( 10 ) )

    for each line in lines
        line = line.Trim()
        if (line.Len() = 0)
            '** empty line
        else if (line.Left( 1 ) = "#")
            '** comment line
        else
            sepPos = line.Instr( "=" )
            if (sepPos <= 0)
                '** invalid
            else
                name = line.Mid( 0, sepPos )
                value = line.Mid( sepPos + 1 )
                manifest.AddReplace( name, value )
            end if
        end if
    end for

    return manifest

End Function

function getTilesPerRow(fileType as Integer, total as integer) as Integer
    gridStyle = GetGridRowsStyle()
    if gridStyle = ShortGridRowsStyleID() or gridStyle = DefaultGridRowsStyleID() 'short rows
        if fileType = VideoID() or fileType = PictureID()
            return 4 ' video and images have landscape aspect ratio
        else if fileType = AudioID()
            return 5 ' audio files have square aspect ratio
        end if
    else if gridStyle = LongGridRowsStyleID() 'long rows
        return 50
    end if
    return 0
end function

' escape the regex magic characters
function deFang(str as string) as string
        r = CreateObject("roRegex","([\^\[\.\$\{\*\(\\\+\)\|\?\<\>\}\]])","")
        newstr = r.ReplaceAll(str,"\\\1")
        return newstr
end function

function convertTimeToStr(timeInSeconds as Integer) as String
    hours% = timeInSeconds / 3600
    if hours% < 1 then
        minutes% = timeInSeconds / 60
        if minutes% < 1 then
            ret = ""
            if timeInSeconds > 0
                ret = stri(timeInSeconds) + "s"
            end if
            return ret
         end if
         secondsLeft% = timeInSeconds - minutes% * 60
         ret = stri(minutes%) + "m"
         if secondsLeft% <> 0 then
            ret = ret + + " " + stri(secondsLeft%) + "s"
         end if
         return ret
    end if
    timeLeft% = timeInSeconds - hours% * 3600
    return str(hours%) + "h" + " " + convertTimeToStr(timeLeft%)
end function

function inttotimelead0(t as integer) as string
    if t > 9
        return stri(t,10)
    endif
    return "0"+stri(t,10)
end function

function convertDurationIntToStr(dur as integer) as string
    d% = dur/1000
    hours% = d%/3600
    d% = d% - hours% * 3600
    minutes% = d%/60
    seconds% = d% - minutes% * 60
    if hours%>0
        v = inttotimelead0(hours%)+":"
    else
        v = ""
    endif
    return v+inttotimelead0(minutes%)+":"+inttotimelead0(seconds%)    
end function

function convertDurationStrToInt(durString as String) as integer
    ' convert hh:mm:secs.milliseconds
    if (isVerbose()) print "Found duration attribute=";durString
    hours = 0
    minutes = 0
    seconds = 0
    posi = 0
    ' find first colon
    colon = durString.instr(":")
    if colon > 0
        str = durString.mid(0, colon)
        hours = str.toint()
        posi = colon + 1
    ' look for next colon to get minutes
        colon = durString.instr(posi,":")
        if (colon > 0)
            str = durString.mid(posi,colon - posi)
            minutes = str.toint()
            posi = colon + 1
        endif
    endif
    period = durString.instr(".")
    if period > 0
        seconds = durString.mid(posi, period - posi)
    else
        seconds = durString.mid(posi, 5)
    endif
    ' Fraction part is ignored
    return ((60 * hours) + minutes) * 60 + seconds.toint()
end function

Function makePathWithExtention(original, extension) as String
     ' only search in the last 5 characters for a period, this will allow for a 4 character extension
     i = len(original)-5
     if (i<=1) i = 2 ' always start at the second character or 5 character from the end which ever is closer to the end
     extensionPos = instr(i, original, ".")
     ' if we found a period, use i
     if extensionPos > 0
        newstring = left(original, extensionPos)+ extension
     else ' could not find an extension, just append
        newstring = original + "." + extension
     endif
     'print "mP2Ext orig=";original;"  new=";newstring
     return newstring
end function

Function makeNameFromPath(path as String, name as String) as String
     ret$ = path + "/" + name
     'print "makeNameFromPath";ret$
     return ret$
end function

function getElementItemIndex(element, array) as Integer
    index% = 0
    for each item in array
        if element.usn = item.usn then
            return index%
        end if
        index% = index% + 1
    next
    return 0
end function

function getLeftBreadCrumb() as string
    activeVolume = getActiveVolume()
    if (activeVolume <> invalid AND isPro())
        return getMediaTypeFilters()[getMTFilter()] + "(" + activeVolume.title + ")"
    endif
    return getMediaTypeFilters()[getMTFilter()]
end function

function intToZeroString(i, zeroes) as string
    trackstr = i.tostr()
    zeroesNeeded = zeroes-trackstr.len()
    if zeroesNeeded=3 then return "000"+trackstr
    if zeroesNeeded=2 then return "00"+trackstr
    if zeroesNeeded=1 then return "0"+trackstr
    if zeroesNeeded=0 then return trackstr
    for i = 1 to zeroesNeeded
        trackstr = "0"+trackstr
    end for
    return trackstr
end function

' Shuffle utility
function SwapArrayIndices(idx1 as Integer, idx2 as Integer, contentList as Object) as Void
    count = contentList.Count()
    'sanity check
    if idx1 >= count or idx2 >= count or idx1 < 0 or idx2 < 0then
        return
    end if
    tmp = contentList[idx1]
    contentList[idx1] = contentList[idx2]
    contentList[idx2] = tmp    
end function

function GetIndexOfObjectID(objectID as String, contentList as Object) as Integer
    i% = 0
    for each element in contentList
        if element.objectID = objectID then
            return i%
        end if
        i% = i% +1
    end for
    return -1
end function

Function RandomizeArray(source as Object, first as integer) as Object
    count% = source.Count()
    print "RandomizeArray count=";count%;" first=";first
    dim numbers[count%]
    dim destination[count%]
    start% = 1
    if (first < 0) or (first >= count%)    ' randomize entire array
        for i% = count% - 1 to 0 step -1
            numbers[i%] = i%
        next
    else    ' set requested first to first in array
        count% = count% - 1
        start% = 0
        destination[0] = source[first]
        for i% = count% to first+1 step -1
            numbers[i%-1] = i%
        next
        for i% = first - 1 to 0 step -1
            numbers[i%] = i%
        next
        numbers.Delete(count%)
    endif
    for i% = count% to 1 step -1
        index% = RND(i%)-1
        destination[i%-start%] = source[numbers[index%]]
        numbers.Delete(index%)
    next
    return destination
End Function

Function RandomizeArrayNotFirst(source as Object, notFirst as integer) as Object
    count% = source.Count()
    lastIndex% = count%-1
    if count% > 1
        ' choose a new first from the remaining
        index% = RND(lastIndex%)
        first% = notFirst + index%
        if first% > lastIndex%
            first% = first% - count%
        endif
        print "RandomIzeNotFirst newFirst=";first%;" notFirst=";notFirst;" index=";index%;" lastIndex=";lastIndex%
        return RandomizeArray(source, first%)
    else
        return RandomizeArray(source, notFirst)
    endif
End Function

' Returns a copy of the array with all items shifted such that the
' item at index first in source is the first item in the returned
' array.
Function DuplicateAndShiftArray(source as Object, first as Integer) as Object
    ct = source.Count()
    a = CreateObject("roArray",ct,true)
    for i=0 to ct-1 step 1
        source_i = (first + i) MOD ct
        a.Push(source[source_i])
    end for
    return a
End Function

function isHttp(url as string)
    return lcase(Left(url,4)) = "http"
end function

function getGuid(volume as object, url as string)
   if isHttp(url)
      return url
   else  ' cant use url, that is based on the mount point and that can change
        ' construct guid to use label of volume
      guid = ""
      if isStr(volume.label) then guid += volume.label 
      findcolon = url.instr(":")
      guid += url.mid(findcolon)
      return guid
   endif
end function

function logMessage(s as string,l as object)
     print s;
     for each t in l
        print t;
     next
     print
end function

function isInvalid(val as dynamic) as boolean
    return type(val) = "roInvalid" OR type(val) = "Invalid"
end function

function isValid(val as dynamic) as boolean
    return type(val) <> "roInvalid" AND type(val) <> "Invalid"
end function

function rmpencode(k) as string
    pre = ""
    if GetInterface(k, "ifString") <> invalid
        pre = "00"
        t = k.getString()
    else if GetInterface(k, "ifInt") <> invalid
        pre = "01"
        t = k.tostr()
    else if GetInterface(k, "ifBoolean") <> invalid
        pre = "02"
        t = k.tostr()
    else if GetInterface(k, "ifLongInt") <> invalid
        pre = "03"
        t = k.tostr()
    else
        ?"rmpencode critical error!"
    endif
    return quotestr(pre+t.escape())
end function

function AAtoRMP(aa) as string
    if type(aa) <> "roAssociativeArray"
        ?"AAtoRMP critical error!"
    endif
    r = box("")
    for each key in aa
        val = aa[key]
        if val <> invalid
            s = key + "@" + rmpencode(val) + "@"
            r.appendstring(s,s.len())
        endif
    next
    if r <> ""
        return r.left(r.len()-1)
    endif
    return r
end function

function rmpdecode(s)
    pre = s.left(2)
    t = s.right(s.len()-2)
    t = t.unescape()
    if (pre = "00") return t
    if (pre = "01") return t.toint()
    if (pre = "02")
        if t="true" return true
        return false
    endif
    if (pre = "03")
        t = t.trim()
        rtBits = t.right(8)
        ltBits = t.left(t.len()-8)
        r = createobject("rolonginteger")
        r.setlongint(ltBits.toint()*100000000&)
        r = r + rtBits.toint()
        if r.tostr() <> t
            return invalid
        endif
        return r
    endif
    return invalid
end function

function unquotestr(s)
    return s.mid(1,s.len()-2)
end function

function RMPtoAA(s)
    mainaa = {}
    lines = s.split(winNL())
    ' skip the first line
    j% = 1
    lcount% = lines.count()
    print "RMPtoAA: lcount=";lcount%
    while j%<lcount%
      l = lines[j%]
      'print "processing line:";j%
      'print l
      if l.len() > 2
        strs = l.split("@")
        mainkey = strs[0]
        ' new key is stored escaped
        ' all unescaped keys are stored with a slash prefix, but we now handle errors without crashing
        if mainkey.left(1) <> "/"
            mainkey = mainkey.unescape()
        endif
        aa = {}
        i% = 1
        count% = strs.count()
        while i% < count%
            key = strs[i%]
            qq = strs[i%+1]
            'print "i=";i%;" key=";key;" val=";qq
            val = unquotestr(qq)
            'print "key=";key;" val=";val
            zz = rmpdecode(val)
            if zz <> invalid
                aa[key] = zz
            else
                aa = invalid
                exit while
            endif
            i% = i% + 2
        end while
        if aa <> invalid
            mainaa[mainkey] = aa
        else
            print "Skipping invalid cache line:";l
        endif
      endif
      j% = j% + 1
    end while
    return mainaa
end function

function quotestr(str as string) as string
    return chr(34) + str + chr(34)
end function

function WinNL()
    return chr(13) + chr(10)
end function

function GetRootObjectID() as String
    return "0"
end function
