'Groups content by tiles per row
'if folders are present the're added first and then media with array of tilesPerRow of items
function GroupByTiles(folders, allMediaContent, tilesPerRow) as Object
    print "GroupByTiles enter--- allmediacontent.count=";allMediaContent.Count()
    result = []
    isListFormat = (getContentDisplayFormatSetting() = ListFormatID())
    'push all folders into first row
    if folders <> invalid and folders.children <> invalid
        if not isListFormat
            gridDisplayStyle = GetGridRowsStyle()
            if gridDisplayStyle = DefaultGridRowsStyleID()
                dirTilesPerRow = 0
            else if gridDisplayStyle = ShortGridRowsStyleID()
                dirTilesPerRow = 5
            else if gridDisplayStyle = LongGridRowsStyleID()
                dirTilesPerRow = 50
            end if
        else        
            dirTilesPerRow = 5
        end if
        newmFoldersRow = {
            title: Tr("Folders")
            type: dirID()
            children: []
            contentType: "section"
        }
        while (folders.children.Count() > 0)
            folder = folders.children.shift()
            newmFoldersRow.children.Push(folder)
            'break into multi rows if user selects media filter
            if tilesPerRow > 0 and newmFoldersRow.children.Count() = dirTilesPerRow
                result.Push(newmFoldersRow)
                newmFoldersRow = {
                    type: dirID()
                    children: []
                    contentType: "section"
                }
            end if
        end while
        'pushing last row with folders
        if newmFoldersRow.children.Count() > 0
            result.Push(newmFoldersRow)
        end if
    end if

    mediaRowsByType = {
        video: []
        audio: []
        images: []
    }
    'sort media files to set in correct row
    while allMediaContent.Count() > 0
        item = allMediaContent.shift()
        if item.type = videoID()
            AddItemToRow(mediaRowsByType, item, "Video", tilesPerRow)
        else if item.type = AudioID()
            AddItemToRow(mediaRowsByType, item, "Audio", tilesPerRow)
        else if item.type = PictureID()
            AddItemToRow(mediaRowsByType, item, "Images", tilesPerRow)
        end if
    end while
    'append media rows in correct order
    result.append(mediaRowsByType.video)
    result.append(mediaRowsByType.audio)
    result.append(mediaRowsByType.images)

    return result
end function

sub AddItemToRow(mediaRowsByType as Object, item as Object, sType as String, tilesPerRow as Integer)
    currRow = mediaRowsByType[sType].Peek()
    if currRow = invalid or currRow.children.Count() = tilesPerRow
        title = ""
        'add title only to first row in sType section
        if currRow = invalid
            title = Tr(sType)
        end if
        currRow = {
            type: item.type ' row of media
            children: []
            title: title
            contentType: "section"
        }
        mediaRowsByType[sType].Push(currRow)
    end if
    currRow.children.Push(item)
end sub

function ContentCounterToMediaType(counter) as integer
     return counter[5]
end function

function getTypeCount(counter) as String
    countStr = ""
    countSuffix = ""
    index = 0
    singleItemCaption = [tr("item"), tr("video"), tr("audio"), tr("photo")]
    pluralItemCaption = [tr("items"), tr("videos"), tr("audios"), tr("photos")]
    index = ContentCounterToMediaType(counter)

    if index <> 0
        itemsCount = counter[index]
    else
        itemsCount = counter[1] + counter[2] + counter[3]
    end if

    countStr = stri(itemsCount)
    if itemsCount > 1 then
        countSuffix = pluralItemCaption [index]
    else
        countSuffix = singleItemCaption [index]
    end if

    return countStr + " " + countSuffix
end function

function isMediaPresent(counter) as boolean
    if counter[1] > 0 or counter[2] > 0 or counter[3] > 0 then
        'print "MEDIA IS PRESENT"
        return true
    end if
    return false
end function

function makeProperCountDescription(counter, mediaFilter) as String
    if counter = invalid return ""
    countDescription = ""
    token = ""
    singleItemCaption = [tr("folder"), tr("video"), tr("audio"), tr("photo")]
    pluralItemCaption = [tr("folders"), tr("videos"), tr("audios"), tr("photos")]
    itemCaption = pluralItemCaption
    if counter[0] > 0 then
        if counter[0] > 1 then
            countDescription = stri(counter[0]) + " "  + pluralItemCaption[0]
        else
            countDescription = stri(counter[0]) + " "  + + singleItemCaption[0]
        end if
        token = " /"
    endif

    if isMediaPresent(counter) then
        if mediaFilter = 0 then 'if no filter show all
            countDescription = countDescription + token + getTypeCount(counter)
        else
            if counter[mediaFilter] < 2 then
                itemCaption = singleItemCaption
            end if
            countDescription = countDescription + token + stri(counter[mediaFilter])+ " " + itemCaption[mediaFilter]
        end if
    end if
    if countDescription = "" then
        countDescription = tr("0 supported items")
    end if
    return countDescription
end function

function FilterFoldersByContent(folders, mediaFilter) as Object
    'print "FilterFoldersByContent enter-----------------------------------"
    updatedList = []
    for each folder in folders
        bAddFolder = false
        'if folder.itemsCountByMediaType[4] <> 0 then ' if not empty - add
         'print "FilterFoldersByContent enter----------------------------------- filter = ";mediaFilter
            'if mediaFilter = 0  or (folder.itemsCountByMediaType[mediaTypeToFileType(mediaFilter)] > 0 or folder.itemsCountByMediaType.dir > 0 )then 'no filtering
                folder.shortDescriptionLine2 = makeProperCountDescription(folder.itemsCountByMediaType, mediaFilter)
                updatedList.Push(folder)
           ' end if
        'endif
    next
    folders = updatedList
    return folders
end function
'Filters content by mediat type
'Regroups from tiles per row, filters and then groups by tiles again

function getSingleMedia(curDirMediaTypeCounter as Object) as Integer
        zeroCount = 0
        singleMedia = 0
        ret = 0
        maxID = maxFilterId() '
        for i = videoID() to maxID step 1
            if curDirMediaTypeCounter[i] = 0 then 'if on items of media type - increment counter
                zeroCount = zeroCount + 1
            else
                singleMedia = i 'remember non zero
            end if
        end for
        'TODO replace magic 2
        if zeroCount = 2 then
            ret = singleMedia
        end if
        return ret
end function

function ConvertGridToListContent(content as Object, media as Boolean) as Object
    if (content = invalid or content.GetChildCount() = 0) then return invalid
    allMediaContent = CreateObject("roSGNode", "ContentNode")
    rows = content.GetChildren(-1, 0)
    if media = true
        for each row in rows
            if row.type <> dirID() then
                'rowCopy = row.Clone(true) ' cloning each row takes much time for performance
                allMediaContent.appendChildren(row.GetChildren(-1, 0))
            end if
        next
    else ' extract just the folders and playlists
        for each row in rows
            if row.type = dirID() then
                'rowCopy = row.Clone(true) ' cloning each row takes much time for performance
                allMediaContent.appendChildren(row.GetChildren(-1, 0))
            end if
        next
    end if
    return allMediaContent
end function

function ObjectLocationInList(objectID as String, list as Object) as Object
    item% = 0
    for each element in list
        if element.objectID = objectID then
            return item%
        end if
        item% = item% + 1
    next
    return invalid
end function

function ObjectLocationInGrid(objectID as String, content as Object) as Object
    rowIndex = 0
    for each row in content.GetChildren(-1, 0)
        colIndex = 0
        for each col in row.GetChildren(-1, 0) 
            if col.objectId = objectID
                return [rowIndex, colIndex]
            end if
            colIndex++
        next
        rowIndex++
    next
    return invalid
end function


function FilterByMediaType(folders as Object, allMediaContent as Object, mediaFilter as Integer, sortType As Integer) as Object
    print "FilterByMediaType enter---filter=";mediaFilter
    timer = CreateObject("roTimeSpan")
    if (mediaFilter = invalid) then
        mediaFilter = 0
    end if
    filteredContent = []
    result = []
    curDirMediaTypeCounter = [0, 0, 0, 0, 0, 0] 'current dirrectory
    if folders.children.Count() = 0 and allMediaContent.Count() = 0 return result

    'apply sorting of directory and items
    if sortType <> sortingDefaultID() then
        'sort folders
        if allMediaContent <> invalid and allMediaContent.Count() > 0
            customSort(allMediaContent, sortType)
        end if
        'sort files
        if folders <> invalid and folders.children <> invalid and folders.children.Count() > 0
            customSort(folders.children, sortType)
        end if
    else
        if allMediaContent <> invalid and allMediaContent.Count() > 0
            customSort(allMediaContent, sortType)
        end if
    end if

    'filter by filetype
    if  mediaFilter = 0 then
        'push and count all files
        for each file in allMediaContent
             filteredContent.Push(file)
             curDirMediaTypeCounter[file.type] = curDirMediaTypeCounter[file.type] + 1
        next
        'check if we have single typed content, video/audio/photo only
        mType = getSingleMedia(curDirMediaTypeCounter)
    else
        for each file in allMediaContent
            if mediaFilter = file.type
                filteredContent.Push(file)
                curDirMediaTypeCounter[file.type] = curDirMediaTypeCounter[file.type] + 1
            end if
        next
        mType = mediaFilter
    end if
    if getContentDisplayFormatSetting() = ListFormatID()
        tilesPerRow = 0
    else if getMTFilter() = AllMediaId()
        gridDisplayStyle = GetGridRowsStyle()
        if gridDisplayStyle = DefaultGridRowsStyleID()
            tilesPerRow = 0
        else if gridDisplayStyle = ShortGridRowsStyleID()
            tilesPerRow = 5
        else if gridDisplayStyle = LongGridRowsStyleID()
            tilesPerRow = 50
        end if
    else
        tilesPerRow = getTilesPerRow(mType, filteredContent.count())
    end if
    result = GroupByTiles(folders, filteredContent, tilesPerRow)

    print "FilterByMediaType(";mediaFilter;") exit--";StrI(timer.TotalMilliseconds());" milliseconds"
    return result
end function

function FilteredList(origContentList as Object, origselectedIndex as Integer, filterID as Integer) as Object
    count = origcontentlist.GetChildCount()-1
    listok = true
    if getMTFilter() = allMediaId()
        ' do we need to create a new list?
        for i = 0 to count
            item = origcontentlist.GetChild(i)
            if item.type <> filterid
                listok = false
                exit for
            end if
        next
    end if
    if listok return { flist: origcontentlist, sItem : origselectedIndex }
    ' create a new list that just has filtered content in it and use that
    newcontent = CreateObject("roSGNode", "ContentNode")
    selectedIndex = origselectedIndex
    for i = 0 to count
        c = origcontentlist.GetChild(i).Clone(true)
        if c.type = filterid
            newcontent.AppendChild(c)
            if i = origselectedIndex
                ' remap selectedIndex so we start with the correct selection
                print "New selectedIndex =";selectedIndex;" was=";origselectedIndex
                selectedIndex = newcontent.GetChildCount()-1
            end if
        endif
    end for
    return { flist: newcontent, sItem : selectedIndex }
end function
