' ******************************************************
' Copyright Roku 2011,2012,2013.
' All Rights Reserved
' ******************************************************

' This file defines enumeration tags for some events thrown by the Roku platform.

'******************************************************
' C++ enum RequestFailedIndex from Netflix/include/Scripting/HostMsgs.h
' Index values for RequestFailed event
' Usage:
'     if msg.isRequestFailed() and msg.GetIndex() = RFI_TimedOut() ...
'******************************************************
function RFI_NetworkError() as integer: return  0: end function
function RFI_HttpError()    as integer: return -1: end function
function RFI_TimedOut()     as integer: return -2: end function
function RFI_Unknown()      as integer: return -3: end function
function RFI_EmptyList()    as integer: return -4: end function
function RFI_MediaError()   as integer: return -5: end function

'******************************************************
' C++ enum MediaError from Netflix/include/MediaControl/MediaControl.h
' Data values for RFI_MediaError event
' Usage:
'     if msg.isRequestFailed() and msg.GetIndex() = RFI_MediaError() and
'        msg.GetData() = MediaErrorNoVideo() ...
'******************************************************
function MediaErrorUnspecified()            as integer: return 0: end function ' Not further specified
function MediaErrorMalformedData()          as integer: return 1: end function ' Media is corrupt
function MediaErrorUnsupportedContainer()   as integer: return 2: end function ' Media container format not supported
function MediaErrorNoAudio()                as integer: return 3: end function ' Media has no audio tracks
function MediaErrorUnsupportedAudioFormat() as integer: return 4: end function ' Media has audio tracks but not of a supported format
function MediaErrorNoVideo()                as integer: return 5: end function ' Media has no video tracks
function MediaErrorUnsupportedVideoFormat() as integer: return 6: end function ' Media has video tracks but not of a supported format
function MediaErrorDisplayResTooLow()       as integer: return 7: end function ' Media requires a higher display resolution
function MediaErrorBitrateTooHigh()         as integer: return 8: end function ' Media bitrate too high to play

' EOF
