'*********************************************************************
'** Parse Intent
'** extract intent, entities and modifiers
'*********************************************************************
Function parseIntent(json)
    hasError = false
    if (json = invalid) then
        LogMessage("parse.intnt.err.none",["no intent"])
        return invalid
    end if

    print " Parsing intent json: ";json
    aa = parseJSON(json)
    if (aa = invalid) then
        LogMessage("parse.intnt.err.fail",["failed to parse intent"])
        return invalid
    end if

    intent_name = aa["intent"]
    intent_name_split = intent_name.split(".")
    intentTerm = intent_name_split[0]
    intentCommand = intent_name_split[1]
    resultAA = { 
        intent    : intent_name, 
        term      : intentTerm,
        command   : intentCommand }

    searchFor = ""
    if isValid(aa.entities) AND aa.entities.Count() > 0 then
        entityAA = {}
        conjunction = ""
        for each entityKey in aa.entities
            if entityKey <> "roku_channel" then
                entityValueArray = aa.entities.Lookup(entityKey)
                entityValueAA = entityValueArray[0]
                entityAA.AddReplace(entityKey, LCase(AnyToString(entityValueAA.Lookup("value"))))
                searchFor = searchFor + conjunction + entityKey + " " + LCase(AnyToString(entityValueAA.Lookup("value")))
                conjunction = " and "
            end if
        end for
        resultAA.AddReplace("entities", entityAA)
    end if
    voiceString = ""
    print "SEARCHFOR ";searchFor
    if searchFor <> "" then 
        voiceString = "searching for " + searchFor.replace("_"," ")
    end if
    if intentTerm <> "transport" and voiceString <> "" then
        ' Voice_Say(voiceString)
    end if
    resultAA.AddReplace("searchFor", searchFor)
    return resultAA
End Function

Sub Voice_Say(tag as String)
    if m.ECPinput <> invalid
        m.ECPinput.postToVoiceAdapter({ say: tag })
    endif
    print "VOICE_SAY: ";tag
End Sub
