
sub RSGCallback_ProccesCallback(event as Object)
    node = event.GetRoSGNode()
    field = event.GetField()
    gthis = GetGlobalAA()
    nodeUniqueId = RSGCallback_GetUniqueNodeId(node)
    if gthis.callbacksMap[nodeUniqueId] = invalid
        ? "Fatal Error: node is not found on callbacks map"
    else
        callbackObj = gthis.callbacksMap[nodeUniqueId][field]
        if callbackObj = invalid
            ? "Warning: callback for field ["field"] of ["node.Subtype()"] node not found"
        else
            callbackObj.handler[callbackObj.fn](node, event.GetData())
        end if
    end if
end sub

sub RSGCallback_RegisterNodeCallback(node as Object, field as String, handler as Object, functionName as String)
    if handler = invalid or handler[functionName] = invalid
        ? "Warning: tried to register field ["field"] for function ["functionName"] but handler function is invalid, skipping"
    end if
    if node = invalid
        ? "Warning: tried to register field ["field"] for function ["functionName"] but node is invalid, skipping"
        return
    end if
    if node.HasField(field)
        RSGCallback_AddCallback(node, field, handler, functionName)
        node.ObserveFieldScoped(field, "RSGCallback_ProccesCallback")
    else
        ? "Warning: tried to register field ["field"] but node ["node.Subtype()"] doesn't have this field, skipping"
    end if
end sub

sub RSGCallback_RemoveNodeCallback(node as Object, field as String)
    if node = invalid
        ? "Warning: tried to remove node callback for field ["field"] but node is invalid, skipping"
        return
    end if
    uniqueId = RSGCallback_GetUniqueNodeId(node)
    gthis = GetGlobalAA()
    if (gthis.callbacksMap = invalid) or (gthis.callbacksMap[uniqueId] = invalid) or (gthis.callbacksMap[uniqueId][field] = invalid)
        ? "Warning: tried to remove node callback for field ["field"] but there is no callback for this field"
    else
        gthis.callbacksMap[uniqueId][field] = invalid
        node.UnobserveFieldScoped(field)
        RSGCallback_CheckNodeCallbacks(uniqueId)
    end if
end sub

sub RSGCallback_AddCallback(node as Object, field as String, handler as Object, functionName as String)
    gthis = GetGlobalAA()
    if gthis.callbacksMap = invalid then gthis.callbacksMap = {}
    uniqueId = RSGCallback_GetUniqueNodeId(node)
    if gthis.callbacksMap[uniqueId] = invalid then gthis.callbacksMap[uniqueId] = {}
    gthis.callbacksMap[uniqueId][field] = {handler: handler, fn: functionName}
end sub

sub RSGCallback_CheckNodeCallbacks(uniqueId as String)
    gthis = GetGlobalAA()
    hasCallbacks = false
    for each field in gthis.callbacksMap[uniqueId]
        callback = gthis.callbacksMap[uniqueId][field]
        if callback <> invalid
            hasCallbacks = true
            exit for
        end if
    end for
    if not hasCallbacks then gthis.callbacksMap.Delete(uniqueId)
end sub

function RSGCallback_GetUniqueNodeId(node as Object)
    uniqueId = ""
    if node <> invalid
        if node.HasField("calbackId") = false
            gthis = GetGlobalAA()
            if gthis.nodeCallbacks = invalid then gthis.nodeCallbacks = 0
            node.AddField("calbackId", "string", false)
            node.calbackId = gthis.nodeCallbacks.ToStr()
            gthis.nodeCallbacks++
        end if
        uniqueId = node.Subtype() + "_" + node.calbackId
    else
        ? "Fatal Error: passed incorrect value to GetUniqueNodeId function"
    end if
    return uniqueId
end function
