function getLastFM() as object
    return m.lastFM
end function

function NWM_LastFM(apiToken, apiSecret)
    this = {
	apiToken:	apiToken
	apiSecret:	apiSecret
	aa_cache:	{}
	ta_cache:	{}
	GetAlbumInfo:	NWM_LFM_GetAlbumInfo
	GetTrackInfo:	NWM_LFM_GetTrackInfo
        GetStringFromURL: NWM_GetStringFromURL
        ExtractAlbumArt : NWM_extractAlbumArt
    }
    this.xmlParser = CreateObject("roXMLElement")
    this.ut = CreateObject("roURLTransfer")
    this.utPort = CreateObject("roMessagePort")
    this.ut.SetPort(this.utPort)
    this.timedout = false
    return this
end function

function NWM_extractAlbumArt(db as object, key as string, url as string) as object
    'print url
    raw = m.GetStringFromURL(url, 2000)
    if not m.timedout
	'print raw
        if raw <> ""
          xml = m.xmlParser
	  if xml.Parse(raw) then
            large = ""
            extralarge = ""
            ' try to get extralarge first
	    for each image in xml.album.image
		if ValidStr(image@size) = "extralarge"
                    result = {}
		    result.albumArtURL = ValidStr(image.GetText())
                    db.AddReplace(key, result)
                    return result
		end if
		if ValidStr(image@size) = "large"
		    large = ValidStr(image.GetText())
		end if
	    next
            if (large <> "")
                result = {}
		result.albumArtURL = large
                db.AddReplace(key, result)
                return result
            endif
          end if
        end if
        print "adding null entry for ";key
        db.AddReplace(key, {})
    end if
    return invalid
end function

function NWM_LFM_GetAlbumInfo(albumName, artistName)
    if m.timedout
        return invalid
    endif
    key = albumName+"|"+artistName
    'print "NWM_LFM_GetAlbumInfo key=";key

    if m.aa_cache.DoesExist(key)
        'print "nwm - cached - return now"
	return m.aa_cache.Lookup(key)
    else
        url = "http://ws.audioscrobbler.com/2.0/?method=album.getInfo&autocorrect=true&album=" + HttpEncode(albumName) + "&artist=" + HttpEncode(artistName) + "&api_key=" + m.apiToken
        result = m.ExtractAlbumArt(m.aa_cache, key, url)
        return result
    end if
end function

function NWM_LFM_GetTrackInfo(trackName, artistName)
    if m.timedout
        return invalid
    endif
    key = trackName+"|"+artistName
    'print "NWM_LFM_GetTrackInfo key=";key

    if m.ta_cache.DoesExist(key)
	return m.ta_cache.Lookup(key)
    else
        url = "http://ws.audioscrobbler.com/2.0/?method=track.getInfo&autocorrect=true&track=" + HttpEncode(trackName) + "&artist=" + HttpEncode(artistName) + "&api_key=" + m.apiToken
        result = m.ExtractAlbumArt(m.ta_cache, key, url)
        return result
    end if
end function

Function NWM_GetStringFromURL(url, timeout = 10000) as Dynamic
    result = ""
    'timeout = 10000
    ut = m.ut
    ut.SetURL(url)
    if ut.AsyncGetToString()
	event = wait(timeout, m.utPort)
	if type(event) = "roUrlEvent"
		result = event.GetString()
		'print "respcode="; event.GetResponseCode()
                'print "body=";result
	elseif event = invalid
                m.timedout = true
                print "lastFM timedout, setting timeout to avoid further requests"
		ut.AsyncCancel()
		REM reset the connection on timeouts
		m.ut = CreateObject("roURLTransfer")
                m.utPort = CreateObject("roMessagePort")
                m.ut.SetPort(m.utPort)
	else
		print "roUrlTransfer::AsyncGetToString(): unknown event"
	endif
    end if

    return result
End Function

' this function not used by Roku Media Player
'function NWM_LFM_GetArtistImage(artistName)
'    result = ""
'
'    raw = NWM_GetStringFromURL("http://ws.audioscrobbler.com/2.0/?method=artist.getimages&limit=1&artist=" + HttpEncode(artistName) + "&api_key=" + m.apiToken)
'    'print raw
'    xml2 = CreateObject("roXMLElement")
'    if xml2.Parse(raw) then
'	for each size in xml2.images.image.sizes.size
'	    if ValidStr(size@name) = "largesquare"
'		result = ValidStr(size.GetText())
'	    end if
'	next
'    end if
'    return result
'end function

