' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

function ShowVideoScreen(contentList as Object, item as Object, preload = false as Boolean, repeatAll = false as Boolean, shuffle = false as Boolean) as Object
    controller = GetBaseViewController("MediaView")
    controller.Append({
        contentList: contentList
        needToShuffle: shuffle
        initItem: item
        lastMediaServer: GetGlobalAA().lastMediaServer
        
        SetUpScreen: Video_SetUpScreen
        CleanUp: Video_CleanUp
        OnCurrentItemChanged: Video_OnCurrentItemChanged
        OnContentChanged: Video_OnContentChanged
        OnPositionChanged: Video_OnPositionChanged
    })
    controller.Observe(controller.view, "content", "OnContentChanged")
    controller.Observe(controller.view, "position", "OnPositionChanged")
    controller.Observe(controller.view, "currentItem", "OnCurrentItemChanged")

    controller.SetUpScreen(preload, repeatAll)
    ShowNewView(controller.view)
    
    return controller
end function

sub Video_SetUpScreen(preload as Boolean, repeatAll as Boolean)
    content = CreateObject("roSGNode", "ContentNode")
    isUSB = false
    if m.lastMediaServer <> invalid
        isUSB = m.lastMediaServer.accesstype = USBAccessType()
    end if
    config = {
        HandlerConfigMedia: {
            name: "VideoCH"
            fields: {
                contentList: m.contentList.clone(true)
                selectedItem: m.initItem
                isUSB: isUSB
            }
        }
    }
    content.Update(config, true)
    m.view.isContentList = true
    m.view.content = content
    m.view.repeatAll = repeatAll
    if preload
        m.view.preloadContent = true
    else
        m.view.control = "play"
    end if
end sub

' will be called when view was closed
sub Video_CleanUp()
    m.needToShuffle = true
    m.contentList = invalid
    m.initItem = invalid
end sub

sub Video_OnContentChanged(videoScreen as Object, content as Object)
    if content.hasField("jumpToItem")
        videoScreen.jumpToItem = content.jumpToItem
        content.removeField("jumpToItem")
    else if content.HandlerConfigMedia = invalid and content.getChildCount() > 0
        if m.needToShuffle
            videoScreen.shuffle = GetVideoShuffleSettings()
            m.needToShuffle = false
        end if
    end if
end sub

sub Video_OnPositionChanged(mediaView as Object, position as Integer)
    currentItem = mediaView.currentItem
    if currentItem <> invalid and currentItem.tricksAllowed
        if (position < 10) or (position > mediaView.duration*0.95)
            needToSave = NWM_Bookmarks().GetBookmarkForVideo(currentItem) > 0
            currentItem.playStart = 0
            NWM_Bookmarks().UpdateBookmarkForVideo(currentItem, needToSave)
        else
            currentItem.playStart = position
            'save the bookmark to memory every second and persist
            'it to flash every 10 seconds.
            saveBookmark = ((currentItem.playStart MOD 10) = 0)
            NWM_Bookmarks().UpdateBookmarkForVideo(currentItem, saveBookmark)
        end if
    end if
end sub

sub Video_OnCurrentItemChanged(mediaView as Object, content as Object)
    currentItem = mediaView.currentItem
    if currentItem <> invalid and not currentItem.tricksAllowed 
        mediaView.enableTrickPlay = false
    end if
end sub
