' ********** Copyright 2020 Roku Corp. All Rights Reserved. **********

function ShowSlideShowScreen(contentList as Object, selectedItem as Object, loop = true as Object) as Object
    controller = GetBaseViewController("SlideShowView")
    controller.Append({
        contentList: contentList
        selectedItem: selectedItem
        scene: m.top

        SetUpScreen: SlideShowScreen_SetUpScreen
        CleanUp: SlideShowScreen_CleanUp
        ConvertContent: SlideShowScreen_ConvertContent
        OnContentChanged : SlideShowScreen_OnContentChanged
    })
    controller.Observe(controller.view, "content", "OnContentChanged")

    controller.SetUpScreen(loop)
    ShowNewView(controller.view)
    return controller
end function

sub SlideShowScreen_SetUpScreen(loop as Object)
    m.scene.buttonBar.visible = false

    ' have to do this in a Task because roAppManager can't be used in the render thread
    m.suppressScreensaver = CreateObject("roSGNode", "SuppressScreensaver")
    m.suppressScreensaver.control = "RUN"

    content = CreateObject("roSGNode", "ContentNode")
    'Execution timeout if try to open slide show view with very big images collection
    'need to update content in the task thread
    config = {
        HandlerConfigSlideShow: {
            name: "SlideShowScreenCH"
            fields: {
                contentList: m.contentList.clone(true)
                selectedItem: m.selectedItem
            }
        }
    }
    content.Update(config, true)
    if loop = false
        m.view.loop = false
        m.view.closeAfterLastSlide = true
    end if
    ' save original content to be able to restore it after shuffle
    m.view.Update({
        contentListOriginal: m.contentList
    }, true)
    m.view.slideDuration = GetDisplayPeriods()[GetSlideshowSpeed()]
    m.view.textOverlayVisible = GetSShowInfoSettings()
    m.view.isContentList = true
    m.view.content = content
    m.view.control = "play"
end sub

sub SlideShowScreen_OnContentChanged(slideShow as Object, content as Object)
    if content = invalid or content.failedLoading = true
        ' no content available, close the view and return
        slideShow.close = true
        return
    end if

    if content.hasField("jumpToItem")
        slideShow.jumpToItem = content.jumpToItem
        content.removeField("jumpToItem")
    end if
end sub

' will be called when view was closed
sub SlideShowScreen_CleanUp()
    m.suppressScreensaver.control = "STOP"
    m.contentList = invalid
    m.initIndex = invalid
    m.scene = invalid
end sub

sub SlideShowScreen_ConvertContent()
    for each child in m.contentList.GetChildren(-1, 0)
        ' channel uses some smaller posters on grid
        ' so we need to reset real poster url to hdPosterUrl field
        child.hdPosterUrl = child.url
    end for
end sub

sub ShowSlideShowSettings(view as Object)
    controller = {
        slideShowView: view
        dialog: CreateObject("roSGNode", "Dialog")
        buttonsIDs: []
        displayPeriodIndex: GetSlideshowSpeed()
        shuffle: GetSShowShuffleSettings()
        info: GetSShowInfoSettings()
        displayPeriods: GetDisplayPeriods()
        displayPeriodTexts: [tr("Speed (fast)"),tr("Speed (medium)"),tr("Speed (slow)")]
        trShuffleOn: tr("Shuffle (on)")
        trShuffleOff: tr("Shuffle (off)")
        trPhInfoOn: tr("Photo info (on)")
        trPhInfoOff: tr("Photo info (off)")
        trClose: tr("Close")

        SetUpDialog: SlideShowSettings_SetUpDialog
        OnButtonSelected: SlideShowSettings_OnButtonSelected
        OnDialogClosed: SlideShowSettings_OnDialogClosed
    }
    RSGCallback_RegisterNodeCallback(controller.dialog, "buttonSelected", controller, "OnButtonSelected")
    RSGCallback_RegisterNodeCallback(controller.dialog, "wasClosed", controller, "OnDialogClosed")

    controller.SetUpDialog()
    m.top.dialog = controller.dialog
end sub

sub SlideShowSettings_SetUpDialog()
    buttons = []
    title = Tr("Slideshow Options")
    m.buttonsIDs = []

    ' slide duration btn
    buttons.Push(m.displayPeriodTexts[m.displayPeriodIndex])
    m.buttonsIDs.Push("slide_duration")
    ' shuffle btn
    if m.shuffle
        buttons.Push(m.trShuffleOn)
    else
        buttons.Push(m.trShuffleOff)
    end if
    m.buttonsIDs.Push("shuffle")
    ' poster info btn
    if m.info
        buttons.Push(m.trPhInfoOn)
    else
        buttons.Push(m.trPhInfoOff)
    end if
    m.buttonsIDs.Push("info")
    ' close btn
    if not ispro()
        buttons.Push(m.trClose)
    endif
    m.buttonsIDs.Push("close")

    m.dialog.optionsDialog = true
    m.dialog.title = title
    m.dialog.buttons = buttons
end sub

sub SlideShowSettings_OnButtonSelected(dialog as Object, itemSelected as Integer)
    buttonId = m.buttonsIDs[itemSelected]
    if buttonId = "slide_duration"
        m.displayPeriodIndex = m.displayPeriodIndex - 1
        if m.displayPeriodIndex < 0 then
            m.displayPeriodIndex = 2
        end if
        m.slideShowView.slideDuration = GetDisplayPeriods()[m.displayPeriodIndex]
        SetSlideshowSpeed(m.displayPeriodIndex)
    else if buttonId = "shuffle" and m.slideShowView.content <> invalid
        m.shuffle = not m.shuffle
        SetSShowShuffleSettings(m.shuffle)
        currItem = m.slideShowView.content.GetChild(m.slideShowView.currentIndex)
        config = {
            HandlerConfigSlideShow: {
                name: "SlideShowScreenCH"
                fields: {
                    contentList: m.slideShowView.contentListOriginal.clone(true)
                    selectedItem: currItem
                }
            }
        }
        content = CreateObject("roSGNode", "ContentNode")
        content.Update(config, true)
        m.slideShowView.content = content
    else if buttonId = "info"
        m.info = not m.info
        m.slideShowView.textOverlayVisible = m.info
        SetSShowInfoSettings(m.info)
    else if buttonId = "close"
        dialog.close = true
        return
    end if
    ' update buttons and remain focus on dialog
    m.SetUpDialog()
    dialog.SetFocus(true)
end sub

sub SlideShowSettings_OnDialogClosed(dialog as Object, wasClosed as Object)
    RSGCallback_RemoveNodeCallback(dialog, "buttonSelected")
    RSGCallback_RemoveNodeCallback(dialog, "wasClosed")
    m.slideShowView = invalid
end sub

function GetDisplayPeriods() as Object
    return [3,5,10]
end function
