' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

sub ShowSettings()
    controller = {
        dialog: CreateObject("roSGNode", "Dialog")
        displayFormats: [tr("Grid"), tr("List")]
        currServerUSN: ""
        buttonsIDs: []
        scene: m.top

        SetUpDialog: SettingsDialog_SetUpDialog
        Show: SettingsDialog_Show
        GetWebArtButton: SettingsDialog_GetWebArtButton
        GetAutorunButton: SettingsDialog_GetAutorunButton
        GetMTSettingsButton: SettingsDialog_GetMTSettingsButton
        GetDisplayFormatButton: SettingsDialog_GetDisplayFormatButton
        OnButtonSelected: SettingsDialog_OnButtonSelected
        OnDialogClosed: SettingsDialog_OnDialogClosed
    }
    RSGCallback_RegisterNodeCallback(controller.dialog, "buttonSelected", controller, "OnButtonSelected")
    RSGCallback_RegisterNodeCallback(controller.dialog, "wasClosed", controller, "OnDialogClosed")

    controller.SetUpDialog()

    m.top.dialog = controller.dialog
end sub

sub SettingsDialog_SetUpDialog()
    allow_legacy_option = 0
    appInfo = CreateObject("roAppInfo")
    allow_legacy_option_str = appInfo.GetValue("allow_legacy_option")
    if allow_legacy_option_str <> invalid AND allow_legacy_option_str <> ""
        allow_legacy_option_str = allow_legacy_option_str.trim()
        allow_legacy_option = allow_legacy_option_str.toInt()
    end if
    buttons = []
    title = Tr("Help & Settings")
    m.buttonsIDs = []

    buttons.Push(Tr("Help"))
    m.buttonsIDs.Push("help")

    currView = GetCurrentView()
    focusedItem = GetGridItem(currView.content, currView.rowItemFocused)
    if focusedItem <> invalid and focusedItem.accessType <> invalid
        buttons.Push(Tr("Volume Info"))
        m.buttonsIDs.Push("volume_info")

        if focusedItem.accessType = DLNAAccessType()
            isFav = focusedItem.USN = GetDLNAFavorite()
            if isFav
                buttons.Push(Tr("Clear Favorite DLNA server"))
                m.buttonsIDs.Push("clear_dlna_fav")
            else
                m.currServerUSN = focusedItem.USN
                buttons.Push(Tr("Set Favorite DLNA server"))
                m.buttonsIDs.Push("set_dlna_fav")
            end if
        end if
    end if

    buttons.Push(m.GetMTSettingsButton())
    m.buttonsIDs.Push("req_mt")
    if hasUSB() and useDLNA()
        buttons.Push(m.GetWebArtButton())
        m.buttonsIDs.Push("web_art")
    end if
    buttons.Push(m.GetDisplayFormatButton())
    m.buttonsIDs.Push("display_format")
    if not isromonly()
        buttons.Push(m.GetAutorunButton())
        m.buttonsIDs.Push("autorun")
    end if
    if allow_legacy_option = 1
        buttons.Push(Tr("Switch to Original Version"))
        m.buttonsIDs.Push("switch")
    endif
    buttons.Push(Tr("OK"))
    m.buttonsIDs.Push("close")

    m.dialog.optionsDialog = true
    m.dialog.title = title
    m.dialog.buttons = buttons
end sub

sub SettingsDialog_Show()
    m.scene.dialog = m.dialog
end sub

function SettingsDialog_GetWebArtButton() as String
    btnTitle = tr("Lookup album art on Web")
    if useNWM()
        return btnTitle + " - [" + tr("On") + "]"
    else
        return btnTitle + " - [" + tr("Off") + "]"
    end if
end function

function SettingsDialog_GetAutorunButton()
    btnTitle = tr("Autorun")
    if GetAutorunDisabled()
        return btnTitle + " - [" + tr("Off") + "]"
    else
        return btnTitle + " - [" + tr("On") + "]"
    end if
end function

function SettingsDialog_GetMTSettingsButton() as String
    btnTitle = tr("Request media type at startup")
    if GetMTSelectionScreenDisabled()
        return btnTitle + " - [" + tr("Off") + "]"
    else
        return btnTitle + " - [" + tr("On") + "]"
    end if
end function

function SettingsDialog_GetDisplayFormatButton() as String
    btnTitle = tr("Display format")
    displayFormat = GetContentDisplayFormatSetting()
    ' in legacy app there was 3 display formats in RSG version only 2
    ' so need to check if we do use new indexing
    if displayFormat > ListFormatID() then displayFormat = ListFormatID()
    if m.displayFormats.Count() > displayFormat
        return btnTitle + " - [" + m.displayFormats[displayFormat] + "]"
    else
        return btnTitle + " - [Grid]"
    end if
end function

sub SettingsDialog_OnButtonSelected(dialog as Object, itemSelected as Integer)
    buttonId = m.buttonsIDs[itemSelected]
    if buttonId = "help"
        ShowHelpScreen()
        dialog.close = true
        return
    else if buttonId = "volume_info"
        ShowVolumeInfo()
        dialog.close = true
        return
    else if buttonId = "web_art"
        SetAlbumArtFromWebDisabled(useNWM())
        Config().AddSet("useNWM", not useNWM())
    else if buttonId = "autorun"
        SetAutorunDisabled(not GetAutorunDisabled())
    else if buttonId = "req_mt"
        SetMTSelectionScreenDisabled(not GetMTSelectionScreenDisabled())
    else if buttonId = "display_format"
        newFormatID = GetContentDisplayFormatSetting() + 1
        if newFormatID > ListFormatID()
            newFormatID = 0
        end if
        SetContentDisplayFormatSetting(newFormatID)
    else if buttonId = "set_dlna_fav"
        SaveDLNAFavorite(m.currServerUSN)
    else if buttonId = "clear_dlna_fav"
        SaveDLNAFavorite("")
    else if buttonId = "switch"
        LaunchLegacyChannel()
    else if buttonId = "close"
        dialog.close = true
        return
    end if
    ' update buttons and remain focus on dialog
    m.SetUpDialog()
    dialog.SetFocus(true)
end sub

sub SettingsDialog_OnDialogClosed(dialog as Object, wasClosed as Object)
    RSGCallback_RemoveNodeCallback(dialog, "buttonSelected")
    RSGCallback_RemoveNodeCallback(dialog, "wasClosed")
end sub

function LaunchLegacyChannel() as void
    legacyLauncher = CreateObject("roSGNode", "LegacyLauncher")
    legacyLauncher.channelID = "2213"  'TODO: Change this to the correct private legacy channel ID
    legacyLauncher.control = "RUN"
end function

'================================================
'Helper functions for work with dialogs
'================================================
function ShowInformationDialog(description as String) as Object
    dialog = CreateObject("roSGNode", "Dialog")
    dialog.title = "Information"
    dialog.message = description
    dialog.buttons = [Tr("Close")]
    m.top.dialog = dialog
    return dialog
end function

sub DialogCallback_CloseViewOnCloseButton(dialog as Object, buttonSelected as Integer)
    'confirm that this is close button
    if dialog.buttons[buttonSelected] = Tr("Close")
        RSGCallback_RemoveNodeCallback(dialog, "buttonSelected")
        RSGCallback_RemoveNodeCallback(dialog, "wasClosed")
        dialog.close = true
        if m.view <> invalid then m.view.close = true
    end if
end sub

sub DialogCallback_CloseViewOnBackButton(dialog as Object, wasClosed as Object)
    'wasClosed works in strange way and this callback will be called
    'each time dialog actually gone but wasClosed will have value true
    'only if dialog was closed explicitly through dialog.close
    'check if it is not the case and close view
    if dialog.close = false
        RSGCallback_RemoveNodeCallback(dialog, "buttonSelected")
        RSGCallback_RemoveNodeCallback(dialog, "wasClosed")
        dialog.close = true
        if m.view <> invalid then m.view.close = true
    end if
end sub
