' ********** Copyright 2020 Roku Corp. All Rights Reserved. **********

sub ShowOptions()
    isListFormat = (getContentDisplayFormatSetting() = ListFormatID())
    mType = getMTFilter()
    if mType = allMediaId()
        gridFilterMode = [tr("Default"), tr("Short"), tr("Long")]
    else
        gridFilterMode = [tr("Short"), tr("Long")]
    end if
    controller = {
        dialog: CreateObject("roSGNode", "Dialog")
        filters: GetMediaTypeFilters()
        sorts: [tr("Default"), tr("A->Z"), tr("Z->A")]
        buttonsIDs: []
        gridFilterMode: gridFilterMode
        isListFormat: isListFormat
        scene: m.top
        needToRefresh: false

        SetUpDialog: OptionsDialog_SetUpDialog
        Show: OptionsDialog_Show
        CanSearch : OptionsDialog_CanSearch
        GetGridDisplayMode: OptionsDialog_GetGridDisplayMode
        GetMediaTypeButton: OptionsDialog_GetMediaTypeButton
        GetSortingButton: OptionsDialog_GetSortingButton
        OnButtonSelected: OptionsDialog_OnButtonSelected
        OnDialogClosed: OptionsDialog_OnDialogClosed
        OnSearchCapabilitiesChanged: OptionsDialog_GetSearchCapabilities
    }
    RSGCallback_RegisterNodeCallback(controller.dialog, "buttonSelected", controller, "OnButtonSelected")
    RSGCallback_RegisterNodeCallback(controller.dialog, "wasClosed", controller, "OnDialogClosed")

    'Check searchCapabilities
    volume = GetGlobalAA().lastMediaServer
    httpVolume = volume <> invalid and volume.accesstype = HTTPAccessType()
    if volume.fs.searchKeys <> invalid or httpVolume
        controller.SetUpDialog()
        controller.Show()
    else
        service = GetServiceByServer(volume)
        RSGCallback_RegisterNodeCallback(service, "searchCapabilities", controller,"OnSearchCapabilitiesChanged")
        service.getSearchCapabilities = {
            mediaServer: volume
        }
    end if
end sub

sub OptionsDialog_SetUpDialog()
    buttons = []
    ' "Options" title should be different for USB only version of RMP
    if isUSBOnly() = true
        title = Tr("Options")
    else
        title = Tr("Search & Options")
    end if
    m.buttonsIDs = []

    if m.canSearch()
        buttons.Push(Tr("Search"))
        m.buttonsIDs.Push("search")
    end if
 
    buttons.Push(m.GetMediaTypeButton())
    m.buttonsIDs.Push("media_type")
    buttons.Push(m.GetSortingButton())
    m.buttonsIDs.Push("sort")
    if not m.isListFormat
        buttons.Push(Tr(m.GetGridDisplayMode()))
        m.buttonsIDs.Push("display_format")
    end if
    buttons.Push(Tr("OK"))
    m.buttonsIDs.Push("close")

    m.dialog.optionsDialog = true
    m.dialog.title = title
    m.dialog.buttons = buttons
end sub

sub OptionsDialog_Show()
    m.origFilter = getMTFilter()
    m.origSort = getSorting()
    m.origGridRowsStyle = GetGridRowsStyle()
    m.scene.dialog = m.dialog
end sub

function OptionsDialog_GetMediaTypeButton()
    btnTitle = tr("Media type")
    return btnTitle + " - [" + m.filters[getMTFilter()] + "]"
end function

function OptionsDialog_GetSortingButton()
    btnTitle = tr("Sort")
    return btnTitle + " - [" + m.sorts[getSorting()] + "]"
end function

function OptionsDialog_GetGridDisplayMode()
    style = GetGridRowsStyle()
    btnTitle = tr("Row Style")
    mType = getMTFilter()
    if mType = allMediaId()
        btnTitle += " - [" + m.gridFilterMode[style] + "]"
    else
        ' default row style available only without media filters
        if style = DefaultGridRowsStyleID() then style = ShortGridRowsStyleID()
        btnTitle += " - [" + m.gridFilterMode[style-1] + "]"
    end if
    return btnTitle
end function

sub OptionsDialog_OnButtonSelected(dialog as Object, itemSelected as Integer)
    buttonId = m.buttonsIDs[itemSelected]
    if buttonId = "search"
        dialog.close = true
        ShowSearchScreen()
        return
    else if buttonId = "media_type"
        oldFilter = getMTFilter()
        newFilter = oldFilter + 1
        if newFilter > MaxFilterID() then newFilter = 0
        m.needToRefresh = (m.origFilter <> newFilter)
        if newFilter = allMediaId()
            m.gridFilterMode = [tr("Default"), tr("Short"), tr("Long")]
        else
            m.gridFilterMode = [tr("Short"), tr("Long")]
        end if
        setMTFilter(newFilter)
    else if buttonId = "sort"
        oldSort = getSorting()
        newSort = oldSort + 1
        if newSort >= m.sorts.Count() then newSort = 0
        m.needToRefresh = (m.origSort <> newSort)
        setSorting(newSort)
    else if buttonId = "display_format"
        oldStyle = GetGridRowsStyle()
        newStyle = oldStyle + 1
        if getMTFilter() = allMediaId()
            if (newStyle > LongGridRowsStyleID()) then newStyle = 0
        else
            ' swtich from default to short rows first time
            ' but default row style available only without media filters
            ' need to bump up newStyle
            if (newStyle = ShortGridRowsStyleID()) then newStyle++
            if (newStyle > LongGridRowsStyleID()) then newStyle = 1
        end if
        m.needToRefresh = (m.origGridRowsStyle <> newStyle)
        SetGridRowsStyle(newStyle)
    else if buttonId = "close"
        dialog.close = true
        return
    end if
    m.SetUpDialog()
    dialog.SetFocus(true)
end sub

sub OptionsDialog_OnDialogClosed(dialog as Object, wasClosed as Object)
    if m.needToRefresh
        if not m.isListFormat
            curContentItem = invalid
            curItemFocused = GetCurrentView().rowItemFocused
            content = GetCurrentView().content
            if content <> invalid
                if curItemFocused <> invalid and content.GetChildCount() > 0 
                    curContentItem = GetCurrentView().content.GetChild(curItemFocused[0]).GetChild(curItemFocused[1])
                end if
            end if
        end if
        
        ' simulate re-opening of this screen to update it
        GetCurrentView().close = true
        prevView = GetCurrentView()
        prevView.rowItemSelected = prevView.rowItemSelected
        
        if not m.isListFormat and curContentItem <> invalid
            content = GetCurrentView().content
            if content <> invalid
                content.Update({
                    lastFocusedId: curContentItem.objectId
                },true)
                GetCurrentView().ObserveFieldScoped("content", "OnContentSet")
            end if
        end if
    end if
    RSGCallback_RemoveNodeCallback(dialog, "buttonSelected")
    RSGCallback_RemoveNodeCallback(dialog, "wasClosed")
end sub

sub OnContentSet(data as Object)
    content = data.GetData()
    currentView = data.GetRoSGNode()
    if content.HasField("failedloading")
        lastFocusedId = content.lastFocusedId
        res = ObjectLocationInGrid(lastFocusedId, content)
        if res <> invalid
            currentView.jumpToRowItem = res
        end if
        content.removeField("lastFocusedId")
        currentView.UnObserveFieldScoped("content")
    end if
end sub

sub ShowVideoDetailsDialog()
    controller = {
        dialog: CreateObject("roSGNode", "Dialog")
        scene: m.top
        currView: GetCurrentView()

        SetUpDialog: VideoDetailsDialog_SetUpDialog
        Show: VideoDetailsDialog_Show
        GetRepeatButton: VideoDetailsDialog_GetRepeatButton
        GetShuffleButton: VideoDetailsDialog_GetShuffleButton
        GetPlaylistModeButton: VideoDetailsDialog_GetPlaylistModeButton
        OnButtonSelected: VideoDetailsDialog_OnButtonSelected
        OnDialogClosed: VideoDetailsDialog_OnDialogClosed
    }
    RSGCallback_RegisterNodeCallback(controller.dialog, "buttonSelected", controller, "OnButtonSelected")
    RSGCallback_RegisterNodeCallback(controller.dialog, "wasClosed", controller, "OnDialogClosed")

    controller.SetUpDialog()
    controller.Show()
end sub

sub VideoDetailsDialog_SetUpDialog()
    buttons = []
    title = Tr("Video Options")
    buttons.Push(m.GetShuffleButton())
    buttons.Push(m.GetRepeatButton())
    buttons.Push(m.GetPlaylistModeButton())
    buttons.Push(Tr("OK"))
    m.dialog.optionsDialog = true
    m.dialog.title = title
    m.dialog.buttons = buttons
end sub

sub VideoDetailsDialog_Show()
    m.scene.dialog = m.dialog
end sub

function VideoDetailsDialog_GetShuffleButton()
    btnTitle = tr("Shuffle")
    if GetVideoShuffleSettings()
        btnTitle += " - [" + tr("On") + "]"
    else
        btnTitle += " - [" + tr("Off") + "]"
    end if
    return btnTitle
end function

function VideoDetailsDialog_GetRepeatButton()
    btnTitle = tr("Repeat all")
    if GetVideoRepeatSettings()
        btnTitle += " - [" + tr("On") + "]"
    else
        btnTitle += " - [" + tr("Off") + "]"
    end if
    return btnTitle
end function

function VideoDetailsDialog_GetPlaylistModeButton()
    btnTitle = tr("Playlist mode")
    if GetVideoPlaylistModeSettings()
        btnTitle += " - [" + tr("On") + "]"
    else
        btnTitle += " - [" + tr("Off") + "]"
    end if
    return btnTitle
end function

sub VideoDetailsDialog_OnButtonSelected(dialog as Object, itemSelected as Integer)
    if itemSelected = 0
        SetVideoShuffleSettings(not GetVideoShuffleSettings())
        if m.currView.HasField("shuffle")
            m.currView.shuffle = GetVideoShuffleSettings()
        end if
    else if itemSelected = 1
        SetVideoRepeatSettings(not GetVideoRepeatSettings())
    else if itemSelected = 2
        SetVideoPlaylistModeSettings(not GetVideoPlaylistModeSettings())
    else
        dialog.close = true
        return
    end if
    m.SetUpDialog()
    dialog.SetFocus(true)
end sub

sub VideoDetailsDialog_OnDialogClosed(dialog as Object, wasClosed as Object)
    RSGCallback_RemoveNodeCallback(dialog, "buttonSelected")
    RSGCallback_RemoveNodeCallback(dialog, "wasClosed")
end sub

function OptionsDialog_CanSearch()
    volume = GetGlobalAA().lastMediaServer
    if volume.fs.searchKeys <> invalid
        return volume.fs.searchKeys.count() > 0
    end if
    return false
end function

sub OptionsDialog_GetSearchCapabilities(service as Object, SearchCapabilities as String)
    searchKeys = Search_GetSearchKeys(SearchCapabilities)
    volume = GetGlobalAA().lastMediaServer
    currFS = volume.fs
    currFS.searchKeys = searchKeys
    volume.fs = currFS
    m.SetUpDialog()
    m.Show()
end sub
