' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

sub ShowHomeScreen()
    controller = GetBaseViewController("GridView")
    controller.Append({
        homeDirMediaTypeNames: GetMediaTypeFilters()
        overhangOptionStr: Tr("Help & Settings")

        SetUpScreen: HomeScreen_SetUpScreen
        GetContent: HomeScreen_GetContent
        GetFilterContent: HomeScreen_GetFilterContent
        CreateDir: HomeScreen_CreateDir
        GetHelpItem: HomeScreen_GetHelpItem
        GetSettingsItem: HomeScreen_GetSettingsItem
        ' observers
        OnItemSelected: HomeScreen_OnItemSelected
    })
    controller.Observe(controller.view, "rowItemSelected", "OnItemSelected")

    controller.SetUpScreen()
    ShowNewView(controller.view)
end sub

sub HomeScreen_SetUpScreen()
    m.view.id = "mtscreen"
    m.view.content = m.GetContent()
    m.view.style = "rmp"
    m.view.posterShape = "square"
    m.view.theme = {
        ' OverhangShowOptions: false ' no options on the media selection screen
        OverhangOptionsText: m.overhangOptionStr
        itemTextBackgroundColor: invalid
        shortDescriptionLine1Align: "center"
    }
    m.SetOverhangTitle(Tr("Media Type Selection"))
end sub

function HomeScreen_GetContent()
    filters = m.GetFilterContent()
    ' filters.Push(m.GetSettingsItem())
    ' filters.Push(m.GetHelpItem())
    row = {
        title: Tr("Media Type Selection")
        children: filters
    }
    content = CreateObject("roSGNode", "ContentNode")
    content.Update({
        children: [row]
    }, true)
    return content
end function

function HomeScreen_GetFilterContent() as Object
    i% = videoID()
    if AllMediaFilterEnabled()
        i% = 0
    end if
    files = []
    while i% <= MaxFilterID()
        item = m.CreateDir(m.homeDirMediaTypeNames[i%], i%)
        files.push(item)
        i% = i% +1
    end while
    return files
end function

function HomeScreen_CreateDir(name as String, mType as Integer) as Object
    item = {}

    if mType = videoID() 'video
        item.HDPosterUrl = GetLocalizedImage("poster_video_fhd.png")
        item.FHDPosterUrl = GetLocalizedImage("poster_video_fhd.png")
    else if mType = audioID() 'music
        item.HDPosterUrl = GetLocalizedImage("poster_audio_fhd.png")
        item.FHDPosterUrl = GetLocalizedImage("poster_audio_fhd.png")
    else if mType = pictureID() 'photo
        item.HDPosterUrl = GetLocalizedImage("poster_image_fhd.png")
        item.FHDPosterUrl = GetLocalizedImage("poster_image_fhd.png")
    else ' All - generic
        item.HDPosterUrl = GetLocalizedImage("poster_folder_fhd.png")
        item.FHDPosterUrl = GetLocalizedImage("poster_folder_fhd.png")
    end if
    item.shortDescriptionLine1 = name
    item.isMedia = 0
    item.mType = mType
    item.usn = ""

    return item
end function

function HomeScreen_GetHelpItem()
    if useDLNA()
        line2 = tr("Learn how to use Roku Media Player")
    else
        line2 = tr("Learn how to use USB Media Player")
    end if
    ' tack on a help icon
    return {
'         shortDescriptionLine1:  tr("Help")
'         shortDescriptionLine2:  line2
        hdPosterURL: GetLocalizedImage("USBMediaPlayer_FlatCategory_Help_HD.png")
        sdPosterURL: GetLocalizedImage("USBMediaPlayer_FlatCategory_Help_SD43.png")
        title: tr("Help")
        description:  line2
        usn: "USN-HELP"
        provider: { location : "Help" }
    }
end function

function HomeScreen_GetSettingsItem()
    return {
'         shortDescriptionLine1:  tr("Settings")
        hdPosterURL: GetLocalizedImage("Settings_HD.png")
        sdPosterURL: GetLocalizedImage("Settings_SD43.png")
        title: tr("Settings")
        usn: "USN-SETTINGS"
        provider: { location : "Settings" }
    }
end function

sub HomeScreen_OnItemSelected(gridView as Object, rowItemSelected as Object)
    selectedItem = GetGridItem(gridView.content, rowItemSelected)
    if selectedItem <> invalid
        if selectedItem.usn = "" and selectedItem.mType <> invalid
            if selectedItem.mType <> allMediaId() and GetGridRowsStyle() = DefaultGridRowsStyleID()
                ' default row style available only without media filters
                SetGridRowsStyle(ShortGridRowsStyleID())
            end if
            setMTFilter(selectedItem.mType)
            Config().UpdateLocal()
            ShowVolumeSelectionScreen()
        end if
    end if
end sub
