' ********** Copyright 2020 Roku Corp. All Rights Reserved. **********

sub ShowHelpScreen(section = "" as String)
    controller = GetBaseViewController("ParagraphView")
    controller.Append({
        scene: m.top
        sections: [
            "connect_media_server"
            "browse_media"
            "search_media"
            "play_media"
            "supported_files"
            "playlists"
            "playing_w_dts"
        ]

        SetUpScreen: HelpScreen_SetUpScreen
        CleanUp: HelpScreen_CleanUp
        CloseScreen: HelpScreen_CloseScreen
        GetViewContent: HelpScreen_GetViewContent
        GetContentBySection: HelpScreen_GetContentBySection
        ' observers
        OnBBItemFocused: HelpScreen_OnBBItemFocused
        OnBBItemSelected: HelpScreen_OnBBItemSelected
        OnVolumeChanged: HelpScreen_OnVolumeChanged
    })
    ' search_media should not appears in USB only version of RMP
    if isUSBOnly() = true
        controller.sections.Delete(2)
    end if
    controller.Observe(controller.scene.buttonBar, "itemFocused", "OnBBItemFocused")
    controller.Observe(controller.scene.buttonBar, "itemSelected", "OnBBItemSelected")

    controller.SetUpScreen(section)
    ShowNewView(controller.view)
    controller.scene.buttonBar.SetFocus(true)
end sub

sub HelpScreen_SetUpScreen(setupSection as String)
    if setupSection = ""
        m.scene.buttonBar.visible = true
        m.scene.buttonBar.enableFootprint = true
        m.scene.buttonBar.footprintStyle = "focus"
        m.scene.buttonBar.alignment = "left"

        buttonBarContent = CreateObject("roSGNode", "ContentNode")
        for each section in m.sections
            item = buttonBarContent.CreateChild("ContentNode")
            item.Update(m.GetContentBySection(section), true)
        end for
        m.scene.buttonBar.content = buttonBarContent
    else
        ' we should know when new servers/devices is available if help screen section is "connect_media_server"
        if setupSection = "connect_media_server"
            m.Observe(m.scene.httpfs, "activeVolumes", "OnVolumeChanged")
            m.Observe(m.scene.usb, "volumesChanged", "OnVolumeChanged")
            m.Observe(m.scene.dlna, "volumesChanged", "OnVolumeChanged")
        end if
        contentAA = m.GetContentBySection(setupSection)
        m.view.content = m.GetViewContent(contentAA.title, contentAA.text)
    end if
    m.view.theme = {
        OverhangShowOptions: false
        ' OverhangOptionsText: ""
    }
    m.SetOverhangTitle(Tr("Help"))
end sub

sub HelpScreen_CleanUp()
    m.scene.buttonBar.visible = false
    m.scene = invalid
end sub

sub HelpScreen_CloseScreen()
    m.view.close = true
end sub

sub HelpScreen_OnBBItemFocused(buttonBar as Object, itemFocused as Integer)
    focusedButton = buttonBar.content.GetChild(itemFocused)
    if focusedButton <> invalid
        m.view.content = m.GetViewContent(focusedButton.title, focusedButton.text)
    end if
end sub

sub HelpScreen_OnBBItemSelected(buttonBar as Object, itemSelected as Integer)
    currView = GetCurrentView()
    if currView <> invalid
        ' set focus on the view when user selects button
        currView.SetFocus(true)
    end if
end sub

function HelpScreen_GetViewContent(title as String, text as String) as Object
    viewContent = CreateObject("roSGNode", "ContentNode")
    viewContent.Update({
        children: [{
            paragraphType: "header"
            text: title
        },{
            text: text
        }]
    }, true)
    return viewContent
end function

function HelpScreen_GetContentBySection(section as String)
    dashStr = " – "
    if useDLNA()
        appName = tr("Roku Media Player")
        if hasUSB()
            sourceText = tr("Media Server or USB device")
        else
            sourceText = tr("Media Server")
        endif
    else
        appName = tr("USB Media Player")
        sourceText = tr("USB device")
    endif
    playerName = tr("ID_PLAYER_NAME")

    if section = "connect_media_server"
        text2 = ""
        if useDLNA()
            text = tr("To play or view content from a network Media Server, first make sure your Media Server is online.")
            if hasUSB()
                title = tr("Connecting to a DLNA Media Server or USB Device")
                text = text + Chr(10) + chr(10)
            else
                title = tr("Connecting to a DLNA Media Server")
            endif
        else
            title = tr("Connecting to a USB device")
            text = ""
        endif
        if hasUSB()
            if hasExt3()
                driveFormats = "FAT16/32, NTFS, HFS+, EXT2/3"
            else
                driveFormats = "FAT16/32, NTFS, HFS+"
            endif
            text1 = Substitute(tr("To play or view content from a USB storage device, connect your device to the USB port on your {0}."),playerName)
            text = text + text1 + Chr(10) + tr("Drive formats supported") + dashStr + driveFormats
        endif
    else if section = "browse_media"
        title = tr("Browsing Media")
        text1 = tr("To view or play a file, first select a Media Type from the main screen.")
        text2 = Substitute(tr(" You can then browse your {0} for supported files."), sourceText)
        text4 = Substitute(tr("{0} hides files that it knows are not playable."), appName)
        text5 = tr("Press * to change filter and sorting options. The current filter appears at the top right.")
        text6 = tr("Select Settings to change the row length, or change to a list for browsing.")
        text = text1 + text2 + Chr(10) + text4 + Chr(10) + text5 + chr(10) + text6
    else if section = "search_media"
        title = tr("Searching Media")
        if hasUSB()
            text = tr("To search your USB or DLNA server, press * on the remote and select Search.")
        else
            text = tr("To search your DLNA server, press * on the remote and select Search.")
        endif
        text = text + Chr(10) + tr("(Some DLNA servers do not support search).")
        if hasUSB()
            text = text + Chr(10) + CHR(10) + tr("To improve your USB search speed, highlight the USB icon, press * on the remote, and select Scan. The scan can take several minutes.")
            if hasSDCARDhardware()
                text = text + " " + tr("The results are stored in RAM and in the micro SD card.")
            else
                text = text + " " + tr("The results are stored in RAM.")
            endif
        endif
    else if section = "play_media"
        title = tr("Playing Media")
        text = tr("Press OK on a media file to play or view that file. Press PLAY on a folder or playlist to play the contents.")
        text = text + Chr(10) + tr("While viewing photos, press LEFT or RIGHT to go to the next or previous photo. Press PLAY while viewing a photo to begin an automated slideshow.")
    else if section = "supported_files"
        if maxGifSize() = 2048
            maxPic = "2kx2k"
        else if maxGifSize() >= 4096
            maxPic = "4kx4k"
        endif
        ' photoFormats
        photoFormats = tr("Photo") + dashStr + "JPEG, PNG(" + maxPic +"), " + tr("non-animated") + " GIF(" + maxPic +")"
        if hasUSB()
            photoFormats = photoFormats + CHR(10) + tr("On USB, files named folder.jpg or folder.png are ignored and used as folder icons.")
        endif
        ' audioFormats
        audioFormats = tr("Audio") + dashStr
        if hasAAC()
            if hasAAC51()
                audioFormats = audioFormats + "AAC(5.1),"
            else
                audioFormats = audioFormats + "AAC,"
            endif
            ' not going to add (stereo), cause we'd need to add that to the other codecs as well
        endif
        if hasflac()
            audioFormats = audioFormats + " MP3, WMA, WAV(PCM), AIFF, FLAC"
        else
            audioFormats = audioFormats + " MP3, WMA"
        endif
        if hasOgg()
            ' start another line
            audioFormats = audioFormats + CHR(10) + tr("Audio") + dashStr + "OGG"
        endif
        if hasAC3()
            audioFormats = audioFormats + ", AC3"
        endif
        if ispro()
            if hasMat()
                audioFormats = audioFormats + ", MAT"
            endif
            if hasAC4()
                audioFormats = audioFormats + ", AC4"
            endif
            if hasDTS()
                audioFormats = audioFormats + ", DTS"
            endif
        endif
        ' videoFormats
        H = "H.264"
        if hasMPEG2()
            H = H + "/262"
        endif
        if hasH265()
            H = H + "/265HEVC"
        endif
        videoFormats = tr("Video") + "(" + h +")" + dashStr + "MKV, MOV, MP4"
        if ispro()
            videoformats = videoformats + ", TS"
        endif
        if hasFLV()
    '        videoFormats =  videoFormats + ", FLV"
        endif
        if hasASF()
    '        videoFormats =  videoFormats + ", ASF"
        endif

        if hasVP9()
            videoFormats = videoFormats + chr(10) + tr("Video") + "(" + "VP9" + ")" + dashStr + "MKV"
        endif

        if hasWMV()
            videoFormats = videoFormats + chr(10) + tr("Video") + "(" + "WMV" + ")" + dashStr + "WMV"
        endif
        title = tr("Supported Files")
        text = tr("The following media formats are supported:") + Chr(10) + videoFormats + Chr(10) + audioFormats + Chr(10) + photoFormats
    else if section = "playlists"
        title = tr("Playlists")
        plssort = tr("The default sorting order in a .m3u playlist is in the order they appear in the playlist.")
        autorun = tr("Autorun.m3u at the top level of a USB drive will be autoplayed. This can be disabled in the Settings screen.")
        text = tr("Playlists are supported in the .m3u and .pls format.") + " " + plssort + Chr(10)
        if not isromonly()
            text = text + Chr(10) + autorun
        endif
    else if section = "playing_w_dts"
        if hasNativeAC3()
            title = tr("Playing Video with DTS Audio")
        else
            title = tr("Playing Video with Dolby Digital or DTS")
        endif

        ddtext = tr("Dolby Digital is supported via passthrough on MKV, MP4 and MOV files.")
        dtstext = tr("DTS is supported via passthrough on MKV.")
        if hasspdif()
            ' roku tv, dallas, cooper 1
            ' assume s/pdif - rokutv for now
            if hasnativeAC3()
                dtstext = dtstext + " " + Substitute(tr("Connect your {0} via HDMI or S/PDIF to a device capable of decoding DTS in order to hear movies with audio tracks encoded in that format."), playerName)
            else
                dtstext = ddtext + " " + dtstext + " " + Substitute(tr("Connect your {0} via HDMI or S/PDIF to a device capable of decoding Dolby Digital or DTS in order to hear movies with audio tracks encoded in those formats."), playerName)
            endif
        else
            if hasnativeAC3()
                dtstext = dtstext + " " + Substitute(tr("Connect your {0} via HDMI to a device capable of decoding DTS in order to hear movies with audio tracks encoded in that format."), playerName)
            else
                dtstext = ddtext + " " + dtstext + " " + Substitute(tr("Connect your {0} via HDMI to a device capable of decoding Dolby Digital or DTS in order to hear movies with audio tracks encoded in those formats."), playerName)
            endif
        endif

        text = dtstext + Chr(10) + Chr(10) + tr("For more help, go to support.roku.com.") + CHr(10) + getRMPVersion(appName)
    end if

    return {
        HDItemWidth: 350.0
        title: title
        text: text
    }
end function

function getRMPVersion(appName as String) as String
    manifest = Util_GetManifest()
    return appName + " Version " + manifest["major_version"] + "." + manifest["minor_version"] + "." + manifest["build_version"]
end function

sub HelpScreen_OnVolumeChanged(service as Object, data as Dynamic)
    m.CloseScreen()
    ShowVolumeSelectionScreen()
end sub