' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

sub ShowContentScreen(objId as String, mediaServer as Object, previousVolume as Object)
    'save current media server to scene scope
    m.lastMediaServer = mediaServer
    isListFormat = (getContentDisplayFormatSetting() = ListFormatID())
    if isListFormat
        viewName = "CategoryListView"
    else
        viewName = "GridView"
    end if
    controller = GetBaseViewController(viewName)
    controller.Append({
        objId: objId
        activeMediaServer: mediaServer
        previousVolume: previousVolume
        isList: isListFormat
        overhangOptionStr: Tr("Search & Options")
        scene: m.top.GetScene()

        SetUpScreen: ContentScreen_SetUpScreen
        CleanUp: ContentScreen_CleanUp
        ShowNoContenDialog: ContentScreen_ShowNoContenDialog
        GetNoContentMsg: ContentScreen_GetNoContentMsg
        ' observers
        OnItemSelected: ContentScreen_OnItemSelected
        OnContentLoaded: ContentScreen_OnContentLoaded
        OnDetailsWasClosed: ContentScreen_OnDetailsWasClosed
        HandleDialogCloseButton: DialogCallback_CloseViewOnCloseButton
        HandleDialogCloseEvent: DialogCallback_CloseViewOnBackButton
    })
    if isUSBOnly() = true
        controller.overhangOptionStr = Tr("Options")
    end if
    if isListFormat
        controller.Observe(controller.view, "selectedItem", "OnItemSelected")
        controller.view.ffrwPageSize = 6
    else
        controller.Observe(controller.view, "rowItemSelected", "OnItemSelected")
    end if
    controller.Observe(controller.view, "content", "OnContentLoaded")

    controller.SetUpScreen()
    ShowNewView(controller.view)
end sub

sub ContentScreen_SetUpScreen()
    service = GetServiceByServer(m.activeMediaServer)

    if service <> invalid
        content = CreateObject("roSGNode", "ContentNode")
        if m.isList
            m.view.style = "rmp"
            m.view.posterShape = "square"
            configName = "handlerConfigCategoryList"
        else
            m.view.wrap = true
            configName = "handlerConfigGrid"
        end if
        config = {}
        config[configName] = {
            name: "ContentScreenCH"
            fields: {
                mediaServerAA: m.activeMediaServer.GetFields()
                objID: m.objId
                service: service
            }
        }
        content.Update(config, true)
        m.view.content = content
        m.view.id = "ContentScreen_" + m.objId

        StartLoadingDirectory(service, m.activeMediaServer, m.objID)

        m.view.theme = {
            OverhangOptionsText: m.overhangOptionStr
            categoryFocusedColor: "0x000000"
            focusRingColor: "0xffffff"
        }
        m.SetOverhangTitle(m.activeMediaServer.title)
    end if
end sub

' will be called when view was closed
sub ContentScreen_CleanUp()
    m.objId = invalid
    m.activeMediaServer = invalid
    m.previousVolume = invalid
    m.scene = invalid
end sub

sub StartLoadingDirectory(service as Object, mediaServer, objID as String, searchStr = "" as String)
    ' make sure that previous result is cleared
    service.returnDirectoryListing = invalid
    'start loading content from UI thread to avoid rendevouz
    'CH will just wait for service response and parse it
    service.getDirectoryListing = {
        mediaServer: mediaServer
        objID: objID
        searchStr: searchStr
    }
end sub

sub ContentScreen_ShowNoContenDialog()
    dialogMsg = m.GetNoContentMsg()
    dialog = ShowInformationDialog(dialogMsg)
    RSGCallback_RegisterNodeCallback(dialog, "buttonSelected", m, "HandleDialogCloseButton")
    RSGCallback_RegisterNodeCallback(dialog, "wasClosed", m, "HandleDialogCloseEvent")
end sub

function ContentScreen_GetNoContentMsg()
    mType = getMTFilter()
    if mType = allMediaId() ' All - generic
        messageToShow = tr("No compatible media found in:")
    else if mType = videoID() 'video
        messageToShow = tr("No compatible videos found in:")
    else if mType = audioID() 'music
        messageToShow = tr("No compatible audio found in:")
    else if mType = pictureID() 'photo
        messageToShow = tr("No compatible photos found in:")
    end if
    messageToShow = messageToShow + WinNL() + m.previousVolume.title
    'TODO: implement swithcing of media type from error dialog
    ' if mType <> allMediaId() then
    '     messageToShow = messageToShow + WinNL() + tr("Press * to change filters")
    ' end if
    return messageToShow
end function

sub ContentScreen_OnItemSelected(view as Object, rowItemSelected as Object)
    selectedItem = GetGridItem(view.content, rowItemSelected)
    if selectedItem <> invalid
        if selectedItem.type = dirID()
            ShowContentScreen(selectedItem.objectID, m.activeMediaServer, selectedItem.Clone(false))
        else ' selected media item
            if selectedItem.type = videoID()
                ShowVideoDetail(view.content, selectedItem)
            else if selectedItem.type = audioID()
                selectedItem.playStart = ReadAudioBookmark(selectedItem)
                ShowAudioPlayerScreen(view.content, selectedItem)
            else if selectedItem.type = pictureID()
                ShowSlideShowScreen(view.content, selectedItem)
            end if
        end if
    end if
end sub

sub ContentScreen_OnContentLoaded(gridView as Object, content as Object)
    if content <> invalid
        if content.failedLoading = true
            'handle empty folder/volume appearing
            m.ShowNoContenDialog()
        else if content.failedLoading = false and content.GetChildCount() > 0
            if not m.isList
                rowAspectRatio = []
                for each row in content.GetChildren(-1, 0)
                    if row.type = dirID() or row.type = audioID()
                        rowAspectRatio.Push("square")
                    else
                        rowAspectRatio.Push("16x9")
                    end if
                end for
                m.view.rowPosterShapes = rowAspectRatio
            end if
            ' autorun logic
            if (not AutorunDisabled()) and (m.activeMediaServer.fs.AutoRun = true)
                if m.previousVolume <> invalid and lcase(m.previousVolume.title) = "autorun.m3u"
                    ' autorun playlist opened automaticly
                    ' we should start playing first item
                    newFS = {}
                    newFS.Append(m.activeMediaServer.fs)
                    newFS.AutoRun = false
                    ' autoruns only once
                    m.activeMediaServer.fs = newFS
                    m.scene.usb.clearAutoRun = true
                    ' start playback
                    firstItem = GetGridItem(content, [0,0])
                    if firstItem <> invalid
                        if firstItem.type = videoID()
                            ShowVideoScreen(content, firstItem)
                        else if firstItem.type = audioID()
                            ShowAudioPlayerScreen(content, firstItem)
                        end if
                    end if
                    return
                end if
                print "looking for autorun.m3u on ";m.activeMediaServer.usn
                for each row in content.GetChildren(-1, 0)
                    if row.type = dirID()
                        for each item in row.GetChildren(-1, 0)
                            if lcase(item.title) = "autorun.m3u"
                                ShowContentScreen(item.objectID, m.activeMediaServer, item.Clone(false))
                                exit for
                            end if
                        end for
                    end if
                end for
            end if
        else if content.failedLoading = false and content.GetChildCount() = 0
            'content loaded but there is no items
            'means that filter is enabled and this folder has no appropriate items
            m.ShowNoContenDialog()
        end if
    end if
end sub

sub ContentScreen_OnDetailsWasClosed(detailView as Object, wasClosed as Boolean)
    RSGCallback_RemoveNodeCallback(detailView, "wasClosed")
    if wasClosed
        ' jump to last playing item
        m.view.jumpToRowItem = [m.view.rowItemSelected[0], detailView.itemFocused]
    end if
end sub
