' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

function usb_createFS(volume)
    this = create_generic_FS(volume)
    this.GetDirectoryListing = usb_GetDirectoryListing
    this.GetSearchCapabilities = usb_GetSearchCapabilities
    this.Exists = usb_Exists   ' override generic
    this.Cancel = usb_Cancel
    this.CacheExists = usbCacheExists
    this.ClearCache = usbClearCache
    this.ScanCache = usbScanCache
    this.PutToCache = usb_PutToCache
    this.GetUSBCachePath = usb_GetUSBCachePath
    this.GetMountTime = usb_GetMountTime
    this.AutoRun = true
    ' let us store reference to a componentController to reduece rendezvous
    gthis = GetGlobalAA()
    this.componentController = gthis.top.GetScene().componentController
    this.UpdateProgress = service_UpdateProgress
    this.GetProgressLabel = service_GetProgressLabel
    if isromonly() and m.audioonly=false
        ' told to disable this feature for unconnected mode
        this.AutoRun = false
    endif
    return this
end function

function usbFileExists(filename)
    if usb_Exists(filename)
        return filename
    endif
    return invalid
end function

function usbUUID(vinfo) as string
    ret = ""
    if vinfo.uuid <> invalid and vinfo.uuid <> ""
        ret = vinfo.uuid
    endif
    ret = ret + ":" + vinfo.blocks.tostr() + ":" + vinfo.freeblocks.tostr() + ":" + vinfo.usedblocks.tostr()
    return ret
end function

sub dumpCacheFS(usb)
    cachefspath = usb.cachefspath + "/"
    print "dumpCacheFS cachefspath=";cachefspath
    cfiles = usb.rofs.getdirectorylisting(cachefspath)
    print cfiles
end sub

' cache first line format
' A = regular cache, F = fullcache from scan
' NNN = version
' :
' UUID or LABEL
' :
' free/used/total blocks
'
'F000;3A24BF4024BEFDC7:7574543:6181235:1393308;7574543/6181235/1393308

function CacheGenre(cache,genre)
    if not cache.doesexist(genre)
        cache[genre] = genre
    end if
end function

' if ingest = false, returns true if fullcache exists
function usbCacheExists(ingest) as boolean
' ingest = read it in and process
    usb = usbptr()
    dumpCacheFS(usb)
    ret = false
    cachePath = usbFileExists(m.GetUSBCachePath())
    if cachePath <> invalid
        print "usb cache file exists, check if good for this volume:",cachePath
        cachebytes = createobject("robytearray")
        if cachebytes.readfile(cachePath)
            print "readfile res: true, bytes=";cachebytes.count()
            str = cachebytes.toasciistring()
            lines = str.split(winNL())
            l = lines[0]
            firstchar = l.left(1)
            isFull = (firstchar="F")
            m.hasFullCache = isFull
            ' check if device is freshly mounted
            origMountTime = l.split("_")[1]
            newMountTime = ""
            if IsInt(m.volumeInfo.mountTime) then newMountTime = m.volumeInfo.mountTime.ToStr()
            m.isMountTimeChanged = (origMountTime <> newMountTime)
            if isFull or (firstchar="A")
                if ingest
                    ret = true

                    m.itemcache = RMPtoAA(str)
                    ' print m.itemcache
                    ' printaa(m.itemcache)

                    m.metaCaches = newMetaCache()
                    if not isUSBOnly()
                        genreCache = m.metaCaches.genre
                        artistCache = m.metaCaches.artist
                        albumCache = m.metaCaches.album
                        for each i in m.itemcache
                            v = m.itemcache[i]
                            if v.genre <> invalid
                                CacheGenre(genreCache, v.genre)
                            endif
                            if v.artist <> invalid
                                artistCache[v.artist] = v.artist
                            endif
                            if v.album <> invalid
                                albumCache[v.album] = v.album
                            endif
                        next
                    endif
                    cachebytes = invalid
                    str = invalid
                    ' validate cached artwork still exists
                    m.ItemCacheCount = m.itemcache.count()
                    print "Read in ";m.ItemCacheCount;" items from cache file"
                    ' validate ptrs in cache.
                    ' if mount point changes need to alter some ptrs - TODO
                    for each k in m.itemcache
                        item = m.itemcache[k]
                        s = item.hdposterurl
                        if s <> invalid
                            s = s.left(3)
                            if (s = "tmp")
                                ' items in tmp are never there, should not even write these out maybe
                                print "artwork not cached - force reload:";k;" artwork=";item.hdposterurl
                                m.itemcache.delete(k)
                            else if (s = "cac") ' persistent cache
                                if not usb.rofs.exists(item.hdposterurl)
                                    print "artwork not cached - force reload:";k;" artwork=";item.hdposterurl
                                    m.itemcache.delete(k)
                                else
                                    print "artwork cached - keep:";k;" artwork=";item.hdposterurl
                                endif
                            endif
                        endif
                    next
                    if m.ItemCacheCount <> m.itemcache.count()
                        print "Deleted " ; m.ItemCacheCount - m.itemcache.count() ; " items from cache"
                        m.ItemCacheCount = -1   ' force a write out since we modified cache
                    endif
                else ' not ingest
                    ret = isFull
                endif  ' ingest
            else
                print "cache file, unknown version"
                ' unknown version
            endif
        endif
        if not ret
            ' if ingesting and cache doesn't match. clear the cache contents before starting
            if ingest
                m.clearcache()
            endif
        endif
    endif
    print "usbCacheExists returns:";ret
    return ret
end function

function newMetaCache()
    mc = {}
    mc.genre = {}
    mc.artist = {}
    mc.album = {}
    return mc
end function

function usbClearCache()
    usb = usbptr()
    m.itemcache = invalid
    m.metaCaches = newMetaCache()
    m.hasfullcache = false
    cfiles = usb.rofs.FindRecurse(usb.cachefspath + "/", "")
    for each file in cfiles
        print "Deleting :";file
        usb.rofs.delete(usb.cachefspath + "/" + file)
    end for
    ' need to manually delete some files, since cachefs is broken for listing contents
    usb.rofs.delete(usb.cachefspath)
    usb.rofs.delete(usb.fullcachefspath)
    'delete hysterical directories on possibly broken cachefs
    usb.rofs.delete("cachefs:/albumart")
    usb.rofs.delete("cachefs:/albumroot")
    usb.rofs.delete("cachefs:/thumbs")
end function

function usbScanCache()
    ' if scanning, make sure we have a cleared cache
    m.clearCache()
    res = m.GetDirectoryListing(GetRootObjectID(), "roku:scan")
end function

function usb_ClearAutorunFlags()
    for each vol in m.volumes
        vol.fs.AutoRun = false
    next
end function

function usb_Cancel(objectID as string) as void
    print "usb_Cancel"
    m.cancelListRequest = true
    m.objectIDToCancel = objectID
    RMPPostEvent("usb",USBcancelID())
end function

function usb_Exists(path) as Boolean
    usb = usbptr()
    if usb.rofs.Exists(path)
        info = usb.rofs.Stat(path)
        if info.type = "file"
            return true
        endif
    endif
    return false
end function

function usb_GetSearchCapabilities() as string
    if isusbonly()
        ret = ""
    else
        ret = "roku:filename,roku:artist,roku:album,roku:title,roku:genre"
    endif
    print "usb_GetSearchCapabilities:";ret
    return ret
end function

function quote() as string
        return chr(34)
end function

function GetCoverArt(usb, item)
    'print "------------- GetCoverArt() ---------------------"
    art = usb.AudioMetaData.GetCoverArt()
    if art <> invalid and art.bytes <> invalid and art.bytes.Count() > 0
        image_ext=""
        if ((art.type = "image/jpeg") or (art.type = "jpg") or (art.type = "image/jpg")) then
            image_ext = "jpg"
        else if (art.type = "image/png" or art.type = "png") then
            image_ext = "png"
        else if (art.type = "image/gif" or art.type = "gif") then
            image_ext = "gif"
        else
            print "Unrecognized image type: " ; art.type
        end if

        if image_ext <> ""
            crc = art.bytes.getcrc32()
            filename = crc.tostr()

            tmpname = usb.albumartroot + "_" + filename

            ' Need to check to see if we already have this image
            if not usb.rofs.Exists(tmpname)
                print "Writing album art to:";tmpname
                art.bytes.Writefile(tmpname)
            else
                print "avoided dup of album art:";tmpname
            end if

            item.sdPosterURL = tmpname
            item.hdPosterURL = tmpname
        end if
    else
        if useNWM()
            info = invalid
            VSalbum = ValidStr(item.album)
            VSartist = ValidStr(item.artist)
            if VSalbum <> "" and VSartist <> ""
                info = m.lastFM.GetAlbumInfo(VSalbum, VSartist)
            else if VSartist <> ""
                info = m.lastFM.GetTrackInfo(ValidStr(item.description), VSartist)
            end if

            if info <> invalid
                t = ValidStr(info.albumArtURL)
                if t <> ""
                    item.hdPosterURL = t
                    item.fhdPosterURL = item.hdPosterURL
                end if
            end if
        end if
    end if
end function

function usbSystemFile(name as string) as boolean
    if name.left(1) = "$" return true
    if name = "System Volume Information" return true
    if name = "lost+found" return true
    return false
end function

' first pass at copy paste reduction
function usb_headerCompare(format as string, filepath as string) as boolean
    pngbytes = m.byteReader
    littleEndian = pngbytes.islittleendianCPU()
    if format = "mat"
        pngbytes.ReadFile(filepath, 0, 20)
'                               ' validate mat (Dolby MPL/TrueHD)
        if littleEndian
            if pngbytes.getsignedlong(0) = &H03009e07 and pngbytes.getsignedlong(1) = &H01010184
                if pngbytes.getsignedlong(2)=&Ha5560080 and pngbytes.getsignedlong(3)=&H8381f43b
                    if pngbytes.getsignedlong(4)=&He0778049
                        ' valid dolby mat header
                        return true
                    endif
                endif
            endif
        else ' not littleEndian
            if pngbytes.getsignedlong(0) = &H079e0003 and pngbytes.getsignedlong(1) = &H84010101
                if pngbytes.getsignedlong(2)=&H800056a5 and pngbytes.getsignedlong(3)= &H3bf48183
                    if pngbytes.getsignedlong(4)=&H498077e0
                        ' valid dolby mat header
                        return true
                    endif
                endif
            endif
        endif ' Endian
    else if format = "ac4"
        pngbytes.ReadFile(filepath, 0, 2)
'       ' validate ac4
        b0 = pngbytes.getsignedbyte(0)
        b1 = pngbytes.getsignedbyte(1)
'        print "AC4 comparison b0=";b0;" b1=";b1
        if b0=&HFFFFFFac
            if (b1=&H40) or (b1=&H41)
                return true
            endif
        endif
    endif
    return false
end function

function usb_GetDirectoryListing(objID as string, dlnasearchStr = "" ) as object
    m.cancelListRequest = false
    retValue = genericVol_defaultGetDirRetVal(objID)
    scanning = (dlnasearchStr.instr("roku:scan")=0)

    origObjID = objID
    usb = usbptr()

    ' low level usb result cache
    if m.itemcache = invalid
        m.itemcache = {}
        m.metaCaches = newMetaCache()
        m.hasFullCache = false          ' only true if full scan from root
        m.ItemCacheCount = 0
        if hasCacheFS()
            dumpCacheFS(usb)
            'if not scanning
                ' read it in
            m.CacheExists(true)
            'endif
        endif
    else
        m.ItemCacheCount = m.itemcache.count()
    endif

    genreCache = m.metaCaches.genre
    artistCache = m.metaCaches.artist
    albumCache = m.metaCaches.album

    print "Cached items=";m.ItemCacheCount

    lhasSizeEx = hasSizeEx()
    lVerbose = isVerbose()
    lhasISODate = hasISODate()
    lAutoDetect = hasAutoDetect()
    timer = CreateObject("roTimeSpan")
    watchtimer = CreateObject("roTimeSpan")
    print "usb_GetDirectoryListing(";objID;") search=";dlnasearchStr
    m.browseInProgress = true
    i = 0

    if objID = GetRootObjectID()
        objID = m.provider.location
    endif

    thumbMaxPixels = maxThumbPixels()
    gifMAXsize = maxGifSize()
    trackNum = 0   ' used for playlist to enforce order of playing

    isPlaylist = false

    if objID="?foobar?" ' magic playlist token
      isplaylist = true
    else
      playlistpath = CreateObject("roPath", objID)
      pathparts = playlistpath.Split()
      if pathparts.extension <> invalid
        extension = pathparts.extension.mid(1)
        if extension = "m3u" or extension = "m3u8" or extension = "pls"
            isPlaylist = true
        endif
      endif
    endif

    if objID.left(3) = "?0?"
        meta = objID.mid(3)     ' genre, artist, album
        ' create list of virtual folders
        cache = m.metaCaches[meta]
        dim files[cache.count()]
        for each g in cache
            item = {}
            item.title = g
            item.ShortDescriptionLine1 = g
            item.objectID = "?roku:" + Lcase(meta) + " contains " + quotestr(g)
            item.isMedia = dirID()
            item.isPlaylist = false
            item.isVFolder = true
            files.push(item)
        next
        retValue.files = files
        return retValue
    endif

    onlyCache = false   ' force use of cached itmes
    if objID.left(6) = "?roku:"
        ' virtual folder search
        dlnasearchStr = objID.mid(1)
        objID = m.provider.location
        onlyCache = true
    endif

    ' used for finding thumbnails for videos
    thumbs = {}
    vids = false

    'thumbroot = usb.cacheRoot + "/thumbs"
    thumbroot = "tmp:/thumbs"
    usb.rofs.createdirectory(thumbroot)
    thumbroot = thumbroot + "/" + httpencode(objID)
    usb.rofs.createdirectory(thumbroot)
    thumbroot = thumbroot + "/"
    thumbbatch = 0
    thumbcount = 0

    'usb.rofs.createdirectory(usb.albumartroot)

    if isPlaylist
        if objID="?foobar?"
            path = m.provider.location
            listing = getInternalPlaylist()
        else
            text = ReadAsciiFile( playlistpath )
            playlistData = processPlaylist(text, extension)
            listing = playlistData.files
            path = pathparts.parent
        endif
    else ' not playlist
      path = CreateObject("roPath", objID + "/")
      if dlnasearchStr = ""
          listing = usb.rofs.GetDirectoryListing(path)
      else
        ' create a search string and call file
        listing = CreateObject("roList")
        if (dlnasearchStr.instr("roku:filename contains ")>=0) or scanning
            regex = invalid
            if scanning
                regex = usb.allfilesregex
            else
              firstquote = dlnasearchStr.instr(20, quote())
              if firstquote>0
                secondquote=dlnasearchStr.instr(firstquote+1, quote())
                if secondquote>0
                    targetStr=dlnasearchStr.mid(firstquote+1,secondquote-firstquote-1)
                    regex = targetStr
                endif
              endif
            endif
            if regex <> invalid
                print "regex=";regex
                listing = usb.rofs.FindRecurse(path, regex)
            endif
        else  ' voice search
            ' get all files
            if not m.hasFullCache and not onlyCache
                listing = usb.rofs.FindRecurse(path, usb.allfilesregex)
            else
                listing = invalid
            endif
        endif
      endif 'dlnasearchstring
    endif 'isPlaylist
  if listing = invalid
     print "USING FULL CACHE BYPASS"
    totalmatches = m.itemcache.count()
    r = CreateObject("roRegex", usb.allfilesregex, "i")
    dim files[totalmatches]
    for each k in m.itemcache
        if r.IsMatch(k) = true
            files.push(m.itemcache[k])
        end if
    next
  else
    Config().UpdateLocal()
    pngbytes = CreateObject("roByteArray")
    littleEndian = pngbytes.islittleendianCPU()
    watchCount = 0
    totalmatches = listing.count()
    filesPerUpdate = int(maxUPNPRequest()*2)    ' 20 or 40
    if totalMatches >= filesPerUpdate*2
    endif

    dim files[totalmatches]
    if useNWM()
        'reset timeout status on entry to directory
        getlastFM().timedout = false
    end if
    print "For each c in listing sofar=";StrI(timer.TotalMilliseconds());" milliseconds"

    cacheAdditions = {}
    
    ' Save reference to a spinner until listing isn't finished to reduce rendezvous when updating progress           
    if m.componentController <> invalid
       currentView = m.componentController.currentView
       if currentView <> invalid
           m.spinner = currentView.FindNode("spinner")
       end if
    end if
    m.timespan = CreateObject("roTimespan")
    
    for each c in listing
        cString = c
        ' check if request was not canceled
        msg = usb.port.GetMessage()
        if msg <> invalid
            if type(msg) = "roSGNodeEvent" and msg.getField() = "cancel"
                m.cancelListRequest = true
                exit for
            end if
        end if
        ' playlist entries might be null, so weed them out here
        if c <> ""
            myishttp = false
            relPath = true

            if isPlaylist
                print "usb - process playlist entry:";c
                if ishttp(c)
                    ' plain subdirectories/playlists are not allowed inside a playlist
                    ' force type to file
                    ftype = "file"
                    myishttp = true
                else 'local file entry
                    ' check for absolute path (drive letter + : )
                    if mid(c,2,1) = ":"
                        relPath = false
                        c = c.right(c.len()-3) ' strip off the first three characters
                    endif
                endif
            else
            endif
            if not myishttp
                if relPath
                    cpath = CreateObject("roPath", path + "/" + c)
                else
                    cpath = CreateObject("roPath", m.provider.location + "/" + c)
                endif
                cString = "" + cpath   ' Convert path to string
            endif
            cacheKey = cstring
            colon = cachekey.instr(":")
            if colon >= 0
                ' remove the mount point
                cachekey=cachekey.mid(colon+1)
            endif

            item = m.itemcache[cachekey]
            if item = invalid
              if totalMatches < 1500
                print "usb - cache miss:";cachekey
              endif
              if not myishttp
                if lVerbose print "cpath=";cpath
                info = usb.rofs.Stat(cpath)
                ftype = info.type
                'printAA(info)
                'print "'";c;"' ";info.type
                if not isPlaylist   ' ignore hidden attributes if this part of a playlist
                  if (info.DoesExist("hidden") and info.hidden)
                    ' setting it to empty ftype will make it be ignored below
                    'print "File has HIDDEN attribute"
                    ftype = ""
                  else  ' if basename begins with a period, make it hidden
                    pathparts = cpath.split()
                    ' bug in roPath, split doesn't work if it has a "?" in it, although that is a legal filename character
                    ' print "basename=";pathparts.basename;"   extension=";pathparts.extension
                    if (pathparts.basename = invalid) or (pathparts.basename.left(1) = ".")
                        ftype = ""
                    else
                        if dlnasearchStr <> ""
                            ' restore base filename
                            c = pathparts.basename
                        endif
                    endif
                  endif
                endif

              endif

              if ftype="directory"
                ' filter system files
                if not usbSystemFile(c)
                    item = {}
                    item.title = c
                    item.ShortDescriptionLine1 = c
                    item.objectID = cString
                    item.isMedia = dirID()
                    item.isPlaylist = false
                    item.isVFolder = false
                    cacheAdditions[cachekey] = item
                    files.push(item)
                endif
            else if ftype = "file"
                if lhasSizeEx
                    fsize = createobject("rolonginteger")
                    fsize.setlongint(-1)
                else
                    fsize = createobject("roint")
                    fsize.setint(-1)
                endif
                if myishttp
                    ' in a playlist and prefix is http
                    extension = ""
                    ' cpath only works for filesystem
                    extension = c.right(4)
                    dotI = extension.instr(".")
                    if dotI >= 0
                        extension = extension.right(3-dotI)
                    else
                        if lAutoDetect
                            extension = "autodetect"
                        else
                            extension = "mp3"       ' for .m3u playlists, if no extension default to mp3 playback
                        endif
                    endif
                    dotI = c.instr("://")
                    basename = c.right(len(c)-dotI-3)
                    filename = c
                else
                    pathparts = cpath.Split()
                    if lVerbose print pathparts
                    extension = pathparts.extension.mid(1)
                    basename = pathparts.basename
                    filename = pathparts.filename
                    if lhasSizeEx
                        fsize.setlongint(info.sizeex)
                    else
                        fsize.setint(info.size)                        
                    endif
                endif
                if (extension = "") and isplaylist and lAutoDetect
                    print "no extension, using autodetect for";basename
                    extension = "autodetect"
                endif
                if extension <> ""
                    mimetype = usb.mimetypes["x_" + extension]
                    if mimetype = invalid and lAutoDetect and isplaylist
                        basename = basename + "." + extension
                        print "Using autodetect for";basename
                        mimetype = usb.mimetypes["x_autodetect"]
                    endif
                    if mimetype <> invalid
                      if myishttp
                        ' switch back to original path specification
                        cpath = c
                      endif
                      if (mimetype.type = 0)   ' playlist
                        if isplaylist
                          ' we are already inside a playlist, this is a video
                          mimetype.type = 1
                        else
                          print "process potential playlist file:";cpath
                          text = ReadAsciiFile( cpath )
                          'print "text=";text
                          if extension="m3u8" and text.left(7) = "#EXTM3U"
                              mimetype.type = 1
                          else
                              print c;" - regular playlist - create a folder entry"
                              item = {}
                              id = cString
                              item.title = c   ' goes in BOB
                              item.ShortDescriptionLine1 = basename   ' used by grid poster
                              item.objectID = id
                              item.isMedia = dirID()
                              item.isPlaylist = true
                              item.isVfolder= false
                              files.push(item)
                          endif
                        endif
                      endif
                      if mimetype.type <> 0
                        item = {}
                        item.title = basename
                        item.ShortDescriptionLine1 = c
                        item.objectID = cString
                        item.isMedia = mimetype.type
                        item.format = mimetype.format
                        item.formatname = mimetype.name
                        item.url = cString
                        item.islive = false
                        item.ishttp = myishttp
                        item.size = fsize
                        if isPlaylist
                            trackNum = trackNum + 1
                            item.track = trackNum
                            t = playlistdata.titles[i]
                            if t <> invalid
                                item.title = t
                            endif
                            t = playlistdata.lengths[i]
                            if t <> invalid
                                if t <> "0"
                                    item.duration = strtoI(t)
                                endif
                            endif
                        endif

                        itemok = true

                        debugformat = cString
                        if mimetype.type = 1' video
                            'item.description = item.title
                            vids = true
                    if ispro() and item.format = "mp4"
                    ' attempt to extract meta data
                    ' some mp4 files can contain id3 tag coverart.
                    ' still experimental - only for pro version
                            usb.AudioMetaData.SetUrl(cpath)
                            tags = usb.AudioMetaData.GetTags()
                            if tags <> invalid
                                printAA(tags)
                                if ValidStr(tags.title) <> ""
                                    item.title = ValidStr(tags.title)
                                    item.description = c
                                end if

                                z = ValidStr(tags.artist)
                                if z <> ""
                                    item.artist = z
                                else
                                    item.artist = "Unknown"
                                endif
                                stop
                                if tags.year > 0
                                    item.ReleaseDate = StrI(tags.year).Trim()
                                end if
                            endif
                            'properties = usb.AudioMetaData.GetAudioProperties()
                            'print "Propertieis"
                            'printAA(properties)
                            GetCoverArt(usb, item)
    endif


                        else if mimetype.type = 2' audio
                         if mimetype.format = "mat" or mimetype.format = "ac4"
                             if not usb.headerCompare(mimetype.format, cpath)
                                 itemok = false
                             endif
                         endif   'mat
                         if itemok
                           if not myishttp
                            usb.AudioMetaData.SetUrl(cpath)
                            tags = usb.AudioMetaData.GetTags()
                            if tags <> invalid
                                'printAA(tags)
                                if ValidStr(tags.title) <> ""
                                    item.title = ValidStr(tags.title)
                                    item.description = c
                                end if

                                z = ValidStr(tags.artist)
                                if z <> ""
                                    item.artist = z
                                else
                                    item.artist = "Unknown"
                                endif

                                z = ValidStr(tags.album)
                                if z <> ""
                                    item.album = z
                                end if

                                z = ValidStr(tags.genre)
                                if z <> ""
                                    item.genre = z
                                else
                                    item.genre = "Unknown"
                                endif
                                if not isUSBOnly()
                                    CacheGenre(genreCache, item.genre)
                                    z = item.artist
                                    if not artistCache.doesexist(z)
                                        artistCache[z] = z
                                    end if
                                    z = item.album
                                    if z <> invalid
                                        if albumCache[z] = invalid
                                            albumCache[z] = z
                                        endif
                                    endif
                                endif

                                if tags.year > 0
                                    item.ReleaseDate = StrI(tags.year).Trim()
                                end if
                                if tags.track>0 and (not isplaylist)
                                    item.track = tags.track
                                    'print "Track=";item.track
                                end if
                            end if
                            'print "------------- GetAudioProperties() --------------"
                            properties = usb.AudioMetaData.GetAudioProperties()
                            if lverbose printAA(properties)
                            if properties <> invalid
                                if properties.length <> invalid
                                    item.duration = properties.length
                                endif
                                if properties.bitrate <> invalid
                                    item.bitrate = properties.bitrate
                                endif
                            end if
                                ' if all the songs have the same coverart, we will create multiple copies
                            GetCoverArt(usb, item)
                          else
                              ' split url address for info
                              tokens = basename.tokenize("/")
                              newbasename = tokens[tokens.count()-1]
                              item.album = basename.left(len(basename) - 1 - len(newbasename))
                              item.title = newbasename
                              item.description = c
                          endif ' not myishttp
                         endif ' itemok
                        else if mimetype.type = 3 ' picture
              item.dateTimeSort = 0
                          if mimetype.format="jpg"
                            usb.ImageMetaData.SetUrl(item.url)
                            'print "------------- GetRawExif() ----------------------"
                            'allexif = usb.ImageMetaData.GetRawExif()
                            'if true printAA(allexif)
                            'print "------------- GetMetadata() ---------------------"
                            simple = usb.ImageMetaData.GetMetadata()
                            if lVerbose printAA(simple)
                            if lhasISODate and simple.datetime = invalid ' try to find it under a different tag
                                otherDateTime = usb.ImageMetaData.GetRawExifTag(0, 306) ' image.datetime
                                if otherDateTime <> invalid
                                    dt = otherDateTime.value
                                    if dt <> invalid and dt.instr(":") = 4
                                        if lVerbose print "Found image.date:";dt
                                        dt = dt.left(4) + "/" + dt.mid(5,2) + "/" +  dt.mid(8,2) + dt.mid(10)
                                        simple.datetime = createobject("rodatetime")
                                        simple.datetime.fromISO8601String(dt)
                                    endif
                                endif
                            endif
                            if simple.datetime <> invalid
                if lhasISODate 'hasISOdate - 6.2 and later
                    dt = simple.datetime.ToISOString()
                    ' remove Z
                    dotPos=dt.instr("Z")
                    if dotPos >= 0
                    dt = dt.left(dotPos)
                    endif
                    ' replace T with space
                    dt = dt.replace("T"," ")
                else
                    dt = simple.datetime.AsDateString("short-month-no-weekday")
                endif
                                item.dateTimeSort = simple.datetime.asSeconds()
                item.TextOverlayUL = dt
                            end if
                            if (simple.width = invalid) or (simple.height = invalid)
                                itemok = false
                            else
                                if (simple.width > 0) and (simple.height>0)
                                    item.width = simple.width
                                    item.height = simple.height
                                else
                                    itemok = false
                                    print "jpg to small (";simple.width;"x";simple.height;") ";item.url
                                endif
                            endif

                            if itemok
                                'print "------------- GetRawExifTag() -------------------"
                                'rawexiftag = meta.GetRawExifTag(2,36868)
                                'if lVerbose printAA(rawexiftag)
                                'print "------------- GetThumbnail() --------------------"
                                art = usb.ImageMetaData.GetThumbnail()

                                if art <> invalid and art.bytes <> invalid and art.bytes.Count() > 0
                                    image_ext=""
                                    if (art.type = "image/jpeg" or art.type = "jpg" or art.type = "jpeg") then
                                       image_ext = "jpg"
                                    else if (art.type = "image/png" or art.type = "png") then
                                       image_ext = "png"
                                    else
                                        print "Unrecognized image type: " ; art.type
                                    end if
                                    if image_ext <> ""
                                        if thumbcount = 0
                                            thumbdir = thumbroot + thumbbatch.tostr()
                                            usb.rofs.createdirectory(thumbdir)
                                            thumbdir = thumbdir + "/"
                                        endif
                                        item.sdPosterURL = thumbdir + HttpEncode(filename) + "." + image_ext
                                        art.bytes.Writefile(item.sdPosterURL)
                                        item.hdPosterURL = item.sdPosterURL
                                        thumbcount = thumbcount + 1
                                        if thumbcount > 40
                                            thumbcount =  0
                                            thumbbatch = thumbbatch + 1
                                        endif
                                    end if
                                end if
                                thumbs.addreplace(item.title,cpath)
                                if mimetype.name = "thm"
                                    ' do not include .thm files as photos
                                    itemok = false
                                endif
                            endif
                          else if mimetype.format = "png"
                              pngbytes.ReadFile(item.url, 0, 8 + 4 + 4 + 7 + 4)
'                             ' validate pngheader and get width/height
                              if littleEndian
                                  if pngbytes.getsignedlong(0) = &H474e5089 and pngbytes.getsignedlong(1) = &H0a1a0a0d
                                    if pngbytes.getsignedlong(2)=&H0d000000 and pngbytes.getsignedlong(3)=&H52444849
                                        item.width = pngbytes[19]+256*(pngbytes[18]+256*(pngbytes[17]+256*pngbytes[16]))
                                        item.height = pngbytes[19+4]+256*(pngbytes[18+4]+256*(pngbytes[17+4]+256*pngbytes[16+4]))
                                    endif
                                  endif
                              else ' not littleEndian
                                  if pngbytes.getsignedlong(0) = &H89504e47 and pngbytes.getsignedlong(1) = &H0d0a1a0a
                                    if pngbytes.getsignedlong(2)=&H0d and pngbytes.getsignedlong(3)= &H49484452
                                        item.width = pngbytes.getsignedlong(4)
                                        item.height = pngbytes.getsignedlong(5)
                                    endif
                                  endif
                              endif ' Endian
                              if item.width = invalid
                                  itemok = false
                                  print "invalid png:";item.url
                              else if (item.width<=0) or (item.height<=0)
                                  itemok = false
                                  print "png to small (";item.width;"x";item.height;") ";item.url
                              else if item.width * item.height > gifMAXsize
                                  itemok = false
                                  print "png to big (";item.width;"x";item.height;") ";item.url
                              endif
                              if itemok
                                  thumbs.addreplace(item.title,cpath)
                              endif
                          else if mimetype.format = "gif"
                              pngbytes.ReadFile(item.url, 0, 10)
                              p4 = pngbytes[4]
                              if littleEndian
                                  if pngbytes.getsignedlong(0) = &H38464947 and (p4=&H39 or p4=&H37) and pngbytes[5]=&H61
                                      item.width = pngbytes[7]*256+pngbytes[6]
                                      item.height= pngbytes[9]*256+pngbytes[8]
                                  else
                                      print "bad gif litend=1 0L=";pngbytes.getsignedlong(0);" 4=";pngbytes[4];" ";pngbytes[5];" ";pngbytes[6];" ";pngbytes[7]
                                  endif
                              else
                                  if pngbytes.getsignedlong(0) = &H47494638 and (p4=&H39 or p4=&H37) and pngbytes[5]=&H61
                                      item.width = pngbytes[6]*256+pngbytes[7]
                                      item.height= pngbytes[8]*256+pngbytes[9]
                                  else
                                      print "bad gif litend=0 0L=";pngbytes.getsignedlong(0);" 4=";pngbytes[4];" ";pngbytes[5];" ";pngbytes[6];" ";pngbytes[7]
                                  endif
                              endif
                              if item.width = invalid
                                    itemok = false
                                    print "invalid gif:";item.url
                              else if (item.width<=0) or (item.height<=0)
                                   print "gif to small (";item.width;"x";item.height;") ";item.url
                                   itemok = false
                              else if item.width * item.height > gifMAXsize
                                   itemok = false
                                   print "gif to big (";item.width;"x";item.height;") ";item.url
                              endif
                          endif 'mimetype.format gif

                          if itemok
                            if item.sdPosterURL = invalid
                              ' can we use the image itself?
                              if lVerbose
                                  print "width="; item.width;" height=";item.height
                              endif
                              if item.height * item.width <= thumbMaxPixels
                                  item.sdPosterURL = item.url
                                  item.hdPosterURL = item.url
                              endif
                              if lVerbose and item.sdPosterURL = invalid
                                      print "picture(";item.width;"x";item.height;") bad size as thumbnail"
                              endif
                            endif
                            dimension = "["+item.width.tostr()+"x"+item.height.tostr()+"]"
                            if item.TextOverlayUL = invalid
                                item.TextOverlayUL = dimension + " " + mimetype.name
                            else
                                item.TextOverlayUL = item.TextOverlayUL + " " + dimension + " " + mimetype.name
                            endif
                            item.description = item.shortDescriptionLine1
                            item.TextOverlayBody = item.shortDescriptionLine1
                          endif 'itemok
                          if isplaylist
                              item.datetimesort = invalid
                          endif
                        end if ' mimetype
                        if itemok
                            ' for debugging
                            if lVerbose
                              prefix = "(" + item.format + ")"
                              if item.description <> invalid
                                item.description = prefix + item.description
                              else
                                item.description = prefix
                              end if
                              item.debugformat = debugformat + prefix ' printed out in gridscreen with info button
                            endif
                            files.push(item)
                            cacheAdditions[cachekey] = item
                        end if  ' itemok
                      endif 'playlist test
                    else ' unknown extension
                        'print "usb: unknown file type1=";cpath
                    endif
                else ' no extension
                    'print "usb: unknown file type2=";cpath
                end if
              endif
            else  ' cached
              if totalMatches < 1500
                print "usb - cache hit:";cachekey
              endif
              files.push(item)
            end if
        end if ' c <> ""
        i = i + 1
        watchCount = watchCount + 1
        if (totalmatches >= 2*filesPerUpdate) and ((watchCount = filesPerUpdate) or (i = totalmatches))
            m.UpdateProgress(i/totalmatches)
            watchCount = 0
        endif
    end for
    m.spinner = invalid
    m.browseInProgress = false
    if m.cancelListRequest
        print "List request cancel"
        return "cancel"
    endif

    ' match thumbnail jpgs for video files
    if vids and not thumbs.isempty()
      for each f in files
        if f.ismedia = videoID()
            thumb = thumbs.lookup(f.title)
            if thumb <> invalid
                f.sdPosterURL = thumb.getstring()
                f.hdPosterURL = f.sdPosterURL
            endif
        endif
      end for
    endif

    toAppend = false
    if m.itemcache.count() = 0
        m.itemcache = cacheAdditions
    else
        toAppend = true
        m.itemcache.append(cacheAdditions)
    endif

    print "toAppend=";toAppend;" cache additions=";cacheAdditions.count()
    if hasCacheFS()
      nowHaveFullCache = scanning or (origObjID = GetRootObjectID()) and (dlnasearchStr <> "") and (dlnasearchStr.instr("roku:filename contains")<0)
      if nowHaveFullCache
          if not m.hasfullcache
              ' change from nonfull to full, need to rewrite entire cache
              cacheAdditions = m.itemcache
          endif
      endif
      if cacheAdditions.count() > 0
        print "Writing new usb cache out oldcount=";m.itemcachecount;" additions=";cacheAdditions.count()
        print "usb-loc:";m.provider.location
        dumpCacheFS(usb)

        toCache = CreateObject("roString")
        ' cache changed, save to fscache
        c = cacheAdditions
        for each k in c
            item = c[k]
            s = item.hdposterurl
            ' do not write out if tmp is used for poster art
            if (s=invalid) or (s.left(3) <> "tmp")
                q = k.escape() + "@" + AAtoRMP(item) + winNL()
                toCache.appendString(q,q.len())
            else
                print "Skipping ";k;"   hdposter=";s
            endif
        next

        if toCache.len() > 0
            m.PutToCache(toCache, nowHaveFullCache)
        else
            print "Nothing added to cache"
        endif

        toCache = invalid
      endif ' no additions
    endif   ' no cachefs
  endif ' read in ull cache bypass

    ' post processing
    print "Post Process dlnasearch=";dlnasearchStr
    if not isplaylist and dlnasearchStr <> ""
      artistKey = extractvalue("roku:artist", dlnasearchStr)
      albumKey = extractvalue("roku:album", dlnasearchStr)
      titleKey = extractvalue("roku:title", dlnasearchStr)
      genreKey = extractvalue("roku:genre", dlnasearchStr)
             ' go through metadata, looking for artist or album
      print "artist=";artistKey; " album=";albumKey; " title=";titleKey;" genre=";genreKey
      if (artistKey <> "") or (albumKey <> "") or (titleKey <> "") or (genreKey <> "")
        ' only do this if searching metadata, avoid wiping out search by filename
        searchres = []
        if artistKey <> ""
            for each f in files
                if f.artist <> invalid
                    l = LCase(f.artist)
                    if l.instr(artistKey) >= 0
                        searchres.push(f)
                    endif
                endif
            end for
        endif
        if albumKey <> ""
            for each f in files
                if f.album <> invalid
                    l = LCase(f.album)
                    if l.instr(albumKey) >= 0
                        searchres.push(f)
                    endif
                endif
            end for
        endif
        if titleKey <> ""
            for each f in files
                if f.title <> invalid
                    l = LCase(f.title)
                    if l.instr(titleKey) >= 0
                        searchres.push(f)
                    endif
                endif
            end for
        endif
        if genreKey <> ""
            for each f in files
                if f.genre <> invalid
                    l = LCase(f.genre)
                    if l.instr(genreKey) >= 0
                        searchres.push(f)
                    endif
                endif
            end for
        endif
        files = searchres
      endif
    endif

    print "returning ";files.count();" files in ";StrI(timer.TotalMilliseconds());" milliseconds"
    retValue.files = files
    return retValue
end function


sub usb_PutToCache(toCache as String, nowHaveFullCache as Boolean)
    bytes = createobject("robytearray")
    usb = usbptr()
    if not usb.rofs.exists(usb.cachefspath)
        ' create folder with cache files
        ' one cache file per usb
        usb.rofs.createdirectory(usb.cachefspath)
    else if usb.rofs.stat(usb.cachefspath).type = "file"
        ' previous verions of RMP cache only one device
        ' and cachefspath is file with that cache
        ' after RMP-235 each usb has separate file with it cache
        ' and those files stored in cachefspath directory
        usb.rofs.Delete(usb.cachefspath)
        usb.rofs.createdirectory(usb.cachefspath)
    end if
    ' was this a full cache read?
    if m.hasfullcache or nowHaveFullCache
        if m.hasfullcache
            bytes.fromasciistring(toCache)
            res = bytes.appendfile(m.GetUSBCachePath())
            print "full cache append bytescount=";bytes.count();" success=";res
        else
            ' create a new F000 file
            pfix = "F000;" + m.uuid + "_" + m.GetMountTime()
            print pfix
            bytes.fromasciistring(pfix + winNL() + toCache)
            res = bytes.writefile(m.GetUSBCachePath())
            print "full cache write bytescount=";bytes.count();" success=";res
            m.hasFullCache = true
        endif
    else ' not full
        if usb.rofs.exists(m.GetUSBCachePath())
            bytes.fromasciistring(toCache)
            res = bytes.appendfile(m.GetUSBCachePath())
            print "part-cache append bytescount=";bytes.count();" success=";res
        else
            pfix = "A000;" + m.uuid + "_" + m.GetMountTime()
            print pfix
            bytes.fromasciistring(pfix + winNL() + toCache)
            res = bytes.writefile(m.GetUSBCachePath())
            print "part-cache write bytescount=";bytes.count();" success=";res
        endif
    endif
    bytes = invalid
end sub

function usb_GetUSBCachePath() as String
    if m.currCachePath = invalid
        m.currCachePath = usbptr().cachefspath + "/" + m.uuid.Escape()
    end if

    return m.currCachePath
end function

function usb_GetMountTime() as String
    if m.volumeInfo <> invalid and IsInt(m.volumeInfo.mountTime)
        return m.volumeInfo.mountTime.ToStr()
    end if
    return ""
end function

function extractvalue(key as string, str as string) as string
    keyFound = str.instr(key + " contains ")
    if keyFound>=0
        firstquote = str.instr(keyFound+10+key.len(), quote())
        if firstquote>0
            secondquote=str.instr(firstquote+1, quote())
            if secondquote>0
                return LCase(str.mid(firstquote+1,secondquote-firstquote-1))
            endif
        endif
    endif
    return ""
end function

Function HttpEncode(str As String) As String
    return CreateObject("roURLTransfer").Escape(str)
End Function
