' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

function NewUPNPController(port as Object) as Object
    this = {
        task: m.top
        port: port
        requests: {}
        providerRequestID: invalid
        pendingRequests: []
        pendingRequestsCount: 0

        Init: UPNP_Init
        GetAudioMimetypes: UPNP_GetAudioMimetypes
        GetVideoMimetypes: UPNP_GetVideoMimetypes
        HandleEvent: UPNP_HandleEvent
    }
    ' let us store reference to a componentController to reduece rendezvous
    gthis = GetGlobalAA()
    this.componentController = gthis.top.GetScene().componentController
    this.UpdateProgress = service_UpdateProgress
    this.GetProgressLabel = service_GetProgressLabel
    this.Init()
    return this
end function

function get_upnp()
    return GetGlobalAA().upnpController
end function

sub UPNP_Init()
    m.audioMimetypes = m.GetAudioMimetypes()
    m.videoMimetypes = m.GetVideoMimetypes()

    m.update     = browse_update
    m.browse     = Browse
    'this.browseMeta = BrowseMetaData

    ' methods
    m.dumpProvider       = upnp_dumpProvider
    m.dumpRequest        = upnp_dumpRequest
    m.parse              = upnp_parse
    m.get                = upnp_get
    m.post               = upnp_post
    m.extract            = upnp_extract
    m.getProvider        = upnp_getProvider
    m.createUrlTransfer  = upnp_createUrlTransfer
end sub

function UPNP_GetAudioMimetypes() as Object
    mt = {
        mp3:        "mp3"
        mpeg:       "mp3"
        mp4:        "mp4"
    }
    mt.addreplace("x-ms-wma","wma")
    mt.addreplace("x-matroska","mka")
    ' ps3 media server uses audio/x-m4a
    mt.addreplace("x-m4a","mp4")
    mt.addreplace("3gpp","mp4")
    if hasPCM()
        mt.wav = "pcm"
        mt.addreplace("x-wav","pcm")
        mt.l16 = "pcm"
        mt.aiff = "pcm"
        mt.addreplace("x-aiff","pcm")
    end if
    if hasFlac()
        mt.flac = "flac"
        mt.addreplace("x-flac","flac")
    end if
    if hasOgg()   ' implies vorbis
        mt.ogg = "ogg"
        mt.addreplace("x-ogg","ogg")
        mt.addreplace("webm","mka")
    end if
    if hasAC3()
        mt.ac3 = "ac3"
        mt.addreplace("x-ac3","ac3")
        mt.addreplace("vnd.dolby.dd-raw","ac3")  ' plex
    end if
    if hasEAC3()
        mt.eac3 = "ac3"
        mt.addreplace("x-eac3","ac3")
    end if
    if hasAAC()
        mt.addreplace("vnd.dlna.adts","es.aac-adts")
        mt.aac = "es.aac-adts"
        mt.addreplace("x-aac","es.aac-adts")
    endif
    return mt
end function

function UPNP_GetVideoMimetypes() as Object
    mt = {
        mp4:        "mp4"
        quicktime:  "mp4"
        hls:        "hls"
    }
    mt.addreplace("x-matroska","mkv")
    if hasVP9()
        mt.addreplace("webm","mkv")
    endif
    mt.addreplace("vnd.dlna.mpeg-tts","ts")
    if hasWMV()
        mt.addreplace("x-ms-wmv","wmv")
    end if
    if hasFLV()
        mt.addreplace("x-flv","flv")
        mt.addreplace("flv","flv")
    end if
    if hasASF()
        'mt.addreplace("x-ms-asf","asf")
    end if
    if hasMPEG2()
        mt.addreplace("mpeg","mpeg2")
    endif
    return mt
end function

sub UPNP_HandleEvent(msg as Object)
    code=0
    if type(msg) = "roUrlEvent"
        id = Stri(msg.GetSourceIdentity()).trim()
        code = msg.GetResponseCode()
        if  code < 0 then
            ' curProviderRequest = m.requests[id]
            print "!!!!!!!!!!ERRORR!!!!!";code;" target=";msg.gettargetipaddress();" reason=";msg.getfailurereason()
            ' print "failed url=";curProviderRequest.http.getUrl()
            ' print "Curr id";id
            ' FIXME: some error ocured, to implement proper handling once resume with upnp browsing
            ' active = getActiveVolume()
            ' if m.requests <> invalid and id <> invalid and active <>invalid then
            '    ' print "Curr provide";curProviderRequest
            '     if curProviderRequest <> invalid and  curProviderRequest.provider <> invalid and curProviderRequest.provider.usn = active.usn then
            '         print "Error in current volume!!!!"
            '         cFS = m.currentFS
            '         cFS.errorOccured = true
            '        ' if code = -7 or code = -28 then
            '         return
            '     end if
            ' end if
        end if

        requestSearchStr = ""
        if m.requests[id] <> invalid and m.requests[id].searchStr <> invalid
            requestSearchStr = m.requests[id].searchStr
        end if
        request = m.requests[id]
        provider = m.getProvider(id)
        if provider <> invalid
            if request.objID <> invalid and request.objID <> m.currentFS.objID
                return
            end if
            ' the currentFS should be hooked into the request, not the global unpn.
            ' this will be needed to manage multiple concurrent requests
            cFS = m.currentFS
            if cFS <> invalid then
                if provider.USN = cFS.provider.USN
                    cFS.timedOut = false
                endif
            end if

            id = Stri(msg.getSourceIdentity()).trim()
            print "upnp_parse id=";id;" nodetype=";Provider.nodetype
            xml = CreateObject("roXMLElement")
            if code >= 0
                xmlstringToParse = msg.getString()
            endif
            if code>0 and xml.parse(xmlstringToParse)
                'printXML(xml, 1)
                'print "type xml.name=";xml.getname()
                if xml.getname()="root"
                    provider = m.parse(provider, id, xml)
                    if provider<>invalid
                        ssdpptr().processProviders()
                        m.task.volumesChanged = true
                    else
                        print "upnp_UrlEventHandler: Provider not Found"
                    endif
                else
                  ' what other type of response?
                    ' need to add callbacks for responses
                  bodylist = xml.getbody()
                  body = bodylist[0]
                  listlist = body.getbody()
                  list = listlist[0]
                  response = list.getname()
                  print "Found response ";response
                  colpos = response.instr(":")
                  response = response.mid(colpos+1)
                  if response = "GetSearchCapabilitiesResponse"
                    ' printXML(xml,1)
                    caplist = list.getbody()
                    cap = caplist[0]
                    m.task.searchCapabilities = cap.gettext()
                  else if response = "BrowseResponse" or response = "SearchResponse"
                    if cFS.browseInProgress = false then
                        'print "STop browse"
                       ' cFS.findingFiles = false
                      '  return false
                    end if
                    result = m.update(provider, xml)
                    cFS.matches = result.matches
                    if result.matches = 0 and result.returned > 0
                        result.matches = result.returned
                    endif
                    cFS.updateID = result.updateid          ' directory changed id
                    if (result.matches = 0) or (result.returned = 0)
                        ' Clearing reference to a spinner
                        m.spinner = invalid
                        print "1ALL found<<<<<<<<<<<<<<<<<<<<<<<"
                        retValue = genericVol_defaultGetDirRetVal(cFS.objID)
                        retValue.files = cFS.files
                        m.task.returnDirectoryListing = retValue
                        cFS.findingFiles = false
                    else if cFS.searchStr = requestSearchStr
                        cFS.files.append(result.items)
                       ' cFS.count = cFS.count - result.returned
                        cFS.startIndex = cFS.startIndex + result.returned
                        cFS.totalReturned = cFS.totalReturned + result.returned
                        print "filescount=";cFS.files.count();" count=";cFS.count;" startI=";cFS.startIndex

                        if cFS.files.count() > 0 and cFS.matches > 0
                            m.UpdateProgress(cFS.files.count()/cFS.matches)
                        end if
                      '  if cFS.count = 0
                         '   print "2ALL found<<<<<<<<<<<<<<<<<<<<<<<"
                          '  cFS.findingfiles = false
                       ' else
                            ' start another request if more available
                            if (cFS.cancelListRequest=false) and (result.matches > cFS.totalReturned)
                                'print" start another request if more available"
                                thisrequest = cFS.count
                                if thisrequest > cFS.maxrequest thisrequest = cFS.maxrequest
                                if cFS.timer <> invalid then
                                    cFS.timer.Mark()
                                end if
                                m.browse(cFS.provider, cFS.searchStr, cFS.objID, cFS.startIndex, thisrequest)
                            else
                                ' Clearing reference to a spinner
                                m.spinner = invalid
                                print "ALL found<<<<<<<<<<<<<<<<<<<<<<<"
                                retValue = genericVol_defaultGetDirRetVal(cFS.objID)
                                retValue.files = cFS.files
                                m.task.returnDirectoryListing = retValue
                                cFS.findingfiles = false
                            endif
                       ' endif
                    endif
                  else
                    print "Unknown response:";response
                    ' printXML(xml, 3)
                    cFS.findingFiles = false
                  endif
                endif
            else
                print
                print "###################################HTTP-XML ERROR#############################################"
                print "http ret=";code;" target=";msg.gettargetipaddress();"  sourceid=";msg.getSourceIdentity()
                m.dumpProvider(provider)
                print "______________________________________________________________________________________________"
                if code >= 0
                    print quotestr(xmlstringToParse)
                    print "______________________________________________________________________________________________"
                endif
                if cFS <> invalid
                    if provider.USN = cFS.provider.USN
                      if cFS.findingfiles
                        print "ALL found<<<<<<< termination"
                        'cFS.findingFiles = false
                         ' bump totalreturned in case of error and try again
                         if cfs.maxrequest = 1
                            ' already at 1, this is the bad one
                            cfs.totalreturned = cfs.totalreturned + 1
                            cFS.startIndex = cFS.startIndex + 1
                            cfs.maxrequest = cfs.origmaxrequest
                         else
                            ' reduce max request
                            cfs.maxrequest = int(cfs.maxrequest/3)
                            if cfs.maxrequest < 1 cfs.maxrequest = 1
                         endif
                         if (cfs.matches>0) and (cFS.cancelListRequest=false) and (cfs.matches > cFS.totalReturned)
                                'print" start another request if more available"
                                thisrequest = cFS.count
                                if thisrequest > cFS.maxrequest thisrequest = cFS.maxrequest
                                if cFS.timer <> invalid then
                                    cFS.timer.Mark()
                                end if
                                m.browse(cFS.provider, cFS.searchStr, cFS.objID, cFS.startIndex, thisrequest)
                        else
                                cFS.findingFiles = false
                        endif
                      else
                         print "error return from getcaps?(((((((((((((((((((((((((((((((((((("
                         m.task.searchCapabilities = ""
                      endif
                    else
                        print "$$$$$$$$$$$$$$$$$$$$$$$$$$$    ignoring bad xml, not same current filesystem provider"
                    endif
                end if
            endif
        else
            print ">>>>>>>>>>>>UPnP: invalid provider - ignore this response"
            return 'invalid provider
        end if
    end if
end sub

function upnp_dumpProvider(provider as Object)
    upnp = provider.upnp
    print "DumpProvider..."
    ssdp = ssdpptr()
    ssdp.dump(provider)
    if type(upnp)="roXMLElement"
        print "UPnP: "; chr(13); upnp.genXML(false)
    end if
end function

function upnp_createUrlTransfer(provider)
    http = createobject("roUrlTransfer")
    http.setPort(m.port)
    applyUserAgent(http, provider)
    return http
end function

function upnp_dumpRequest(request as Object)
    print "Dumping Request http=";request.http
    print "Provider=";request.provider
    dumpProvider(request.provider)
end function

function upnp_getProvider(sourceId)
    provider = invalid
    request = m.requests[sourceId]
    if request<>invalid
        provider = request.provider
        m.requests.delete(sourceId)
    else
        print "UPnP: no such outstanding request "; sourceId
    end if
    return provider
end function

function upnp_parse(requestor, id, xml as Object) as Dynamic
    if requestor.nodetype = "rootdevice"
        ' find the actual provider
        ssdp = ssdpptr()
        usn = requestor.usn
        provider = ssdp.providers[usn]
        if provider = invalid
            print "Converting new providor node from rootdevice:";usn
            provider = CreateProvider(requestor)
            ssdp.providers[usn] = provider
        endif
    else
        provider = requestor
    endif
    provider.upnp = xml
    print "UPnP: received provider "; provider.usn
    if m.extract(provider)
        provider.changed = true
    else
        print "Failed to extract from provider"
    endif
    return provider
end function

function upnp_get(provider as Object)
    url = provider.location
    print "Issueing GET info for provider:";provider.location
    if url<>invalid
        http = m.createUrlTransfer(provider)
        http.setUrl(url)
        print "Sending request url:";url
        http.asyncGetToString()
        request = {}
        request.http = http
        request.provider = provider
        if m.currentFS <> invalid
            request.objID = m.currentFS.objID
        end if
        id = Stri(http.getIdentity()).trim()
        m.providerRequestID = id
        if id <> invalid and m.requests <> invalid then
            if m.requests[id] <> invalid
                print "Request overload. push onto pending for ";id
                m.pendingrequests[m.pendingrequestsCount] = request
                pendingrequestsCount = pendingrequestsCount + 1
            else
                'print add
                m.requests[id] = request
            endif

        end if
        print "UPnP: requesting provider "; provider.usn
    else
        print "UPnP: provider "; provider.usn; " has no location"
    end if
end function

function soap_go(act as string, args as string, serv as string) as string
    soap =        "<?xml version="+quotestr("1.0") + " encoding="+quotestr("utf-8")+"?>" + WinNL()
    soap = soap + "<s:Envelope s:encodingStyle=" + quotestr("http://schemas.xmlsoap.org/soap/encoding/") + " xmlns:s="+quotestr("http://schemas.xmlsoap.org/soap/envelope/")+">" + WinNL()
    soap = soap + "   <s:Body>" + WinNL()
    soap = soap + "    <u:" + act + " xmlns:u=" + quotestr("urn:schemas-upnp-org:service:" + serv + ":1") + ">" + WinNL()
    soap = soap +             args
    soap = soap + "      </u:" + act + ">" + WinNL()
    soap = soap + "   </s:Body>" + WinNL()
    soap = soap + "</s:Envelope>" + WinNL()

    if (isVerbose()) print "soap=";soap

    return soap
end function

function locationRoot(location as string) as string
    locRoot = invalid
    len = location.instr("http://")  ' make sure http:// is the first part of the location string
    if len = 0
        len = location.len()
        ip = location.right(len-7)   ' strip off http://
        len = ip.instr("/")
        if len>0
            locRoot = ip.left(len)  ' we only want ipaddress:portnum
        else
            locRoot = ip
        endif
    else
        print "ERROR bad location:";location
    endif
    return locRoot
end function

function upnp_post(provider as Object, action, service, args) as boolean
    request = {}
    serviceinfo = provider.services[service]
    location = provider.location

    loc = locationRoot(location)
    if loc = invalid return false

    if serviceinfo<>invalid
        http = m.createUrlTransfer(provider)
        t = serviceinfo.controlURL.getText()
	    if t.left(7) <> "http://"
            sep = ""
            if t.left(1) <> "/" and loc.right(1) <> "/"
                sep = "/"
	        endif
            url = "http://" + loc + sep + t
	    else
	       url = t
        endif
        http.setUrl(url)
        http.addheader("SOAPACTION", quotestr("urn:schemas-upnp-org:service:" + service + ":1#" + action))
        http.addheader("CONTENT-TYPE", "text/xml ; charset=" + quotestr("utf-8"))
        'print "upnp_post url=";url
        http.asyncPostFromString(soap_go(action,args,service))

        request.http = http
        request.provider = provider
        request.searchStr = m.currentFS.searchStr
        if m.currentFS <> invalid
            request.objID = m.currentFS.objID
        end if
        id = Stri(http.getIdentity()).trim()
        if m.requests[id] <> invalid
            print "Request overload. push onto pending for ";id
            m.pendingrequests[m.pendingrequestsCount] = request
            pendingrequestsCount = pendingrequestsCount + 1
        else
            m.requests[id] = request
        endif
	return true
    else
        print "UPnP: provider "; provider.usn; " has no service:"; service
	return false
    end if
end function

function upnp_extract(provider as Object) as boolean
    upnp = provider.upnp
    print "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%upnp_extract:";provider.usn
    if type(upnp)="roXMLElement"
       d = upnp.device
       print "type(d)=";type(d)
       if type(d)="roXMLList"
            provider.friendlyName     = d.friendlyName.getText()
            provider.modelName        = d.modelName.getText()
            provider.modelNumber      = d.modelNumber.getText()
            provider.modelDescription = d.modelDescription.getText()
            provider.manufacturer     = d.manufacturer.getText()
            provider.deviceType       = d.deviceType.getText()
            provider.changed          = true
            sl = d.servicelist
            provider.services = {}
            if type(sl) = "roXMLList"
              print "Looking for services............................"
              'printXML(sl, 1)
              for each service in sl.service
                serviceidstr = service.serviceId.getText()
                colonSep = serviceidstr.instr("Id:")
                serviceID = serviceidstr.mid(colonSep+3)
                'print "Found service=";serviceidstr;" colorsep=";colonSep;" id=";serviceID
                provider.services[serviceID] = service     ' save entire xml record
              end for
            else
                print "Could not find xml for serviceList~~~~~~~~~~~~~~~~~~~~~~~~~"
            endif
            icons = d.iconList
            if type(icons)="roXMLList"
                locRoot = locationRoot(provider.location)
                print "Looking for icons............................ loc="; locRoot

                curSize = 0 ' want to find largest icon
                    for each icon in icons.icon
                        'printXML(icon, 1)
                        iconLoc = icon.url.gettext()
                        if iconloc.left(1) <> "/"
                            iconloc = "/" + iconloc
                        endif
                        mimetype = icon.mimetype.gettext()
                        if mimetype.instr("jpeg") >= 0 or mimetype.instr("png")>=0
                            'print "found icon:";iconLoc
                            sizestr = icon.width.gettext()
                            size = sizestr.toint()
                            if size > curSize
                                curSize = size
                                provider.HDPosterUrl = "http://" + locRoot + iconLoc
                                print "Found icon width=";size;" url=";provider.HDPosterUrl
                            endif
                        end if
                    end for

                    if provider.HDPosterUrl = invalid
                        ' provide icon for volume selection if non provided by dlna server
                        provider.HDPosterURL =  GetLocalizedImage("ic_media device_hd.png")
                        provider.FHDPosterURL =  GetLocalizedImage("ic_media device_fhd.png")
                    else
                        provider.SDPosterUrl = provider.HDPosterUrl
                    endif
            endif
            return true
       else
            print "Could not find Device xml element"
       endif
    end if
    return false
end function

function upnp_createFS(volume)
    this = create_generic_FS(volume)
    this.GetDirectoryListing = upnp_GetDirectoryListing
    this.GetUpdateID = upnp_GetUpdateID
    this.enableUpdateIDEvents = upnp_EnableUpdateIDEvents
    this.GetSearchCapabilities = upnp_GetSearchCapabilities
    this.Cancel = upnp_Cancel
    return this
end function

function upnp_Cancel(objectID as string) as void
    print "upnp_Cancel"
    m.cancelListRequest = true
    m.objectIDToCancel = objectID
    RMPPostEvent("upnp",UPNPcancelID())
end function

function upnp_GetUpdateID(objID as string) as string
    if m.updateID <> invalid and m.objID <> invalid and m.objID = objID
        foo = m.updateID
        m.updateID = invalid
        return foo
    endif
    ' need to try to retrieve updateID
    d = Dispatcher()
    upnp = get_upnp()
    m.findingfiles = true
    res = true
    if upnp.browse(m.provider, "", objID, 0, 1)
        print "upnp_GetUpdateID:Wait!!!!"
        m.browseInProgress = true
        m.timer.Mark()
    	while m.findingfiles and res and not m.cancelListRequest
            m.timedOut = true
            timeout = 31000
            d.wait(timeout)
            if m.cancelListRequest exit while
            x = m.timer.TotalMilliseconds()
            'print "x = ";x
            'fix for long loading
            if m.timedOut and x < timeout then
                m.timedOut = false
            end if
            linkStatus = getSafeNetworkStatus()
            if isErrorRemovalOn() then
                m.cancelListRequest = true
                exit while
            endif

            fileCount = m.files.count()
            processed = m.totalreturned

    	end while
    endif
    print "timeout ";m.timedOut "res ";res " finding ";m.findingfiles " error ";m.errorOccured ; " cancel ";m.cancelListRequest
    m.browseInProgress = false
    if m.cancelListRequest
        return "cancel"
    endif
    foo = m.updateID
    m.updateID = invalid
    if foo = invalid
        ' always return a valid string RMP-163
        return "0"
    endif
    return foo
end function

function upnp_GetDirectoryListing(objID as String, searchStr = "" as String) as Object
    print "upnp_GetDirectoryListing(";objID;") search=";searchStr
    m.cancelListRequest = false

    m.totalReturned = 0
    ' initiate request to get the first maxrequest entries
    m.maxrequest = maxUPNPRequest()
    if searchstr <> ""
        ' if we are searching, grab all the results, some dlna servers don't cache results when requesting partial results
        m.maxrequest = 400
    endif
    m.origMaxRequest = m.maxrequest
    thisrequest = m.maxrequest
    upnp = get_upnp()
    ' make sure handler knows who is doing the request
    upnp.CurrentFS = m

    ' Save reference to a spinner until listing isn't finished to reduce rendezvous when updating progress
    if upnp.componentController <> invalid
        currentView = upnp.componentController.currentView
        if currentView <> invalid
            upnp.spinner = currentView.FindNode("spinner")
        end if
    end if
    upnp.timespan = CreateObject("roTimespan")

    m.findingfiles = true
    m.count = thisrequest
    m.startIndex = 0
    m.matches = -1  ' cached, initialize to illegal
    m.objID = objID
    m.updateID = invalid
    m.files = []
    m.searchStr = searchStr
    m.browseInProgress = true
    m.tryAgain = false
    m.errorOccured = false
    m.timedOut = true
    m.timer = CreateObject("roTimespan")
    'print "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!Provider:";m.provider
    watchCount = 0
    filesPerUpdate = int(maxUPNPRequest()*2)    ' 20 or 40

    upnp.browse(m.provider, searchStr, objID, m.startIndex, thisrequest)
    print "timeout ";m.timedOut "res ";res " finding ";m.findingfiles " error ";m.errorOccured ; " cancel ";m.cancelListRequest
    m.browseInProgress = false
    if m.cancelListRequest
        m.files = []
        return "cancel"
    endif
end function

function upnp_GetSearchCapabilities()
    print "upnp_GetSearchCapabilities"
    m.stringResult = invalid
    m.findingfiles = false
    m.maxRequest = 1
    upnp = get_upnp()
    upnp.CurrentFS = m
    args = ""
    if not upnp.post(m.provider, "GetSearchCapabilities","ContentDirectory",args)
        ' if request is not sent
        upnp.task.searchCapabilities = ""
    end if
end function

function upnp_subscribeEvent()
    gena = "SUBSCRIBE publisher path HTTP/1.1" + WinNL()
    gena.append("HOST: publisher host:publisher port"+WinNL())
    gena.append("CALLBACK: <delivery URL>"+WinNL())
    gena.append("NT: upnp:event"+WinNL())
    gena.append("TIMEOUT: second-requested subscription duration"+WinNL())
end function

function upnp_EnableUpdateIDEvents(enable as boolean)
    print "upnp_EnableUpdateIDEvent:";enable
end function
