' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

sub init()
    m.top.accessType = DLNAAccessType()
    StartBackgroundThread()
end sub

sub StartBackgroundThread()
    m.top.functionName = "ServiceMain"
    m.top.control = "run"
end sub

sub ServiceMain()
    initialized = false
    tmout = 5000
    port = CreateObject("roMessagePort")

    m.upnpController = NewUPNPController(port)
    m.ssdpController = NewSSDPController(port)
    m.ssdpController.search()

    m.top.ObserveField("getDirectoryListing", port)
    m.top.ObserveField("getSearchCapabilities", port)
    while true
        msg = wait(tmout, port)
        m.ssdpController.HandleEvent(msg)
        m.upnpController.HandleEvent(msg)
        ' intialize service after search request was handled
        ' or after tmout delay if there are no dlna servers
        if not initialized
            initialized = true
            m.top.initialized = initialized
        end if
    end while
end sub
