' These are all upnp/dlna related functions

function byteRangeOK(f as string) as boolean
   OPi = f.instr("DLNA.ORG_OP=")
   if OPi < 0
        ' check for the CI conversion indicator flag
        CI = f.instr("DLNA.ORG_CI=")
        if CI < 0
            return true  ' assume byte range requests ok if flags are not present to say they aren't
        endif
        ciFlag = f.mid(CI+12,1)
        if ciFlag = "1" return false
        return true
   endif
   opflags = f.mid(OPi+12,3)
   if opflags.instr("1;") >= 0 return true
   if isVerbose() print "byte range request not supported:";f
   return false
end function

function videoResBad(xres as integer, yres as integer) as boolean
    if (xres<=Config().Get("maxVideoColsLS")) and (yres<=Config().Get("maxVideoRowsLS")) return false
    if (xres<=Config().Get("maxVideoColsPT")) and (yres<=Config().Get("maxVideoRowsPT")) return false
    if DimensionCheckDisabled() return false
    return true   ' is bad
end function

function AttachBitrateDurationSize(bitrateISbitrate as boolean, item as object, attr as object) as void
    durString = attr.duration  ' duration=0:00:10.000
    if durString <> invalid
        item.duration = convertDurationStrToInt(durString)
        'print "Setting duration to "; item.duration; " seconds"                        
    endif ' durString
    bitrateString = attr.bitrate ' bitrate=1024000,
    if bitrateString <> invalid
        'item.bitrate = int((bitrateString.toint()+999)/1000)
        ' minidlna gives bitrate, most everyone else gives byterate
        if bitrateISbitrate
            item.bitrate = int((bitrateString.toint()+999)/1000)
        else
            item.bitrate = int((bitrateString.toint()*8+999)/1000)
        endif
    else
        item.bitrate = 0
    endif
    if attr.size <> invalid
        item.size = int(attr.size.toint())
    else
        item.size = -1  ' unknown
    endif    
end function

function browse_update(provider, xml as object) as Dynamic
    lVerbose = isVerbose()
    bitrateISbitrate = provider.miniDLNA or provider.Twonky
    gifMAXsize = maxGifSize()
    lDimCheck = true
    if DimensionCheckDisabled()
        lDimCheck = false
        gifMAXsize = 2000000000 ' set width*height limit close to max Int allowed
    endif
    items = []
    NumberReturned = "0"
    TotalMatches = "0"
    updateID = "0"
    if lVerbose
        print "browse: received provider "; provider.usn
        print "Server= "; provider.server
    endif
        'printXML(xml,1)
        if type(xml)="roXMLElement"       
            provider.upnp = xml

            bodylist = xml.getbody()
            body = bodylist[0]
            'print "printing Body0"
            'printXML(body,2)

            listlist = body.getbody()
            list = listlist[0]
            'print "print list"
            'printXML(list,3)

            result = list.Result

            NumberReturned = list.NumberReturned.gettext()
            TotalMatches = list.TotalMatches.gettext()
            updateID = list.UpdateID.gettext()
            print "numreturned=";NumberReturned;" TotalMatches=";TotalMatches;" UPDT ID:";updateID

            resultxml = CreateObject("roXMLElement")
            if resultxml.parse(result.gettext())
                'print "OK parse"
                'printXML(resultxml, 3)

                for each container in resultxml.container
                    if lVerbose
                        printXML(container,1)
                    endif
                    titlelist = container.getnamedelements("dc:title")
                    'PrintXML(titlelist, 2)
                    title = titlelist[0]
                    attributes = container.getattributes()
                    count = ""
                    if attributes.childCount <> invalid then count = " ("+attributes.childCount+")"  
                    id = attributes.id
                    print "found container="; title.gettext(); " count=";count;" id=";id
                    item = {}
                    item.title = title.gettext()
                    item.ShortDescriptionLine1 = title.gettext()+count
                    item.objectID = id
                    item.isMedia = 0

                    ' find a suitable icon/posterurl image
                    artworklist = container.getnamedelements("upnp:albumArtURI")
                    artwork = artworklist[0]
                    if artwork <> invalid
                        posterUrl = artwork.gettext()
                        if posterUrl <> invalid
                            'print "SetPosterUrl=";posterurl
                            item.HDPosterUrl = posterurl
                            item.SDPosterUrl = posterurl
                        endif
                    endif

                    items.push(item)
                end for
                for each leaf in resultxml.item
                    attributes = leaf.getattributes()
                    id = attributes.id

                    ' there should always be one of these
                    elementlist = leaf.getnamedelements("upnp:class")
                    upnpclass = elementlist[0].gettext()

                    elementlist = leaf.getnamedelements("dc:title")
                    title = elementlist[0]
                    if (lVerbose)
                        print "found title="; title.gettext()
                        printXML(leaf, 1)
                    endif
                    item = {}

                    elementlist = leaf.getnamedelements("dc:description")
                    if (elementlist.count()>0)
                        item.description = elementlist[0].gettext()
                        'print "found desc="; item.description
                    endif

                    elementlist = leaf.getnamedelements("upnp:artist")
                    if elementlist.count()>0
                        item.Artist = elementlist[0].gettext()
                    end if

                    elementlist = leaf.getnamedelements("upnp:genre")
                    if elementlist.count()>0
                        item.Genre = elementlist[0].gettext()
                    end if

                    elementlist = leaf.getnamedelements("upnp:album")
                    if elementlist.count()>0
                        item.Album = elementlist[0].gettext()
                    end if

                    elementlist = leaf.getnamedelements("upnp:longDescription")
                    if elementlist.count()>0
                        item.description = elementlist[0].gettext()
                    end if

                    elementlist = leaf.getnamedelements("dc:date")
                    if elementlist.count()>0
                        item.ReleaseDate = elementlist[0].gettext()
                    end if
                    elementlist = leaf.getnamedelements("upnp:rating")
                    if elementlist.count()>0
                        item.Rating = elementlist[0].gettext()
                    end if

                    elementlist = leaf.getnamedelements("upnp:originalTrackNumber")
                    if elementlist.count()>0
                        trackstr = elementlist[0].gettext()
                        item.track = trackstr.toint()
                    end if

                        ' find a resource for this item
                    looking = true
                    format = ""
                    resources = leaf.getnamedelements("res")
                    jpeg_tn = invalid
                    dlnaformat = ""
                    resindex = 0
                    attr = {}           ' remember this
           
                    if upnpclass.instr("videoItem") >= 0         ' +++++++++++ VIDEO ITEMS +++++++++++++++
		      if item.releasedate <> invalid
			  iso = item.releasedate.instr("T")
			  if iso>=0
			      ' don't need T and anything after that if ISO date format
			      item.releasedate = item.releasedate.left(iso)
			  endif
		      endif
                      for each url in resources
                        u = url.gettext()
                        if u.instr("http://")>=0 ' we only support http protocol, ignore things like rtsp
                          attr = url.getattributes()
                          playformat = invalid
                          rawformat = attr.protocolInfo
                          if (lVerbose) print "Extracted protocolInfo=";rawformat
                          canDoByteRange = byteRangeOK(rawformat)

                          if 1 or canDoByteRange         ' allow byterange only
                            start = rawformat.instr("video/")
                            if start > 0
                              'print "Is video"
                              colonPos = rawformat.instr(start,":")     ' find location of first colon
                              dlnaformat = lcase(rawformat.mid(start+6,colonPos-start-6))
                              playformat = m.VideoMimetypes[dlnaformat]
                              if playformat <> invalid
                                if (lVerbose) print "video ";dlnaformat;" -> ";playformat
                                'special test for transcoded asf
                                if playformat = "asf"
                                  ' if asf and not pico check for vc1
                                  if rawformat.instr("VC1_ASF")>=0
                                    if not hasVC1()
                                      playformat = invalid
                                    endif
                                  endif
                                else if playformat = "mpeg2"    ' need further testing for mpeg2 style
                                  ' if it is mpeg2, and they don't tell us it is a ps stream, assume ts
                                  if rawformat.instr("DLNA.ORG_PN=MPEG_PS")<0
                                      playformat = "ts"
                                  else  ' found MPEG_PS
                                     ' if it is ps, then ignore it because we don't have a demux for that
                                      playformat = invalid
                                  endif
                                else if (playformat = "ts") and (provider.windows10)
                                    if (rawformat.instr("AVC_TS_JP_AAC_T")>=0)
                                        playformat = invalid
                                    endif
                                endif
                              else
                                if (lVerbose) print "title=";title.gettext();" Ignoring format=";dlnaformat
                              endif
                            else  ' not regular video
                              ' look for HTTP Live Streaming style video
                              start = rawformat.instr("application/")
                              if start>0
                                print "Found Application type format=";rawformat
                                colonPos = rawformat.instr(start,":")     ' find location of first colon
                                dlnaformat = rawformat.mid(start+12,colonPos-start-12)
                                if dlnaformat="x-mpegURL" or dlnaformat="vnd.apple.mpegurl"
                                  playformat="hls"
                                  formatname = dlnaformat
                                else if dlnaformat="dash+xml"
                                  playformat="dash"
                                  formatname=dlnaformat
                                else if dlnaformat = "octet-stream" and hasautodetect()
                                  ' if we have auto detect in this firmware
                                  playformat = ""
                                  formatname=dlnaforat
                                endif
                              else if rawformat = "http-get:*:MIMETYPE_AUTO:DLNA.ORG_OP=01" and hasautodetect()
                                playformat = ""
                                formatname="mimetype_auto"
                              else if rawformat = "http-get:*:text/srt:*"
                                 item.subtitleUrl = url.gettext()
                                 print "Found Subtitle URL=";item.subtitleUrl
                              else if rawformat = "http-get:*:text/vtt:*"
                                 item.subtitleUrl = url.gettext()
                                 print "Found Subtitle URL=";item.subtitleUrl
                              else if rawformat.instr("JPEG_TN") >= 0
                                 jpeg_tn = url.gettext()
                                 'print "found minidlna artwork:";jpeg_tn
                              else
                                 print "title=";title.gettext(); " Ignore protocol=";u
                              endif
                            endif
                          else   ' no byterange
                              print "Requires Time Range requests"
                              'print "title=";title.gettext(); " Ignore protocol=";u
                          endif ' byterange
                        endif 'http
                        if playformat <> invalid
                            ' validate resolution if possible
                            resolution = attr.resolution
                            if resolution <> invalid
                                xPos = resolution.instr(0,"x")
                                xRes = resolution.left(xPos).toInt() ' int(val(res.left(xPos)))
                                yRes = resolution.mid(xPos + 1).toInt() 'int(val(resolution.mid(xPos+1)))
                                if videoResBad(xRes,yRes)
                                    print "Found bad video resolution (";xres;"x";yres;")"
                                    playformat = invalid
                                else
                                    if (lVerbose) print "Found resolution (";xres;"x";yres;")"
                                endif
                            endif
                            if playformat <> invalid
                                if item.format <> invalid
                                    ' already have a candidate, is this one better?
                                    if not canDoByteRange   ' transcoded
                                        ' treat directplay & "ts" & noresolution as potentially bad.
                                        if (not item.islive) ' and ((item.format <> "ts") or (item.resolution <> invalid))
                                            ' skip the new one, old one is direct play
                                            playformat = invalid
                                        else
                                            ' both entries are transcoded, pick best one
                                            if item.format = "ts" and playformat = "mp4"
                                                ' for testing Windows 10 jira fw-8647
                                                playformat = invalid  ' choose ts over mp4
                                            else
                                             if item.format = "mp4" and playformat = "ts"
                                                'playformat = invalid                ' choose mp4 over ts
                                             else
                                              if (resolution <> invalid) and (item.resolution <> invalid)
                                                oldxPos = item.resolution.instr(0,"x")
                                                oldxRes = item.resolution.left(oldxPos).toInt() ' int(val(res.left(oldxPos)))
                                                print "oldres=";item.resolution;" newres=";resolution
                                                if (oldxRes >= xRes)
                                                    ' skip this one, the current one is bigger
                                                    print "keep current one"
                                                    playformat = invalid
                                                else
                                        
                                                    print "Use new one xRes=";xRes;" oldxRes=";oldxRes
                                                endif
                                              else ' one or the other, or both do not have a resolution
                                                if item.resolution <> invalid
                                                    ' keep the current one with a resolution
                                                    playformat = invalid
                                                endif
                                              endif
                                             endif
                                            endif
                                        endif
                                    endif
                                endif
                                if playformat <> invalid
                                    item.format = playformat
                                    item.isLive = not canDoByteRange
                                    if isPro() AND item.islive
                                        item.formatname = ">"+dlnaformat
                                    else
                                        item.formatname = dlnaformat
                                    endif
                                    item.url = u
                                    item.ismedia = 1
                                    ' is there a subtitle url? for seagate central look for pv:subtitleFileType
                                    if attr.DoesExist("pv:subtitleFileType")
                                        subtitleattr = attr.lookup("pv:subtitleFileType")
                                        if (subtitleattr = "SRT") or (subtitleattr = "VTT")
                                            item.subtitleUrl = attr.lookup("pv:subtitleFileUri")
                                            print "Found Subtitle URL=";item.subtitleUrl
                                        endif
                                    endif
                                    AttachBitrateDurationSize(bitrateIsbitrate, item, attr)
                                    if resolution <> invalid
                                        item.resolution = resolution
                                    else
                                        item.resolution = invalid
                                    endif
                                endif
                            endif
                        endif
                        resindex = resindex + 1
                      end for ' each url

                    else if upnpclass.instr("audioItem") >= 0         ' +++++++++++ AUDIO ITEMS +++++++++++++++
		      if item.releasedate <> invalid
			  iso = item.releasedate.instr("T")
			  if iso>=0
			      ' don't need T and anything after that if ISO date format
			      item.releasedate = item.releasedate.left(iso)
			  endif
		      endif
                      for each url in resources
                        u = url.gettext()
                        if u.instr("http://")>=0 ' we only support http protocol, ignore things like rtsp
                          attr = url.getattributes()
                          rawformat = attr.protocolInfo
                          if (lVerbose) print "AudioItem:res:Extracted protocolInfo=";rawformat
                          canDoByteRange = byteRangeOK(rawformat) ' is this being transcoded?
                          start = rawformat.instr("audio/")
                          if start>0
                            colonPos = rawformat.instr(start,":")     ' find location of first colon
                            dlnaformat = lcase(rawformat.mid(start+6,colonPos-start-6))
                            'print "dlnaformat=";dlnaformat
                            playformat = m.AudioMimetypes[dlnaformat]
                            if playformat <> invalid and item.format = invalid
                               if dlnaformat = "x-ms-wma" and rawformat.instr("DLNA.ORG_PN=WMALSL")>=0
                                  print "Skipping wma lossless"
                               else
                                   if not canDoByteRange and playformat="mp4"
                                        ' we cant process transcoded mp4 files
                                   else
                                       if (lVerbose) print "audio ";dlnaformat;" -> ";playformat
                                       item.format = playformat
                                       item.formatname = dlnaformat
                                       item.ismedia = 2
                                       item.url = u
                                       item.isLive = not canDoByteRange
                                       AttachBitrateDurationSize(bitrateIsBitrate, item, attr)
                                   endif
                               endif
                            else
                               if lVerbose print "title=";title.gettext();" Ignoring format=";dlnaformat
                               if dlnaformat = "x-mpegurl"
' found on windows 10 media player - audio playlist
'      Attributes: size=53, protocolInfo=http-get:*:audio/x-mpegurl:DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01700000000000000000000000000000
' with additional resource items for each entry after that entry
' ignore for now
                               print "title=";title.gettext();" Ignoring format=";dlnaformat
                                   exit for
                               endif
                            endif
                          else
                            if lverbose print "Audio: unknown resource:";rawformat
                          endif
                        endif ' http
                      end for 'resources
                    else if upnpclass.instr("imageItem") >= 0         ' +++++++++++ IMAGE ITEMS +++++++++++++++
                      lastxRes = -1
		      'item.dateTimeSort = 0
		      ' for windows media player
                      elementlist = leaf.getnamedelements("upnp:scheduledStartTime")
                      if elementlist.count()>0
			t = elementlist[0].gettext()
                        item.releaseDate = t.replace("T"," ")
                        'dt = createobject("roDateTime")
                        'dt.FromISO8601String(t)
                        'item.dateTimeSort = dt.asSeconds()
                      else
                        if item.releaseDate <> invalid
                          t = item.releaseDate
                          'dt = createobject("roDateTime")
                          if t.instr("T")>0        ' ISO?
                              'dt.FromISO8601String(t)
                              'item.dateTimeSort = dt.asSeconds()
                              item.releaseDate = t.replace("T"," ")
                          endif
                        endif
                      end if
                      for each url in resources
                        u = url.gettext()
                        if u.instr("http://")>=0 ' we only support http protocol, ignore things like rtsp
                            attr = url.getattributes()

                            rawformat = attr.protocolInfo
                            if (lVerbose) print "Extracted protocolInfo=";rawformat

                            start = rawformat.instr("image/")
                            if start>0
                                'print "Is image"
                                colonPos = rawformat.instr(start,":")     ' find location of first colon
                                dlnaformat = rawformat.mid(start+6,colonPos-start-6)
                                'print "dlnaformat=";dlnaformat
                                thisformat = ""
                                if dlnaformat="jpeg"
                                    tn = rawformat.instr("JPEG_TN")
                                    if tn<0
                                         ' Hack alert for Twonky - sheesh
                                         ' they put the attributes in the url string.
                                         tn = u.instr("JPEG_TN")
                                    endif
                                    if tn > 0
                                         ' use this for thumbnail, not for image
                                         jpeg_tn = u
                                    else
                                         thisformat = "jpg"
                                    endif
                                else if dlnaformat="png"
                                    tn = rawformat.instr("PNG_TN")
                                    if tn > 0
                                        ' ignore Thumbnails for type - use it for albumart if not defined
                                        'print "Found png_tn:";u
                                        jpeg_tn = u
                                    else
                                        thisformat = "png"
                                    endif
                                else if dlnaformat="gif"
                                    thisformat = "gif"
                                else
                                    print "Image: Ignoring formattitle=";title.gettext();" format=";rawformat
                                endif
                                if thisformat <> ""
                                    xRes = -1
                                    looking = false
                                    foo = ""
                                    resolution = attr.resolution
                                    if resolution <> invalid
                                      ' check resolution max dimensions for gif or png
                                      xPos = resolution.instr(0,"x")
                                      xRes = resolution.left(xPos).toInt() ' int(val(res.left(xPos)))
                                      yRes = resolution.mid(xPos + 1).toInt() 'int(val(resolution.mid(xPos+1)))
                                      if (thisformat <> "jpg") and (yRes * xRes > gifMAXsize)
                                          print thisformat;" Found bad image resolution (";xres;"x";yres;")"
                                          looking = true   ' skip this one, try the next one
                                      else
                                          if (lVerbose) print "Found resolution (";xres;"x";yres;")"
                                      endif
                                      foo = "[" + resolution + "]"
                                    endif
                                    if not looking
                                       doStore = true
                                       ' Is this the second time through here?
                                       if item.format <> invalid
                                           if (xRes > 0) and lastXRes>=xRes
                                               ' only use the largest image
                                               doStore = false
                                           endif
                                       endif
                                       foo = foo + " " + thisformat
                                       if doStore
                                           lastXres = xRes
                                           item.format = thisformat
                                           item.formatname = dlnaformat
                                           item.ismedia = 3
                                           item.url = u
                                           if resolution <> invalid
                                               item.resolution = resolution                           
                                           endif
                                           if item.ReleaseDate <> invalid
                                              item.TextOverlayUL = item.ReleaseDate + " " + foo
                                           else
                                              item.TextOverlayUL = foo
                                           endif
                                           canDoByteRange = byteRangeOK(rawformat)
                                           item.isLive = not canDoByteRange
                                           if lVerbose print "Image using format:";thisformat;" res=";resolution;" transcode="; not candobyterange
                                       endif
                                    endif
                                endif  ' !thisformat
                            else ' !start
                                print "Image: unknown resource:";rawformat
                            endif
                        endif ' http
                      next   ' resource
                      ' find thumbnail if none in res list
                      if item.format <> invalid and jpeg_tn = invalid
                        artworklist = leaf.getnamedelements("upnp:albumArtURI")
                        artwork = artworklist[0]
                        if artwork <> invalid
                            jpeg_tn = artwork.gettext()
                        else
                          if lDimCheck   ' needed for testing FW-16428
                            if item.resolution <> invalid
                                xPos = item.resolution.instr(0,"x")
                                xRes = item.resolution.left(xPos).toInt() ' int(val(res.left(xPos)))
                                yRes = resolution.mid(xPos + 1).toInt() 'int(val(resolution.mid(xPos+1)))
                                if xRes*yRes <= maxThumbPixels()        ' prevent thumbs that are too big
                                    jpeg_tn = item.url
                                endif
                            endif
                          else
                            jpeg_tn = item.url
                          endif
                        endif
                      endif
                    else
                        print "ERROR: unknown upnpclass";upnpclass
                    endif

                    ' did we find something to play?
                    if item.format <> invalid

                        ' Create Description line for debugging
                        item.Debugformat = format       ' printed out with info button

                        item.Title = title.gettext()

                        ' find a suitable icon/posterurl image
                        if jpeg_tn = invalid
                            artworklist = leaf.getnamedelements("upnp:albumArtURI")
                            artwork = artworklist[0]
                            if artwork <> invalid
                                jpeg_tn = artwork.gettext()
                            endif
                        endif

                        if jpeg_tn <> invalid
                            'print "SetPosterUrl=";jpeg_tn
                            item.HDPosterUrl = jpeg_tn
                            item.SDPosterUrl = jpeg_tn
                        endif

                        item.objectID = id

                        if (lVerbose) print "Got item url=";item.url; " isLive=";item.isLive
                        items.push(item)
                    else
                        print "No valid formats for title=";title.gettext()
                    endif
                end for ' each leaf
            else
                print "Could not xml parse:";result.gettext()
            endif        
        else
            print "Not a roXMLElement"
        endif
    return { returned: NumberReturned.toint()
             matches: TotalMatches.toint()
             updateid: updateID
             items : items }
end function

function Browse(provider,searchStr as string, OBJId as string, startIndex, count) as boolean
    ' go into OBJId containers of this provider
    ' need objectid, browseflag, filter, startingindex, requestedcount,sortcriteria

    args = "<ObjectID>" + OBJId + "</ObjectID>"

    if searchStr<>""
	action = "Search"
    	args = args + "<SearchCriteria>(" + searchStr + ")</SearchCriteria>"
    else
    	action = "Browse"
    	browseflag = "BrowseDirectChildren"
    	args = args + "<BrowseFlag>" + browseflag + "</BrowseFlag>"
    endif

    if dlnaGetAllData()
        filter="*"
        subtitlefilter = ""
        trackFilter = ""
        ' not using upnp:class,upnp:searchClass
    else
        ' tell server to only send the fields we are interested in
	' windows mediacenter uses upnp:scheduledStartTime for photo time taken
        dcFilter="dc:title,dc:description,dc:date,"
        upnpFilter="upnp:longDescription,upnp:artist,upnp:album,upnp:albumArtURI,upnp:rating,upnp:scheduledStartTime,upnp:genre,"
        filter = "id,"+dcfilter+upnpFilter+"res,res@duration,res@bitrate,res@size,res@protocolInfo,res@resolution,container@childCount"
        trackFilter = ",upnp:originalTrackNumber"
        subtitlefilter = ",res@pv:subtitleFileType,res@pv:subtitleFileUri"
    endif

    ' Note: filter must always be specified. If you want to see everything the server has available, then let it use "*"
    args = args + "<Filter>" + filter + trackFilter + subtitlefilter + "</Filter>"
    args = args + "<StartingIndex>" + startIndex.toStr() + "</StartingIndex>"
    args = args + "<RequestedCount>" + count.toStr() + "</RequestedCount>"
    args = args + "<SortCriteria>"+ "</SortCriteria>"

    return m.post(provider, action,"ContentDirectory",args)
    ' Browse("0", "BrowseMetadata", "*", 0, 0, "")
end function

function BrowseMetaData(provider) as boolean
    ' go into top level diretory of this provider
    ' need objectid, browseflag, filter, startingindex, requestedcount,sortcriteria

    args = "<ObjectID>0</ObjectID>"
    args = args + "<BrowseFlag>BrowseDirectChildren</BrowseFlag>"
    args = args + "<Filter>*</Filter>"
    args = args + "<StartingIndex>0</StartingIndex>"
    args = args + "<RequestedCount>30</RequestedCount>"
    args = args + "<SortCriteria>"+ "</SortCriteria>"

    return m.post(provider, "BrowseMetaData","ContentDirectory",args)
    ' Browse("0", "BrowseMetadata", "*", 0, 0, "")
end function
