' Copyright (c) 2018 Roku, Inc. All rights reserved.

sub init()
    m.top.functionName = "ContentGetter__GetContentWrapper"
end sub

sub ContentGetter__GetContentWrapper()
    if m.top.content <> invalid then m.top.content.queueFields(true)
    GetContent()
    if m.top.content <> invalid then m.top.content.queueFields(false)
    m.top.finished = true
end sub

' developer needs to override this function in the component
' extended from ContentGetter.
' Returned value will be used as a content for a view.
function GetContent() as Object
    ? "SGDEX: you need to have GetContent() function in "m.top.Subtype()" component"
    return invalid
end function

' This is a helper sub to update current view busy/progress indicator (spinner) 
' with the progress. Allowed values are from 0.0 to 1.0
sub UpdateProgress(progress as Float)
    if progress >= 0.0 and progress <= 1.0
        ' put the progress to the current view's busy indicator (spinner)
        componentController = m.top.GetScene().ComponentController
        if componentController <> invalid
            currentView = componentController.currentView
            if currentView <> invalid
                spinner = currentView.FindNode("spinner")
                if spinner <> invalid
                    spinner.progress = progress
                end if
            end if
        end if
    else
        ? "SGDEX: UpdateProgress() incorrect progress value ("progress"), should be from 0.0 to 1.0"
    end if
end sub