' ********** Copyright 2020 Roku Corp. All Rights Reserved. **********

sub GetContent()
    selectedItem = m.top.selectedItem
    contentList = m.top.contentList
    if contentList.GetChild(0).GetChild(0) <> invalid
        contentList = ConvertGridToListContent(contentList, true)
    end if
    
    itemIndex = ObjectLocationInList(selectedItem.objectID, contentList.GetChildren(-1,0))
    filteredAA = FilteredList(contentList, itemIndex, selectedItem.type)
    for each item in filteredAA.flist.getChildren(-1, 0)
        config = {
            HandlerConfigMedia: {
                name: "VideoItemCH"
                fields:{
                    isUSBAccessType: m.top.isUSB
                }
            }
        }
        item.Update(config, true)
    end for

    if selectedItem.hasField("needToFind") and (not selectedItem.needToFind)
        filteredAA.sitem = -1
    end if
    if filteredAA.sitem >= 0
        m.top.content.Update({
            jumpToItem: filteredAA.sitem
        },true)
    end if
    m.top.content.AppendChildren(filteredAA.flist.getChildren(-1,0))
    m.top.content.Update({failedLoading: false}, true)
end sub
