' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

sub GetContent()
    m.localizer = CreateObject("roLocalization")

    m.mediaServerAA = m.top.mediaServerAA
    m.objID = m.top.objID
    service = m.top.service

    if m.mediaServerAA <> invalid and service <> invalid
        port = CreateObject("roMessagePort")
        while true
            result = service.returnDirectoryListing
            if result <> invalid
                if result.objID = m.objID
                    DataLoaded(service, result)
                    exit while
                end if
            end if
            event = wait(100, port) ' wait in task thread till service do all the job
        end while
    end if
end sub

sub DataLoaded(service as Object, listing as Object)
    service.returnDirectoryListing = invalid
    ' make sure that processing of the content will hapen only after loading flag is set
    m.top.content.RemoveField("failedLoading")
    if IsValidListing(listing)
        gridRows = GetGridContent(m.mediaServerAA, m.objID, listing)
        rowsContent = CreateObject("roSGNode", "ContentNode")
        rowsContent.Update({
            children: gridRows
        },true)
        m.top.content.appendChildren(rowsContent.getChildren(-1,0))
        ' set field to trigger content change callback
        SetFailedLoading(false)
    else
        SetFailedLoading(true)
    end if
end sub

sub SetFailedLoading(flag as Boolean)
    m.top.content.Update({
        failedLoading: flag
    }, true)
end sub

Function GetGridContent(volume as Object, objectID as String, fileRet as Object) as Object
    lVerbose = isVerbose()
    fs = volume.fs
    searchStr = fs.searchStr
    print "GetGridContent--------------------- objID=";objectID;" searchStr=[";searchStr;"]"

    gs = m.GridStrings
    if gs = invalid
        gs = {}
        gs.dirHDPosterURL = GetLocalizedImage("poster_folder_fhd.png")
        gs.dirFHDPosterURL = GetLocalizedImage("poster_folder_fhd.png")
        gs.playlistHDPosterURL = GetLocalizedImage("poster_audio_fhd.png")
        gs.playlistFHDPosterURL = GetLocalizedImage("poster_audio_fhd.png")
        gs.movieHDPosterURL = GetLocalizedImage("poster_video_fhd.png")
        gs.movieFHDPosterURL = GetLocalizedImage("poster_video_fhd.png")
        gs.musicHDPosterURL = GetLocalizedImage("poster_audio_fhd.png")
        gs.musicFHDPosterURL = GetLocalizedImage("poster_audio_fhd.png")
        gs.photoHDPosterURL = GetLocalizedImage("poster_image_fhd.png")
        gs.photoFHDPosterURL = GetLocalizedImage("poster_image_fhd.png")

        gs.folderIconName1 = "folder.jpg"
        gs.folderIconName2 = "folder.png"
        gs.createFolder = createFolder
        gs.makeVFolder = makeVFolder
        m.GridStrings = gs
    endif

    result = []
    timer = CreateObject("roTimeSpan")
    mType = getMTFilter()
    objID = objectID
    sorting = getSorting()

    objIDTyped$ = objID + stri(mType) + stri(sorting)+"["+searchStr+"]"
    objIDBase$ = objID + stri(dirId()) + stri(sortingDefaultID())+"["+searchStr+"]"
    print "base=";objIDBase$" type=";objIDTyped$
    ' check for base existance and generation
    ' if m.gridcontentcache.doesExist(objIDBase$)
    '     basefoo = m.gridcontentcache.lookup(objIDBase$)
    '     newUpdateID = fs.GetUpdateID(objID)
    '     if basefoo.updateid = newUpdateID   'return cached value if dlna server says it hasn't changed
    '         print "updateIDs match=";basefoo.updateid;"    returning cache"
    '         ' retrieve typed
    '         if m.gridcontentcache.doesExist(objIDTyped$)
    '             foo = m.gridcontentcache.lookup(objIDTyped$)
    '             return foo.result
    '         else ' filtered and sorted doesn't exist, create it
    '             result2 = FilterByMediaType(basefoo.result, mType, sorting) 'filter
    '             if result2.count() > 0
    '                 foo = { updateID:newUpdateID
    '                         result: result2 }
    '                 m.gridcontentcache.addreplace(objIDTyped$, foo) 'save filtered
    '             endif
    '             return result2
    '         endif
    '     else ' we don't have latest version
    '         print "updateID mismatch, flush cache ";basefoo.updateID;"<>";newUpdateID
    '         m.gridcontentcache.delete(objIDBase$)
    '         m.gridcontentcache.delete(objIDTyped$)
    '     endif
    ' endif

    ' fileRet = fs.GetDirectoryListing(objID, waitScreen, searchStr)
    if type(fileRet) = "roString"
        ' probably a cancelled request
        print "GetGridContent returns:";files
        return fileRet
    endif
    files = fileRet.files

    filecount = files.count()
    print "updateID=";fileRet.updateID;" GetGridContent processing ";filecount; " files  time so far=";StrI(timer.TotalMilliseconds());" milliseconds"

    mediaFiles = {
        type:   mediaID()
        children:	createobject("roArray",filecount, false)
    }
    dircount = 5
    if filecount < dircount
        dircount = filecount
    endif
    folders = {
    	type: dirID()
    	children:	createobject("roArray",dircount, true)   ' allow resizing of folder array
    }

    for each file in files
        if (lVerbose) print "GetGridContent processing:"; file.title

        if file.isMedia = dirID() 'fileType = "directory"
            if searchStr = "" ' no containers if we are searching, we only want media
                newItem = gs.createFolder(file)
	            if volume.accessType = USBAccessType() ' usb
                    if file.isPlaylist
                        newItem.HDPosterUrl = gs.playlistHDPosterURL
                        newItem.FHDPosterUrl = gs.playlistFHDPosterURL
                        newItem.shortdescriptionLine2 = "playlist"
                        newItem.isPlaylist = true
                    else
                        newItem.isVFolder = file.isVFolder
                        posterUrl = ""
                        folderIconPath = makeNameFromPath(file.objectID, gs.folderIconName1)
                        if usb_FileExists(folderIconPath) then
                            posterUrl = folderIconPath
                        else
                            folderIconPath = makeNameFromPath(file.objectID, gs.folderIconName2)
                            if usb_FileExists(folderIconPath) then
                                posterUrl = folderIconPath
                            end if
                        end if
                        if posterUrl <> ""
                            newItem.SDPosterURL = posterUrl
                            newItem.HDPosterURL = posterUrl
                        end if
                    end if
                else ' dlna
                    if file.hdPosterUrl <> invalid
                        newItem.hdPosterUrl = file.hdPosterUrl
                    end if
	            end if
                newItem.objectID = file.ObjectID
                'newItem.vol = volume
                folders.children.Push(newItem)
            endif
        else
	        if file.isMedia = videoID() 'fileType = "video"
                if (lVerbose) print "is Video bitrate=";file.bitrate
                stream = {
                    url : file.url
                    bitrate : file.bitrate
                    quality : false ' SDs
                }
                newItem = {
                    Title:	            file.title
                    Description:	    file.Description
                    shortDescriptionLine1: file.title
                    streams:                [stream]
                    url:                file.url
                    streamFormat:       file.format
                    type:               file.isMedia
                    HDPosterURL:        gs.movieHDPosterURL
                    FHDPosterURL:        gs.movieFHDPosterURL
                    isDirectPlay:           not file.islive
                }
                newItem.guid = getGuid(volume, file.url)
                categories = CreateObject("roArray", 2, true)
                categories.push(file.formatname)
                newItem.Categories = categories
                if file.releaseDate <> invalid
                    newItem.releaseDate = file.releaseDate
                endif
                if file.rating <> invalid
                    if file.rating <> "Unknown" then newItem.rating = file.rating
                endif
                if file.subtitleUrl <> invalid
                    ' need to capture this
                    newItem.SubtitleUrl = file.subtitleUrl
                    newItem.SubtitleConfig = {
                        TrackName: file.subtitleurl
                    }
                endif

                if file.duration <> invalid
                    newItem.Length = file.duration
                    newItem.shortDescriptionLine2 = convertTimeToStr(newItem.Length)
                else
                    newItem.shortDescriptionLine2 = " "
                endif
                ' if display is HD attempt to set streamQuality
                ' If display is not HD, don't set it as it will prevent content from being played
                if file.resolution <> invalid
                    res = file.resolution
                    xPos = res.instr(0,"x")
                    xRes = res.left(xPos).toInt() ' int(val(res.left(xPos)))
                    yRes = res.mid(xPos + 1).toInt() 'int(val(res.mid(xPos+1)))
                    'print "xres=";xres;" yres=";yres;" xpos=";xpos;" mid=";res.mid(xpos)
                    if (yres >= 720) or (xres >= 1000)
                        newItem.isHD = true
                        newItem.HDBranded = true
                        if (yres > 1200) or (xres >3000)
                    newItem.SuperHDBranded = true
                        else
                    newItem.streamQualities = ["HD"]
                        endif
                    endif
                    if newItem.shortDescriptionLine2 = " "
                        newItem.shortDescriptionLine2 = file.resolution
                    else
                        newItem.shortDescriptionLine2 = newItem.shortDescriptionLine2 + " " + file.resolution
                    endif
                    ' categories.push(file.resolution)
                    newItem.Rating =file.resolution
                endif
                if file.size > 0
                    _size = formatBytes(file.size.tostr()).Trim()
                    categories.push(_size)
                endif
                if (file.format = "hls")
                    newItem.tricksAllowed = true    ' allow trickplay even when transcoded if this is hls
                else if  (file.islive = 1) or (file.format="ts") or (file.format="flv") then
                    newItem.tricksAllowed = false
                    newItem.noSeekMode = true
                else
                    newItem.tricksAllowed = true
                endif
            else if file.isMedia = audioID() 'fileType = "audio"
                if (lVerbose) print "is audio format=";file.format
                stream = {
                    url : file.url
                    bitrate : file.bitrate
                    size : file.size
                }
                newItem = {
                    Title:              file.title
                    Artist:             file.artist
                    artists:            [file.artist] ' for NowPlayingNode
                    Album:              file.album
                    stationTitle:       file.album ' for NowPlayingNode
                    Description:	    file.Description
                    streams:            [stream]
                    streamformat:       file.format
                    type:               file.isMedia
                    contentType:	    "audio"             ' used by springboard
                    shortDescriptionLine1: file.title
                    hdPosterURL: gs.musicHDPosterURL
                    fhdPosterURL: gs.musicFHDPosterURL
                }
                'categories = []
                'categories.push(file.format)
                'categories.push(file.bitrate)
                'newItem.Categories = categories
                newItem.guid = getGuid(volume, file.url)

                if file.genre <> invalid
                    newItem.releaseDate = file.genre + " | " + file.formatname
                else
                    newItem.releaseDate = " | " + file.formatname
                endif
                if file.bitrate <> invalid
                    if file.bitrate <> 0
                        newItem.releaseDate = newItem.releaseDate + " | " + file.bitrate.tostr() + "Kbps"
                    endif
                endif
                if file.size > 0
                    _size = formatBytes(file.size.tostr()).Trim()
                    newItem.releaseDate = newItem.releaseDate + " | " + _size
                endif
                if file.releaseDate <> invalid
                    newItem.releaseDate = file.releaseDate + " | " + newItem.releasedate
                endif
                if file.duration <> invalid
                    newItem.Length = file.duration
                    newItem.shortDescriptionLine2 = convertTimeToStr(newItem.Length)
                else
                    newItem.shortDescriptionLine2 = " "
                endif
                if file.islive = 1 then
                    newItem.tricksAllowed = false
                    newItem.noSeekMode = true
                else
                    newItem.tricksAllowed = true
                end if
            else if file.isMedia = pictureID() 'fileType = "picture"
                allowAdd = true
                if volume.accessType = USBAccessType() then  ' usb?
                    lcLine1 = lcase(file.shortDescriptionLine1)
                    if lcLine1 = gs.folderIconName1 or lcLine1 = gs.folderIconName2 then
                        allowAdd = false
                        newItem = invalid
                    end if
                end if
                if (lVerbose) print "picture:file.d=";file.description;" line1=";file.shortDescriptionLine1;" title=";file.title;" allow add=";allowAdd
                if allowAdd = true then
                    newItem = {
                        Title:          file.Title
                        Description:	file.TextOverlayUL
                        url:		file.url
                        hdPosterURL:	gs.photoHDPosterURL 'category.path + "/" + file
                        fhdPosterURL:	gs.photoFHDPosterURL 'category.path + "/" + file
                        type:		file.isMedia
                        doNotCache:     true 'tells the gridscreen to bypass cache / download / scale directly
                        shortDescriptionLine1: file.Title
                        shortDescriptionLine2: " "
                    }
                    if file.datetimesort <> invalid
                        newItem.dateTimeSort = file.dateTimeSort
                    endif
                    if file.format = "gif"
                    newItem.doNotCache = false
                    endif
                    if file.shortDescriptionLine1 <> invalid
                        newitem.TextOverlayBody = file.shortDescriptionLine1
                    endif
                    if file.TextOverlayUL <> invalid and file.TextOverlayUL <> ""
                        newitem.TextOverlayUL = file.TextOverlayUL
                        newitem.shortDescriptionLine2 = file.TextOverlayUL
                    else
                        newitem.TextOverlayUL = ""
                    endif
                    'if file.resolution <> invalid
                    '   newItem.shortDescriptionLine2 = file.resolution
                    'endif
                end if
            end if
            if newItem <> invalid then
                ' if poster art provided use
                if file.hdPosterUrl <> invalid and file.hdPosterUrl <> "" and file.hdPosterUrl <> " "
                    newItem.sdPosterURL = file.sdPosterURL
                    newItem.hdPosterURL = file.hdPosterURL
                    newItem.fhdPosterURL = file.fhdPosterURL
                endif
                ' if the posters are in /tmp disable the download cache, they are already cached in /tmp
                'print "ContentScreen: hdposter=";newItem.hdPosterURL
                'if left(newItem.hdPosterURL, 4) = "tmp:"
                '    print "Found poster in /tmp - turn off cache"
                '    newItem.doNotCache = true
                'endif

                ' for info button (not used right now so comment it out for speed and memory)
                'if file.Debugformat <> invalid
                '    newItem.Debugformat = file.Debugformat
                'endif
                if file.track <> invalid
                    newItem.track = file.track
                end if
                newItem.objectID = file.ObjectID
                'newItem.vol = volume
                'PrintAA(newItem)
                mediaFiles.children.Push(newItem)
            end if ' newItem <> invalid
        end if ' not folder
    next   'file

    ' if this is at the top level and not searching
    if objectID=GetRootObjectID() and searchstr = ""
        ' insert the default playlist
        'folders.children.push(getdefaultPlaylist())
        if volume.accessType = USBAccessType()  ' USB
            if mType = AudioID() then
                mC = volume.fs.metaCaches
                if mC <> invalid
                    if mC.genre.count() > 0
                        folders.children.push(gs.makeVFolder("Genre",tr("by Genre")))
                    endif
                    if mC.artist.count() > 0
                        folders.children.push(gs.makeVFolder("Artist",tr("by Artist")))
                    endif
                    if mC.album.count() > 0
                        folders.children.push(gs.makeVFolder("Album",tr("by Album")))
                    endif
                endif
            endif
        endif
    endif
    'apply media type filter and sorting
    result = FilterByMediaType(folders, mediaFiles.children, mType, sorting)

    'save base
    ' if result.count() > 0
    '     result = FilterByMediaType(result, dirId(), sortingDefaultID())
    '     print "GetGridontent:cache save objIDBase=";objIDBase$;" updateID=";fileRet.updateID
    '     if volume.accessType <> USBAccessType()
    '         foo = { updateid: fileRet.updateid
    '             result : result }
    '         m.gridcontentcache.addreplace(objIDBase$, foo)
    '     endif
    ' endif

    ' if objIDBase$ <> objIDTyped$ 'check so we don't copy once more
    '     result = FilterByMediaType(result, mType, sorting) 'filter
    '     if volume.accessType <> USBAccessType()
    '       if result.count() > 0 ' if not empty add to cache"
    '         print "GetGridContent:cache save objIDTyped=";objIDTyped$;" updateID=";fileRet.updateid
    '         foo = { updateid: fileRet.updateid
    '             result : result }
    '         m.gridcontentcache.addreplace(objIDTyped$, foo)
    '       endif
    '     endif
    ' end if

    print "return from GetGridContent in ";StrI(timer.TotalMilliseconds());" milliseconds"
    return result
End Function

function createFolder(file)
    newItem = {
        Title:	        file.title
        type:	        dirID()
        HDPosterURL:    m.dirHDPosterURL
        FHDPosterURL:    m.dirFHDPosterURL
        shortDescriptionLine1: file.ShortDescriptionLine1
        shortDescriptionLine2: " "
        itemsCountByMediaType: []
        isPlaylist:     false
        isVFolder:      false
    }
    return newItem
end function

function makeVFolder(k,s)
   yy = "< " + s + " >"
   y = {
       title: yy
       ShortDescriptionLine1 : yy
   }
   z = m.createfolder(y)
   z.objectID = "?0?" + k
   z.isVFolder = true
   return z
end function

function usb_FileExists(path) as Boolean
    if m.rofs = invalid
        m.rofs = CreateObject("roFileSystem")
    end if
    if m.rofs.Exists(path)
        info = m.rofs.Stat(path)
        if info.type = "file"
            return true
        endif
    endif
    return false
end function

function IsValidListing(listing as Object)
    return (listing <> invalid) and (listing.files <> invalid) and (listing.files.Count() > 0)
end function
