' ********** Copyright 2019 Roku Corp. All Rights Reserved. **********

sub init()
    m.top.functionName = "ReadConfig"
end sub

sub ReadConfig()
    m.app = CreateObject("roAppManager")
    m.manifest = Util_GetManifest()

    configObj = Config()

    configObj.AddSet("Playlists", true)
    configObj.AddSet("registryPrefix", "")


    configObj.AddSet("VoiceOnly", false)
    if m.manifest["VoiceOnly"] = "1"
        configObj.AddSet("VoiceOnly", true)
        configObj.AddSet("registryPrefix", "RAP-")
    end if

    configObj.AddSet("AudioOnly", false)
    if m.manifest["AudioOnly"] = "1"
        configObj.AddSet("AudioOnly", true)
        configObj.AddSet("registryPrefix", "RAP-")
    end if

    configObj.AddSet("enableButtonBar", false)
    if m.manifest["enable_button_bar"] = "1"
        configObj.AddSet("enableButtonBar", true)
    end if

    configObj.AddSet("hasVoiceAdapter", m.manifest["has_voice_adapter"] = "1")
    isPro = m.manifest["rmppro"] = "1"
    configObj.AddSet("isPro", isPro)
    configObj.AddSet("useSharedHttpServers", isPro)
    configObj.AddSet("allowBobDescription", isPro)

    configObj.AddSet("AllMediaFilterEnabled", true)
    configObj.AddSet("enableHTTPFS", true)
    configObj.AddSet("enableDLNA", true)
    configObj.AddSet("romOnly", m.manifest["rom_only"] = "1")

    if m.manifest["usbonly"] <> invalid and m.manifest["usbonly"] = "1"
        configObj.AddSet("enableHTTPFS", false)
        configObj.AddSet("enableDLNA", false)
        configObj.AddSet("romOnly", true)
    endif

    validURLRegStr = "^http(?:s)?\:\/\/((\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})|[a-zA-Z0-9\-]+(?:\.[a-zA-Z0-9\-]+)*\.[a-zA-Z]{2,6})(|\:(\d{1,5}))(\/.*|)$"
    regexIsValidURL = CreateObject("roRegex", validURLRegStr , "")

    di = CreateObject("roDeviceInfo")
    version = di.GetVersion()

    deviceInfo = {
        model: di.GetModel()
        major: Val(Mid(version, 3, 1))
        minor: Val(Mid(version, 5, 2))
        build: Val(Mid(version, 8, 5))
        hasUSB: di.HasFeature("usb_hardware")
    }

    firmwareVmajor = deviceInfo.major
    firmwareVminor = deviceInfo.minor

    if firmwareVmajor>6
        appInfo = CreateObject("roAppInfo")
        appID = appInfo.GetID()
        ? "AppInfo ID: ";appID
        if configObj.GetFromGlobal("registryPrefix") = ""
            ' standard rmp,
            ' is this dev, beta, alpha?
            if appID <> "2213"
                configObj.AddSet("registryPrefix", appID + "-")
            endif
        endif
    endif

    ? "Registry Prefix: " ; configObj.GetFromGlobal("registryPrefix")

    model = deviceInfo.model
    first4ModelDigits = model.left(4)

    isTV = (first4ModelDigits = "5000") or (first4ModelDigits = "8000") ' = isliberty or ismidland
    ' hack until liberty can tell us itself that it can do more
    isAustin = (first4ModelDigits = "4200")

    is4k = false
    if (first4ModelDigits = "4400") ' Dallas
        is4k = true
    else if (first4ModelDigits="4640") or (first4ModelDigits="4630") or (first4ModelDigits="4620") ' MStar - cooper, etc.
        is4k = true
    else if not isTV
        if (model.left(1) = "6") or (model.left(1) = "7") ' todo - fixme, need something more specific here Fort Worth
            is4k = true
            isTV = true ' also enable liberty base features
        endif
    endif

    ? "Device info: " ; deviceInfo

    CECAutoshutdown = di.HasFeature("cecautoshutdown") or is4k
    if CECAutoshutdown
        m.app.enableNoSignalTimer(CECAutoshutdown)
    endif
    ? "CECAutoshutdown=";CECAutoshutdown

    ' default config fields
    configObj.AddSet("connectionTimeout", 30)
    configObj.AddSet("AudioOptionsStolen", false)
    configObj.AddSet("hasCacheFS", false)
    configObj.AddSet("hasISODate", false)
    configObj.AddSet("hasSizeEx", false)
    configObj.AddSet("isBreadCrumbSupported", true)
    configObj.AddSet("isGlobalSubtitle", false)
    configObj.AddSet("lastObjectId", invalid)
    configObj.AddSet("mediaTypeFiltering", getDefaultFiltering())
    configObj.AddSet("mediaSorting", getDefaultSorting())
    configObj.AddSet("linkStatusSupported", false)
    configObj.AddSet("removalDetected", false)
    configObj.AddSet("removedVolume", invalid)
    configObj.AddSet("isUpSupported", false)
    configObj.AddSet("isTrickControlSupported", false)
    configObj.AddSet("closedCaptionUI", false)
    configObj.AddSet("multipleSubtitleUrls", false)
    configObj.AddSet("subTitleFW10071", false)
    configObj.AddSet("localBif", false)
    configObj.AddSet("upExitsGrid", true) ' in case they have a remote without the BACK button (really old Roku's)

    'Breadcrumbs are supported from v 4.8
    deviceInfo.hasAutoDetect = false
    deviceInfo.hasFLV = false
    deviceInfo.hasAC3 = false        ' can we demux ac3 (dolby digital) files?
    deviceInfo.hasEAC3 = false        ' can we demux eac3 (dolby digital plus) files?
    deviceInfo.hasMat = false        ' can we demux mat (dolby digital mat,mpl) files?
    deviceInfo.hasAC4 = false        ' can we demux ac4 dolby files
    deviceInfo.hasDTS = false
    deviceInfo.hasFlac = true
    deviceInfo.is7dot5 = false
    deviceInfo.hasOgg = false
    deviceInfo.hasalac = false
    deviceInfo.hasAac = true
    deviceInfo.hasAac51 = false
    deviceInfo.hasPCM = true                  ' .wav .aiff .au
    deviceInfo.hasMPEG2 = isTV
    deviceInfo.hasH265 = is4k
    deviceInfo.hasWMV = false
    deviceInfo.hasASF = false
    deviceInfo.hasVC1 = false
    deviceInfo.hasVP9 = false
    deviceInfo.hasDolbyDigital = isTV
    deviceInfo.hasNativeAC3 = isTV
    deviceInfo.hasNativeEAC3 = isTV
    deviceInfo.surroundSound = di.HasFeature("5.1_surround_sound")

    configObj.AddSet("hasExtFS", false)
    configObj.AddSet("hasDynamicSubtitleMode", false)
    configObj.AddSet("dimensionCheckDisabled", GetDimensionCheckDisabled()) ' retrieve from registry
    configObj.AddSet("autorunDisabled", GetAutorunDisabled()) ' retrieve from registry

    ' default max video decode resolutions
    configObj.AddSet("maxVideoRowsLS", 1080+8) ' landscape max video decode dimensions
    configObj.AddSet("maxVideoColsLS", 1920+16)
    configObj.AddSet("maxVideoRowsPT", 1280) ' portrait max video decode dimensions
    configObj.AddSet("maxVideoColsPT", 720+16)
    configObj.AddSet("gifMAXsize", 2048*2048) ' this limits width*height
    configObj.AddSet("maxThumbPixels", 1280*768)

    ' FIXME
    ' m.defaultPlaylist = CreatePlaylist("default")

    if firmwareVmajor > 4 'since 5.2 up behavior on list screen
        configObj.AddSet("linkStatusSupported", true)
        configObj.AddSet("isTrickControlSupported", true)
        configObj.AddSet("UpExitsGrid", false)
        if firmwareVmajor = 5
            if firmwareVminor >= 3
                configObj.AddSet("isUpSupported", true)
                configObj.AddSet("isGlobalSubtitle", true)
            end if
            if firmwareVminor >= 4
                configObj.AddSet("closedCaptionUI", false)
                configObj.AddSet("multipleSubtitleUrls", true)
            end if
            if firmwareVminor >= 5
                configObj.AddSet("localBif", true)
            end if
        else ' 6 and up
            deviceInfo.hasAC3 = deviceInfo.surroundSound ' for 6.0
            deviceInfo.hasFLV = true
            deviceInfo.hasASF = true
            configObj.AddSet("localBif", true)
            configObj.AddSet("isGlobalSubtitle", true)
            configObj.AddSet("isUpSupported", true)
            configObj.AddSet("closedCaptionUI", false)
            configObj.AddSet("multipleSubtitleUrls", true)
            configObj.AddSet("hasDynamicSubtitleMode", true)

            if (firmwareVmajor > 6) or (firmwareVminor > 0) then ' 6.1 or later
                  audioDecoders = di.GetAudioDecodeInfo()
                  ? "List of audio decoders"
                  ? audioDecoders

                  if audioDecoders.doesexist("AC3")
                      deviceInfo.hasDolbyDigital = true ' codec
                      ' look for native dolby decode
                      ' AC3: "6:0:0:0:"
                      t = audioDecoders.AC3
                      if t.right(2) = "0:"
                          deviceInfo.hasNativeAC3 = true
                      end if
                  end if
                  deviceInfo.hasDolbyDigitalPlus = false
                  if audioDecoders.doesexist("DD+")
                      deviceInfo.hasDolbyDigitalPlus = true ' codec
                      ' look for native dd+ decode
                      ' AC3: "6:0:0:0:"
                      t = audioDecoders["DD+"]
                      if t.right(2) = "0:"
                          deviceInfo.hasNativeEAC3 = true ' probably Cooper 1
                      end if
                  end if

                  deviceInfo.hasDTS = audioDecoders.doesexist("DTS")
                  'deviceInfo.hasMAT = audioDecoders.doesexist("MAT")
                  deviceInfo.hasAC4 = audioDecoders.doesexist("AC4")
                  deviceInfo.hasAC3 = deviceInfo.hasDolbyDigital ' container
                  deviceInfo.hasEAC3 = deviceInfo.hasDolbyDigitalPlus ' container
                  if audioDecoders.AAC.left(1) <> "2"
                      deviceInfo.hasAAC51 = true
                  end if
                  videoDecoders = di.GetVideoDecodeInfo()
                  ? "List of video decoders"
                  ? videoDecoders
                  deviceInfo.hasVC1 = videoDecoders.doesexist("VC1")
            end if
            if firmwareVmajor > 6 ' 7.0 and up
                deviceInfo.hasAlac = true
                configObj.AddSet("hasISODate", true)
                configObj.AddSet("allowBobDescription", true)

                ' special for 4k devices
                if (firmwareVmajor = 7) and (firmwareVminor = 50)
                    deviceInfo.is7dot5 = true
                end if
                if (firmwareVmajor > 7) or (firmwareVminor > 0)
                    ' 7.1 and up
                    configObj.AddSet("hasExtFS", true)
                end if
                if (firmwareVmajor > 7) or (firmwareVminor >= 60)
                    ' 7.6 and up
                    deviceInfo.hasOgg = true
                    if (firmwareVmajor > 7) or (firmwareVminor > 60) or (deviceinfo.build >= 4104)
                        configObj.AddSet("connectionTimeout", int(99999 + 30)) ' disable multiple requests
                    end if
                end if

                if (firmwareVmajor > 7) ' 8.0 and up
                    ' for telstra 8.0.6 CanDecodeVideo fails
                    if (firmwareVmajor=8) and (firmwareVminor=6)
                        isTV = false
                    else
                        isTV = (di.GetModelType() = "TV")
                        if isTV
                            deviceInfo.hasNativeDolbyDigital = true
                        end if
                    end if

                    foo = di.CanDecodeVideo({Codec: "mpeg2", Level: "main"})
                    deviceInfo.hasMPEG2 = foo.result
                    foo = di.CanDecodeVideo({Codec: "vp9", Profile: "profile 0", Level: "4.0"})
                    deviceInfo.hasVP9 = foo.result
                    foo = di.CanDecodeVideo({Codec: "hevc", Profile: "main", Level: "4.1"})
                    deviceInfo.hasH265 = foo.result
                    deviceInfo.hasAutoDetect = true
                    if deviceInfo.hasH265
                        is4k = true
                    end if
                    if (firmwareVmajor > 8) or (firmwareVminor >= 10) ' must be spring2018 (8.1) or later
                        configObj.AddSet("SubTitleFW10071", true)
                        configObj.AddSet("hasSizeEx", true)
                    end if
                    configObj.AddSet("NPSSupported", true) ' NowPlayingScreen
                    if (firmwareVmajor = 8) and (firmwareVminor < 20) ' must be fall2018 (8.2) or later
                        configObj.AddSet("NPSSupported", false)
                    end if
                    if (firmwareVmajor > 8)
                        if (not isUSBOnly())
                            configObj.AddSet("hasCacheFS", true)
                            ' look for 9.1.0.4034 or later
                            if (firmwareVmajor > 9)  or (firmwareVminor > 10) or ((deviceinfo.build >= 4034) and (firmwareVminor = 10))
                                configObj.AddSet("hasGoodCacheFS", true)
                            end if
                        end if
                        if (firmwareVmajor > 9)  or (firmwareVminor >= 10)   ' 9.1 or later
                            if isTV
                                configObj.AddSet("AudioOptionsStolen", true)
                            end if
                        end if
                    end if   ' >8
                end if ' > 7
            end if ' >6
        end if
    end if
    ' Not sure why we care about linkStatus - so disable using it for now
    configObj.AddSet("linkStatusSupported", false)
    if configObj.IsTrue("linkStatusSupported")
        di.EnableLinkStatusEvent(true)
    end if

    deviceInfo.hasSPDIF = di.HasFeature("spdif_hardware")
    deviceInfo.has_sdcard_hardware = di.HasFeature("sdcard_hardware")
    configObj.AddSet("isHD", di.GetDisplayType() = "HDTV")
    configObj.AddSet("subtitleMode", GetSavedSubtitleMode()) ' returns "On", "Off", "Instant replay"
    configObj.AddSet("platformHasAudioMetaData", true)
    configObj.AddSet("mediaTypeFilters", [tr("All"),tr("Video"), tr("Audio"), tr("Photo")])
    configObj.AddSet("loopDir", false)
    ? "SubtitleMode=";configObj.GetFromGlobal("subtitleMode")

    configObj.AddSet("maxUPNPRequest", 10)
    if isAustin or is4k
        configObj.AddSet("maxUPNPRequest", 20)
    end if

    if isTV or is4k
        deviceInfo.hasAAC51 = true
    end if

    if isAustin or isTV
        configObj.AddSet("gifMAXsize", 4096*4096)
        configObj.AddSet("maxThumbPixels", 1920*1080)
    end if

    if is4k
        configObj.AddSet("gifMAXsize", 7680*4320) ' hardware limitation for 4k and upper devices
        configObj.AddSet("maxThumbPixels", 1920*1080)
        configObj.AddSet("maxVideoRowsLS", 2160+16)
        configObj.AddSet("maxVideoColsLS", 3840+32)
        configObj.AddSet("maxVideoRowsPT", 3840)
        configObj.AddSet("maxVideoColsPT", 2160+32)
        deviceInfo.hasVP9 = true
    end if

    videoMode = di.GetVideoMode()
    left3VideoMode = videoMode.left(3)
    configObj.AddSet("maxPhotoScale", 3.0) ' default for 720x1280 frame buffer
    if left3VideoMode = "480"
        configObj.AddSet("maxPhotoScale", 2.0)
    end if
    if is4k
        ' 4k tv and roku-4 use higer res frame buffer
        if left3VideoMode = "216"
            configObj.AddSet("maxPhotoScale", 9.0) ' 4k frame buffer
        else if left3VideoMode = "108"
            configObj.AddSet("maxPhotoScale", 4.5) ' 1080p frame buffer
        end if
    end if
    ? "Max Photo Scale=";configObj.GetFromGlobal("maxPhotoScale")

    ' Do all UserAgent setup now, this should be done on a per dlna server basis eventually
    ' This was primarily setup for Plex
    configObj.AddSet("UserAgentHeader", "")
    ' Initialize useUserAgent to just Liberty platform
    if isTV
        if firmwareVmajor > 6
            configObj.AddSet("UserAgentHeader", "Roku/5000X-7")
        else
            configObj.AddSet("UserAgentHeader", "Roku/5000X")
        end if
    end if
    'if isAustin
    '  m.UserAgentHeader = "Roku/4000X"
    'end if
    if not isTV
        configObj.AddSet("UserAgentHeader", "Roku/DVP-6.x") ' override for Plex for now ... sigh
    end if
    if is4k
         if isTV
            configObj.AddSet("UserAgentHeader", "Roku/6000X-7")
         else
            configObj.AddSet("UserAgentHeader", "Roku/4400X")
         end if
    end if
    if configObj.GetFromGlobal("UserAgentHeader") <> ""
        print "Setting user-agent to:";configObj.GetFromGlobal("UserAgentHeader")
    end if

    ' Get UserAgent custom override
    configObj.AddSet("userAgents", GetUserAgents())
    configObj.AddSet("DLNAFav", GetDLNAFavorite())
    configObj.SetDeviceInfo(deviceInfo)

    configObj.AddSet("useNWM", false)
    configObj.UpdateLocal()

    ' only enable artwork lookup if we have a usb port, and we have dlna enabled (not USB only)
    ' this will save time from trying to query a likely non-existent network connection
    if hasUSB() and useDLNA() and not GetAlbumArtFromWebDisabled()
        ' Not clear to me we always want to use this service, it may slow processing down too much.
        ' And it has not been converted to dispatcher event model
        ' provide a variable to enable/disable it
        configObj.AddSet("useNWM", true)
    endif

    m.top.done = true
end sub
