'*********************************************************************
'** (c) 2018 Roku, Inc.  All content herein is protected by U.S.
'** copyright and other applicable intellectual property laws and may
'** not be copied without the express permission of Roku, Inc., which
'** reserves all rights.  Reuse of any of this content for any purpose
'** without the permission of Roku, Inc. is strictly prohibited.
'*********************************************************************
' Platform.brs
' Utilities for Roku Patform checks

function RokuMfgGetChipType() as String
    return getGlobalAA().mfg_constants.sysInfo.chipType
end function

function RokuMfgIsChipType(comp as String) as Boolean
    return lcase(comp) = left(lcase(RokuMfgGetChipType()), len(comp))
end function

function RokuMfgIsSigmaPlatform() as Boolean
    return RokuMfgIsChipType("sigma")
end function

function RokuMfgIsMStarPlatform() as Boolean
    return RokuMfgIsChipType("mstar")
end function

function RokuMfgIsRealtekPlatform() as Boolean
    return RokuMfgIsChipType("rtd")
end function

function RokuMfgGetDeviceType() as String
    return getGlobalAA().mfg_constants.sysInfo.deviceType
end function

function RokuMfgIsDeviceType(comp as String) as Boolean
    return lcase(comp) = left(lcase(RokuMfgGetDeviceType()), len(comp))
end function

function RokuMfgIsTVPlatform() as Boolean
    return RokuMfgIsDeviceType("tv")
end function
