'*********************************************************************
'** (c) 2018 Roku, Inc.  All content herein is protected by U.S.
'** copyright and other applicable intellectual property laws and may
'** not be copied without the express permission of Roku, Inc., which
'** reserves all rights.  Reuse of any of this content for any purpose
'** without the permission of Roku, Inc. is strictly prohibited.
'*********************************************************************
' Roku_MFG_State_Store.brs
' Wraps generic data storage with getter/setter functions

function RokuMfgState_StoreModuleInit() as Object
    o = {
        store: {}

        get: RokuMfgState_StoreGet,
        set: RokuMfgState_StoreSet,
        unset: RokuMfgState_StoreUnset
    }

    return o
end function

function RokuMfgState_StoreSet(key as String, value as Dynamic) as Boolean
    m.store[lcase(key)] = value
    return true
end function

function RokuMfgState_StoreGet(key as String) as Dynamic
    return m.store[lcase(key)]
end function

function RokuMfgState_StoreUnset(key as String) as Dynamic
    return m.store.delete(lcase(key))
end function
